/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.describe;

import boofcv.alg.descriptor.UtilFeature;
import boofcv.alg.feature.describe.DescribePointSurf;
import boofcv.struct.feature.BrightFeature;
import boofcv.struct.feature.TupleDesc_F64;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.Planar;

public class DescribePointSurfPlanar<II extends ImageGray> {
    private DescribePointSurf<II> describe;
    private int descriptorLength;
    private II grayII;
    private Planar<II> ii;
    private TupleDesc_F64 bandDesc;
    private int numBands;

    public DescribePointSurfPlanar(DescribePointSurf<II> describe, int numBands) {
        this.describe = describe;
        this.numBands = numBands;
        this.bandDesc = new TupleDesc_F64(describe.getDescriptionLength());
        this.descriptorLength = describe.getDescriptionLength() * numBands;
    }

    public BrightFeature createDescription() {
        return new BrightFeature(this.descriptorLength);
    }

    public int getDescriptorLength() {
        return this.descriptorLength;
    }

    public Class<BrightFeature> getDescriptionType() {
        return BrightFeature.class;
    }

    public void setImage(II grayII, Planar<II> integralImage) {
        this.grayII = grayII;
        this.ii = integralImage;
    }

    public void describe(double x, double y, double angle, double scale, BrightFeature desc) {
        int featureIndex = 0;
        for (int band = 0; band < this.ii.getNumBands(); ++band) {
            this.describe.setImage(this.ii.getBand(band));
            this.describe.describe(x, y, angle, scale, this.bandDesc);
            System.arraycopy(this.bandDesc.value, 0, desc.value, featureIndex, this.bandDesc.size());
            featureIndex += this.bandDesc.size();
        }
        UtilFeature.normalizeL2(desc);
        this.describe.setImage(this.grayII);
        desc.white = this.describe.computeLaplaceSign((int)(x + 0.5), (int)(y + 0.5), scale);
    }

    public DescribePointSurf<II> getDescribe() {
        return this.describe;
    }

    public int getNumBands() {
        return this.numBands;
    }
}

