/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.disparity.impl;

import boofcv.alg.feature.disparity.DisparityScoreSadRect;
import boofcv.alg.feature.disparity.DisparitySelect;
import boofcv.alg.feature.disparity.impl.UtilDisparityScore;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.ImageGray;

public class ImplDisparityScoreSadRect_S16<Disparity extends ImageGray>
extends DisparityScoreSadRect<GrayS16, Disparity> {
    DisparitySelect<int[], Disparity> computeDisparity;
    int[] elementScore;
    int[][] horizontalScore;
    int[] verticalScore;

    public ImplDisparityScoreSadRect_S16(int minDisparity, int maxDisparity, int regionRadiusX, int regionRadiusY, DisparitySelect<int[], Disparity> computeDisparity) {
        super(minDisparity, maxDisparity, regionRadiusX, regionRadiusY);
        this.computeDisparity = computeDisparity;
    }

    @Override
    public void _process(GrayS16 left, GrayS16 right, Disparity disparity) {
        if (this.horizontalScore == null || this.verticalScore.length < this.lengthHorizontal) {
            this.horizontalScore = new int[this.regionHeight][this.lengthHorizontal];
            this.verticalScore = new int[this.lengthHorizontal];
            this.elementScore = new int[left.width];
        }
        this.computeDisparity.configure(disparity, this.minDisparity, this.maxDisparity, this.radiusX);
        this.computeFirstRow(left, right);
        this.computeRemainingRows(left, right);
    }

    private void computeFirstRow(GrayS16 left, GrayS16 right) {
        for (int row = 0; row < this.regionHeight; ++row) {
            int[] scores = this.horizontalScore[row];
            UtilDisparityScore.computeScoreRow(left, right, row, scores, this.minDisparity, this.maxDisparity, this.regionWidth, this.elementScore);
        }
        for (int i = 0; i < this.lengthHorizontal; ++i) {
            int sum = 0;
            for (int row = 0; row < this.regionHeight; ++row) {
                sum += this.horizontalScore[row][i];
            }
            this.verticalScore[i] = sum;
        }
        this.computeDisparity.process(this.radiusY, this.verticalScore);
    }

    private void computeRemainingRows(GrayS16 left, GrayS16 right) {
        for (int row = this.regionHeight; row < left.height; ++row) {
            int i;
            int oldRow = row % this.regionHeight;
            int[] scores = this.horizontalScore[oldRow];
            for (i = 0; i < this.lengthHorizontal; ++i) {
                int n = i;
                this.verticalScore[n] = this.verticalScore[n] - scores[i];
            }
            UtilDisparityScore.computeScoreRow(left, right, row, scores, this.minDisparity, this.maxDisparity, this.regionWidth, this.elementScore);
            for (i = 0; i < this.lengthHorizontal; ++i) {
                int n = i;
                this.verticalScore[n] = this.verticalScore[n] + scores[i];
            }
            this.computeDisparity.process(row - this.regionHeight + 1 + this.radiusY, this.verticalScore);
        }
    }

    @Override
    public Class<GrayS16> getInputType() {
        return GrayS16.class;
    }

    @Override
    public Class<Disparity> getDisparityType() {
        return this.computeDisparity.getDisparityType();
    }
}

