/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.associate;

import boofcv.abst.feature.associate.AssociateDescription;
import boofcv.alg.feature.associate.AssociateGreedy;
import boofcv.alg.feature.associate.FindUnassociated;
import boofcv.struct.feature.AssociatedIndex;
import boofcv.struct.feature.MatchScoreType;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_I32;

public class WrapAssociateGreedy<T>
implements AssociateDescription<T> {
    AssociateGreedy<T> alg;
    FastQueue<AssociatedIndex> matches = new FastQueue(10, AssociatedIndex.class, true);
    FastQueue<T> listSrc;
    FastQueue<T> listDst;
    GrowQueue_I32 unassocSrc = new GrowQueue_I32();
    FindUnassociated unassociated = new FindUnassociated();

    public WrapAssociateGreedy(AssociateGreedy<T> alg) {
        this.alg = alg;
    }

    @Override
    public void setSource(FastQueue<T> listSrc) {
        this.listSrc = listSrc;
    }

    @Override
    public void setDestination(FastQueue<T> listDst) {
        this.listDst = listDst;
    }

    @Override
    public FastQueue<AssociatedIndex> getMatches() {
        return this.matches;
    }

    @Override
    public void associate() {
        if (this.listSrc == null) {
            throw new IllegalArgumentException("source features not specified");
        }
        if (this.listDst == null) {
            throw new IllegalArgumentException("destination features not specified");
        }
        this.unassocSrc.reset();
        this.alg.associate(this.listSrc, this.listDst);
        int[] pairs = this.alg.getPairs();
        double[] score = this.alg.getFitQuality();
        this.matches.reset();
        for (int i = 0; i < this.listSrc.size; ++i) {
            int dst = pairs[i];
            if (dst >= 0) {
                ((AssociatedIndex)this.matches.grow()).setAssociation(i, dst, score[i]);
                continue;
            }
            this.unassocSrc.add(i);
        }
    }

    @Override
    public GrowQueue_I32 getUnassociatedSource() {
        return this.unassocSrc;
    }

    @Override
    public GrowQueue_I32 getUnassociatedDestination() {
        return this.unassociated.checkDestination(this.matches, this.listDst.size);
    }

    @Override
    public void setThreshold(double score) {
        this.alg.setMaxFitError(score);
    }

    @Override
    public MatchScoreType getScoreType() {
        return this.alg.getScore().getScoreType();
    }

    @Override
    public boolean uniqueSource() {
        return true;
    }

    @Override
    public boolean uniqueDestination() {
        return this.alg.isBackwardsValidation();
    }
}

