/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.associate;

import boofcv.abst.feature.associate.ScoreAssociation;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_F64;
import org.ddogleg.struct.GrowQueue_I32;

public class AssociateGreedy<D> {
    private ScoreAssociation<D> score;
    private double maxFitError = Double.MAX_VALUE;
    private GrowQueue_F64 fitQuality = new GrowQueue_F64(100);
    private GrowQueue_I32 pairs = new GrowQueue_I32(100);
    private GrowQueue_F64 workBuffer = new GrowQueue_F64(100);
    private boolean backwardsValidation;

    public AssociateGreedy(ScoreAssociation<D> score, boolean backwardsValidation) {
        this.score = score;
        this.backwardsValidation = backwardsValidation;
    }

    public void associate(FastQueue<D> src, FastQueue<D> dst) {
        int i;
        this.fitQuality.reset();
        this.pairs.reset();
        this.workBuffer.reset();
        this.fitQuality.setMaxSize(src.size);
        this.workBuffer.setMaxSize(src.size * dst.size);
        for (i = 0; i < src.size; ++i) {
            Object a = src.data[i];
            double bestScore = this.maxFitError;
            int bestIndex = -1;
            for (int j = 0; j < dst.size; ++j) {
                Object b = dst.data[j];
                double fit = this.score.score(a, b);
                this.workBuffer.push(fit);
                if (!(fit <= bestScore)) continue;
                bestIndex = j;
                bestScore = fit;
            }
            this.pairs.push(bestIndex);
            this.fitQuality.push(bestScore);
        }
        if (this.backwardsValidation) {
            block2: for (i = 0; i < src.size; ++i) {
                int match = this.pairs.data[i];
                if (match == -1) continue;
                double scoreToBeat = this.workBuffer.data[i * dst.size + match];
                int j = 0;
                while (j < src.size) {
                    if (this.workBuffer.data[match] <= scoreToBeat && j != i) {
                        this.pairs.data[i] = -1;
                        this.fitQuality.data[i] = Double.MAX_VALUE;
                        continue block2;
                    }
                    ++j;
                    match += dst.size;
                }
            }
        }
    }

    public int[] getPairs() {
        return this.pairs.data;
    }

    public double[] getFitQuality() {
        return this.fitQuality.data;
    }

    public void setMaxFitError(double maxFitError) {
        this.maxFitError = maxFitError;
    }

    public ScoreAssociation<D> getScore() {
        return this.score;
    }

    public boolean isBackwardsValidation() {
        return this.backwardsValidation;
    }
}

