/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.describe;

import boofcv.alg.feature.describe.DescribeSiftCommon;
import boofcv.core.image.FactoryGImageGray;
import boofcv.core.image.GImageGray;
import boofcv.struct.feature.TupleDesc_F64;
import boofcv.struct.image.ImageGray;
import georegression.metric.UtilAngle;

public class DescribePointSift<Deriv extends ImageGray>
extends DescribeSiftCommon {
    GImageGray imageDerivX;
    GImageGray imageDerivY;
    double sigmaToPixels;
    TupleDesc_F64 descriptor;

    public DescribePointSift(int widthSubregion, int widthGrid, int numHistogramBins, double sigmaToPixels, double weightingSigmaFraction, double maxDescriptorElementValue, Class<Deriv> derivType) {
        super(widthSubregion, widthGrid, numHistogramBins, weightingSigmaFraction, maxDescriptorElementValue);
        this.sigmaToPixels = sigmaToPixels;
        this.imageDerivX = FactoryGImageGray.create(derivType);
        this.imageDerivY = FactoryGImageGray.create(derivType);
    }

    public void setImageGradient(Deriv derivX, Deriv derivY) {
        this.imageDerivX.wrap(derivX);
        this.imageDerivY.wrap(derivY);
    }

    public void process(double c_x, double c_y, double sigma, double orientation, TupleDesc_F64 descriptor) {
        this.descriptor = descriptor;
        descriptor.fill(0.0);
        this.computeRawDescriptor(c_x, c_y, sigma, orientation);
        DescribePointSift.normalizeDescriptor(descriptor, this.maxDescriptorElementValue);
    }

    void computeRawDescriptor(double c_x, double c_y, double sigma, double orientation) {
        double c = Math.cos(orientation);
        double s = Math.sin(orientation);
        float fwidthSubregion = this.widthSubregion;
        int sampleWidth = this.widthGrid * this.widthSubregion;
        double sampleRadius = sampleWidth / 2;
        double sampleToPixels = sigma * this.sigmaToPixels;
        ImageGray image = this.imageDerivX.getImage();
        for (int sampleY = 0; sampleY < sampleWidth; ++sampleY) {
            float subY = (float)sampleY / fwidthSubregion;
            double y = sampleToPixels * ((double)sampleY - sampleRadius);
            for (int sampleX = 0; sampleX < sampleWidth; ++sampleX) {
                float subX = (float)sampleX / fwidthSubregion;
                double x = sampleToPixels * ((double)sampleX - sampleRadius);
                int pixelX = (int)(x * c - y * s + c_x + 0.5);
                int pixelY = (int)(x * s + y * c + c_y + 0.5);
                if (!image.isInBounds(pixelX, pixelY)) continue;
                float spacialDX = this.imageDerivX.unsafe_getF(pixelX, pixelY);
                float spacialDY = this.imageDerivY.unsafe_getF(pixelX, pixelY);
                double adjDX = c * (double)spacialDX + s * (double)spacialDY;
                double adjDY = -s * (double)spacialDX + c * (double)spacialDY;
                double angle = UtilAngle.domain2PI((double)Math.atan2(adjDY, adjDX));
                float weightGaussian = this.gaussianWeight[sampleY * sampleWidth + sampleX];
                float weightGradient = (float)Math.sqrt(spacialDX * spacialDX + spacialDY * spacialDY);
                this.trilinearInterpolation(weightGaussian * weightGradient, subX, subY, angle, this.descriptor);
            }
        }
    }
}

