/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.intensity;

import boofcv.alg.feature.detect.intensity.FeatureIntensity;
import boofcv.alg.feature.detect.intensity.impl.FastHelper;
import boofcv.misc.DiscretizedCircle;
import boofcv.struct.QueueCorner;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;

public abstract class FastCornerIntensity<T extends ImageGray>
implements FeatureIntensity<T> {
    protected static final int radius = 3;
    protected int[] offsets;
    private int stride = 0;
    private QueueCorner candidates = new QueueCorner(10);
    protected T image;
    protected FastHelper<T> helper;

    protected FastCornerIntensity(FastHelper<T> helper) {
        this.helper = helper;
    }

    public QueueCorner getCandidates() {
        return this.candidates;
    }

    @Override
    public int getRadius() {
        return 3;
    }

    @Override
    public int getIgnoreBorder() {
        return 3;
    }

    public void process(T image, GrayF32 intensity) {
        this.candidates.reset();
        this.image = image;
        if (this.stride != ((ImageGray)image).stride) {
            this.stride = ((ImageGray)image).stride;
            this.offsets = DiscretizedCircle.imageOffsets((double)3.0, (int)((ImageGray)image).stride);
        }
        this.helper.setImage(image, this.offsets);
        for (int y = 3; y < ((ImageGray)image).height - 3; ++y) {
            int indexIntensity = intensity.startIndex + y * intensity.stride + 3;
            int index = ((ImageGray)image).startIndex + y * ((ImageGray)image).stride + 3;
            int x = 3;
            while (x < ((ImageGray)image).width - 3) {
                this.helper.setThresholds(index);
                if (this.checkLower(index)) {
                    intensity.data[indexIntensity] = this.helper.scoreLower(index);
                    this.candidates.add(x, y);
                } else if (this.checkUpper(index)) {
                    intensity.data[indexIntensity] = this.helper.scoreUpper(index);
                    this.candidates.add(x, y);
                } else {
                    intensity.data[indexIntensity] = 0.0f;
                }
                ++x;
                ++index;
                ++indexIntensity;
            }
        }
    }

    protected abstract boolean checkLower(int var1);

    protected abstract boolean checkUpper(int var1);
}

