/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.line.gridline;

import boofcv.alg.feature.detect.line.gridline.Edgel;
import georegression.geometry.UtilLine2D_F32;
import georegression.metric.Distance2D_F32;
import georegression.metric.UtilAngle;
import georegression.struct.line.LineParametric2D_F32;
import georegression.struct.line.LinePolar2D_F32;
import georegression.struct.point.Point2D_F32;
import java.util.List;
import org.ddogleg.fitting.modelset.DistanceFromModel;

public class GridLineModelDistance
implements DistanceFromModel<LinePolar2D_F32, Edgel> {
    LineParametric2D_F32 line = new LineParametric2D_F32();
    float theta;
    float angleTolerance;

    public GridLineModelDistance(float angleTolerance) {
        this.angleTolerance = angleTolerance;
    }

    public void setModel(LinePolar2D_F32 lineParam) {
        UtilLine2D_F32.convert((LinePolar2D_F32)lineParam, (LineParametric2D_F32)this.line);
        this.theta = lineParam.angle;
    }

    public double computeDistance(Edgel pt) {
        if (UtilAngle.distHalf((double)pt.theta, (double)this.theta) > (double)this.angleTolerance) {
            return Double.MAX_VALUE;
        }
        return Distance2D_F32.distance((LineParametric2D_F32)this.line, (Point2D_F32)pt);
    }

    public void computeDistance(List<Edgel> edgels, double[] distance) {
        for (int i = 0; i < edgels.size(); ++i) {
            distance[i] = this.computeDistance(edgels.get(i));
        }
    }
}

