/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.orientation.impl;

import boofcv.alg.feature.orientation.OrientationHistogram;
import boofcv.struct.image.GrayF32;

public class ImplOrientationHistogram_F32
extends OrientationHistogram<GrayF32> {
    public ImplOrientationHistogram_F32(double objectToSample, int numAngles, boolean isWeighted) {
        super(objectToSample, numAngles, isWeighted);
    }

    @Override
    public Class<GrayF32> getImageType() {
        return GrayF32.class;
    }

    @Override
    protected void computeUnweightedScore() {
        for (int y = this.rect.y0; y < this.rect.y1; ++y) {
            int indexX = ((GrayF32)this.derivX).startIndex + ((GrayF32)this.derivX).stride * y + this.rect.x0;
            int indexY = ((GrayF32)this.derivY).startIndex + ((GrayF32)this.derivY).stride * y + this.rect.x0;
            int x = this.rect.x0;
            while (x < this.rect.x1) {
                int discreteAngle;
                float dx = ((GrayF32)this.derivX).data[indexX];
                float dy = ((GrayF32)this.derivY).data[indexY];
                double angle = Math.atan2(dy, dx);
                int n = discreteAngle = (int)((angle + this.angleRound) / this.angleDiv) % this.numAngles;
                this.sumDerivX[n] = this.sumDerivX[n] + (double)dx;
                int n2 = discreteAngle;
                this.sumDerivY[n2] = this.sumDerivY[n2] + (double)dy;
                ++x;
                ++indexX;
                ++indexY;
            }
        }
    }

    @Override
    protected void computeWeightedScore(int c_x, int c_y) {
        for (int y = this.rect.y0; y < this.rect.y1; ++y) {
            int indexX = ((GrayF32)this.derivX).startIndex + ((GrayF32)this.derivX).stride * y + this.rect.x0;
            int indexY = ((GrayF32)this.derivY).startIndex + ((GrayF32)this.derivY).stride * y + this.rect.x0;
            int indexW = (y - c_y + this.radiusScale) * this.weights.width + this.rect.x0 - c_x + this.radiusScale;
            int x = this.rect.x0;
            while (x < this.rect.x1) {
                int discreteAngle;
                float w = this.weights.data[indexW];
                float dx = ((GrayF32)this.derivX).data[indexX];
                float dy = ((GrayF32)this.derivY).data[indexY];
                double angle = Math.atan2(dy, dx);
                int n = discreteAngle = (int)((angle + this.angleRound) / this.angleDiv) % this.numAngles;
                this.sumDerivX[n] = this.sumDerivX[n] + (double)(w * dx);
                int n2 = discreteAngle;
                this.sumDerivY[n2] = this.sumDerivY[n2] + (double)(w * dy);
                ++x;
                ++indexX;
                ++indexY;
                ++indexW;
            }
        }
    }
}

