/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.feature.orientation;

import boofcv.abst.feature.describe.ConfigSiftScaleSpace;
import boofcv.abst.feature.orientation.ConfigSiftOrientation;
import boofcv.abst.feature.orientation.OrientationGradient;
import boofcv.abst.feature.orientation.OrientationGradientToImage;
import boofcv.abst.feature.orientation.OrientationImage;
import boofcv.abst.feature.orientation.OrientationIntegral;
import boofcv.abst.feature.orientation.OrientationIntegralToImage;
import boofcv.abst.feature.orientation.OrientationSiftToImage;
import boofcv.abst.feature.orientation.RegionOrientation;
import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.alg.feature.detect.interest.SiftScaleSpace;
import boofcv.alg.feature.orientation.OrientationHistogramSift;
import boofcv.alg.transform.ii.GIntegralImageOps;
import boofcv.factory.feature.orientation.FactoryOrientationAlgs;
import boofcv.factory.filter.derivative.FactoryDerivative;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;

public class FactoryOrientation {
    public static <T extends ImageGray> OrientationImage<T> convertImage(RegionOrientation algorithm, Class<T> imageType) {
        if (algorithm instanceof OrientationGradient) {
            Class derivType = ((OrientationGradient)algorithm).getImageType();
            ImageGradient gradient = FactoryDerivative.sobel(imageType, derivType);
            return new OrientationGradientToImage((OrientationGradient)algorithm, gradient, imageType, derivType);
        }
        if (algorithm instanceof OrientationIntegral) {
            Class integralType = GIntegralImageOps.getIntegralType(imageType);
            return new OrientationIntegralToImage((OrientationIntegral)algorithm, imageType, integralType);
        }
        throw new IllegalArgumentException("Unknown orientation algorithm type");
    }

    public static <T extends ImageGray> OrientationImage<T> sift(ConfigSiftScaleSpace configSS, ConfigSiftOrientation configOri, Class<T> imageType) {
        if (configSS == null) {
            configSS = new ConfigSiftScaleSpace();
        }
        configSS.checkValidity();
        OrientationHistogramSift<GrayF32> ori = FactoryOrientationAlgs.sift(configOri, GrayF32.class);
        SiftScaleSpace ss = new SiftScaleSpace(configSS.firstOctave, configSS.lastOctave, configSS.numScales, configSS.sigma0);
        return new OrientationSiftToImage<T>(ori, ss, imageType);
    }
}

