/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.feature;

import java.util.ArrayList;
import java.util.List;

public class MatrixOfList<T> {
    public List<T>[] grid;
    public int width;
    public int height;

    public MatrixOfList(int width, int height) {
        this.width = width;
        this.height = height;
        this.grid = new ArrayList[width * height];
        for (int i = 0; i < this.grid.length; ++i) {
            this.grid[i] = new ArrayList<T>();
        }
    }

    public void reshape(int width, int height) {
        if (width * height > this.grid.length) {
            this.grid = new ArrayList[width * height];
            for (int i = 0; i < this.grid.length; ++i) {
                this.grid[i] = new ArrayList<T>();
            }
        }
        this.width = width;
        this.height = height;
    }

    public void reset() {
        int N = this.width * this.height;
        for (int i = 0; i < N; ++i) {
            this.grid[i].clear();
        }
    }

    public List<T> get(int x, int y) {
        return this.grid[y * this.width + x];
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public List<T> createSingleList() {
        ArrayList<T> ret = new ArrayList<T>();
        int N = this.width * this.height;
        for (int i = 0; i < N; ++i) {
            ret.addAll(this.grid[i]);
        }
        return ret;
    }

    public boolean isInBounds(int x, int y) {
        return x >= 0 && x < this.width && y >= 0 && y < this.height;
    }
}

