/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.tracker;

import boofcv.abst.feature.associate.AssociateDescription2D;
import boofcv.abst.feature.tracker.DdaFeatureManager;
import boofcv.abst.feature.tracker.PointTrack;
import boofcv.abst.feature.tracker.PointTracker;
import boofcv.struct.feature.AssociatedIndex;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.image.ImageSingleBand;
import georegression.struct.point.Point2D_F64;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.struct.FastQueue;

public class DetectDescribeAssociate<I extends ImageSingleBand, Desc extends TupleDesc>
implements PointTracker<I> {
    protected AssociateDescription2D<Desc> associate;
    protected DdaFeatureManager<I, Desc> manager;
    protected FastQueue<Point2D_F64> locDst = new FastQueue(10, Point2D_F64.class, false);
    protected FastQueue<Point2D_F64> locSrc = new FastQueue(10, Point2D_F64.class, true);
    protected FastQueue<Desc> featSrc;
    protected FastQueue<Desc> featDst;
    protected List<PointTrack> tracksAll = new ArrayList<PointTrack>();
    protected List<PointTrack> tracksActive = new ArrayList<PointTrack>();
    protected List<PointTrack> tracksInactive = new ArrayList<PointTrack>();
    protected List<PointTrack> tracksDropped = new ArrayList<PointTrack>();
    protected List<PointTrack> tracksNew = new ArrayList<PointTrack>();
    protected List<PointTrack> unused = new ArrayList<PointTrack>();
    protected FastQueue<AssociatedIndex> matches;
    protected long featureID = 0L;
    boolean updateDescription;
    protected boolean[] isAssociated = new boolean[1];

    public DetectDescribeAssociate(DdaFeatureManager<I, Desc> manager, AssociateDescription2D<Desc> associate, boolean updateDescription) {
        this.manager = manager;
        this.associate = associate;
        this.updateDescription = updateDescription;
        this.featSrc = new FastQueue(10, manager.getDescriptionType(), false);
        this.featDst = new FastQueue(10, manager.getDescriptionType(), false);
    }

    protected DetectDescribeAssociate() {
    }

    public boolean isUpdateDescription() {
        return this.updateDescription;
    }

    public void setUpdateDescription(boolean updateDescription) {
        this.updateDescription = updateDescription;
    }

    @Override
    public void reset() {
        this.dropAllTracks();
        this.featureID = 0L;
        this.featDst.reset();
        this.locDst.reset();
        this.matches = null;
    }

    @Override
    public void process(I input) {
        this.tracksActive.clear();
        this.tracksInactive.clear();
        this.tracksDropped.clear();
        this.tracksNew.clear();
        this.featDst.reset();
        this.locDst.reset();
        this.manager.detectFeatures(input, this.locDst, this.featDst);
        if (!this.tracksAll.isEmpty()) {
            this.performTracking();
            for (int i = 0; i < this.tracksAll.size(); ++i) {
                if (this.isAssociated[i]) continue;
                this.tracksInactive.add(this.tracksAll.get(i));
            }
            this.featSrc.reset();
            this.locSrc.reset();
        }
    }

    protected void performTracking() {
        this.putIntoSrcList();
        this.associate.setSource(this.locSrc, this.featSrc);
        this.associate.setDestination(this.locDst, this.featDst);
        this.associate.associate();
        this.matches = this.associate.getMatches();
        this.updateTrackState(this.matches);
    }

    protected void putIntoSrcList() {
        if (this.isAssociated.length < this.tracksAll.size()) {
            this.isAssociated = new boolean[this.tracksAll.size()];
        }
        this.featSrc.reset();
        this.locSrc.reset();
        for (int i = 0; i < this.tracksAll.size(); ++i) {
            PointTrack t = this.tracksAll.get(i);
            TupleDesc desc = (TupleDesc)t.getDescription();
            this.featSrc.add((Object)desc);
            this.locSrc.add((Object)t);
            this.isAssociated[i] = false;
        }
    }

    protected void updateTrackState(FastQueue<AssociatedIndex> matches) {
        for (int i = 0; i < matches.size; ++i) {
            AssociatedIndex indexes = ((AssociatedIndex[])matches.data)[i];
            PointTrack track = this.tracksAll.get(indexes.src);
            Point2D_F64 loc = ((Point2D_F64[])this.locDst.data)[indexes.dst];
            track.set(loc.x, loc.y);
            this.tracksActive.add(track);
            if (this.updateDescription) {
                ((TupleDesc)track.getDescription()).setTo((TupleDesc)this.featDst.get(indexes.dst));
            }
            this.isAssociated[indexes.src] = true;
        }
    }

    @Override
    public void spawnTracks() {
        int i;
        if (this.isAssociated.length < this.featDst.size) {
            this.isAssociated = new boolean[this.featDst.size];
        }
        for (i = 0; i < this.featDst.size; ++i) {
            this.isAssociated[i] = false;
        }
        if (this.matches != null) {
            for (i = 0; i < this.matches.size; ++i) {
                this.isAssociated[((AssociatedIndex[])this.matches.data)[i].dst] = true;
            }
        }
        for (i = 0; i < this.featDst.size; ++i) {
            if (this.isAssociated[i]) continue;
            Point2D_F64 loc = (Point2D_F64)this.locDst.get(i);
            this.addNewTrack(loc.x, loc.y, (TupleDesc)this.featDst.get(i));
        }
    }

    protected PointTrack addNewTrack(double x, double y, Desc desc) {
        PointTrack p = this.getUnused();
        p.set(x, y);
        ((TupleDesc)p.getDescription()).setTo(desc);
        if (this.checkValidSpawn(p)) {
            p.featureId = this.featureID++;
            this.tracksNew.add(p);
            this.tracksActive.add(p);
            this.tracksAll.add(p);
            return p;
        }
        this.unused.add(p);
        return null;
    }

    protected boolean checkValidSpawn(PointTrack p) {
        return true;
    }

    protected PointTrack getUnused() {
        PointTrack p;
        if (this.unused.size() > 0) {
            p = this.unused.remove(this.unused.size() - 1);
        } else {
            p = new PointTrack();
            p.setDescription(this.manager.createDescription());
        }
        return p;
    }

    @Override
    public void dropAllTracks() {
        this.unused.addAll(this.tracksAll);
        this.tracksActive.clear();
        this.tracksInactive.clear();
        this.tracksAll.clear();
        this.tracksNew.clear();
    }

    @Override
    public boolean dropTrack(PointTrack track) {
        if (!this.tracksAll.remove((Object)track)) {
            return false;
        }
        this.tracksActive.remove((Object)track);
        this.tracksInactive.remove((Object)track);
        this.unused.add(track);
        return true;
    }

    @Override
    public List<PointTrack> getActiveTracks(List<PointTrack> list) {
        if (list == null) {
            list = new ArrayList<PointTrack>();
        }
        list.addAll(this.tracksActive);
        return list;
    }

    @Override
    public List<PointTrack> getDroppedTracks(List<PointTrack> list) {
        if (list == null) {
            list = new ArrayList<PointTrack>();
        }
        list.addAll(this.tracksDropped);
        return list;
    }

    @Override
    public List<PointTrack> getNewTracks(List<PointTrack> list) {
        if (list == null) {
            list = new ArrayList<PointTrack>();
        }
        list.addAll(this.tracksNew);
        return list;
    }

    @Override
    public List<PointTrack> getAllTracks(List<PointTrack> list) {
        if (list == null) {
            list = new ArrayList<PointTrack>();
        }
        list.addAll(this.tracksAll);
        return list;
    }

    @Override
    public List<PointTrack> getInactiveTracks(List<PointTrack> list) {
        if (list == null) {
            list = new ArrayList<PointTrack>();
        }
        list.addAll(this.tracksInactive);
        return list;
    }
}

