/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort;

import boofcv.struct.distort.PointTransform_F32;
import georegression.geometry.GeometryMath_F32;
import georegression.struct.GeoTuple2D_F32;
import georegression.struct.point.Point2D_F32;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public class RemoveRadialPtoN_F32
implements PointTransform_F32 {
    protected float x_c;
    protected float y_c;
    protected float[] radial;
    protected float sum;
    protected DenseMatrix64F K_inv = new DenseMatrix64F(3, 3);
    private float tol = 1.0E-5f;

    public void setTolerance(float tol) {
        this.tol = tol;
    }

    public void set(double fx, double fy, double skew, double x_c, double y_c, double ... radial) {
        this.K_inv.set(0, 0, fx);
        this.K_inv.set(1, 1, fy);
        this.K_inv.set(0, 1, skew);
        this.K_inv.set(0, 2, x_c);
        this.K_inv.set(1, 2, y_c);
        this.K_inv.set(2, 2, 1.0);
        CommonOps.invert((DenseMatrix64F)this.K_inv);
        this.x_c = (float)x_c;
        this.y_c = (float)y_c;
        this.radial = new float[radial.length];
        for (int i = 0; i < radial.length; ++i) {
            this.radial[i] = (float)radial[i];
        }
    }

    public void compute(float x, float y, Point2D_F32 out) {
        out.set(x, y);
        GeometryMath_F32.mult((DenseMatrix64F)this.K_inv, (GeoTuple2D_F32)out, (GeoTuple2D_F32)out);
        float origX = out.x;
        float origY = out.y;
        double prevSum = 0.0;
        for (int iter = 0; iter < 20; ++iter) {
            double r2;
            double r = r2 = (double)(out.x * out.x + out.y * out.y);
            this.sum = 0.0f;
            for (int i = 0; i < this.radial.length; ++i) {
                this.sum = (float)((double)this.sum + (double)this.radial[i] * r);
                r *= r2;
            }
            out.x = origX / (1.0f + this.sum);
            out.y = origY / (1.0f + this.sum);
            if (Math.abs(prevSum - (double)this.sum) <= (double)this.tol) break;
            prevSum = this.sum;
        }
    }
}

