/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo;

import georegression.geometry.GeometryMath_F64;
import georegression.struct.GeoTuple3D_F64;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;
import java.util.ArrayList;
import java.util.List;
import org.ejml.alg.dense.decomposition.svd.SafeSvd;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix64F;
import org.ejml.data.RowD1Matrix64F;
import org.ejml.factory.DecompositionFactory;
import org.ejml.interfaces.decomposition.SingularValueDecomposition;
import org.ejml.ops.CommonOps;
import org.ejml.ops.SingularOps;

public class DecomposeHomography {
    private SingularValueDecomposition<DenseMatrix64F> svd = DecompositionFactory.svd((int)3, (int)3, (boolean)false, (boolean)true, (boolean)false);
    List<Se3_F64> solutionsSE = new ArrayList<Se3_F64>();
    List<Vector3D_F64> solutionsN = new ArrayList<Vector3D_F64>();
    Vector3D_F64 u1 = new Vector3D_F64();
    Vector3D_F64 u2 = new Vector3D_F64();
    Vector3D_F64 v2 = new Vector3D_F64();
    Vector3D_F64 tempV = new Vector3D_F64();
    DenseMatrix64F W1 = new DenseMatrix64F(3, 3);
    DenseMatrix64F W2 = new DenseMatrix64F(3, 3);
    DenseMatrix64F U1 = new DenseMatrix64F(3, 3);
    DenseMatrix64F U2 = new DenseMatrix64F(3, 3);
    DenseMatrix64F Hv2 = new DenseMatrix64F(3, 3);
    DenseMatrix64F tempM = new DenseMatrix64F(3, 3);

    public DecomposeHomography() {
        for (int i = 0; i < 4; ++i) {
            this.solutionsN.add(new Vector3D_F64());
            this.solutionsSE.add(new Se3_F64());
        }
        this.svd = new SafeSvd(DecompositionFactory.svd((int)3, (int)3, (boolean)false, (boolean)true, (boolean)false));
    }

    public void decompose(DenseMatrix64F H) {
        if (!this.svd.decompose((Matrix64F)H)) {
            throw new RuntimeException("SVD failed somehow");
        }
        DenseMatrix64F V = (DenseMatrix64F)this.svd.getV(null, false);
        DenseMatrix64F S = (DenseMatrix64F)this.svd.getW(null);
        SingularOps.descendingOrder(null, (boolean)false, (DenseMatrix64F)S, (DenseMatrix64F)V, (boolean)false);
        double s0 = S.get(0, 0) * S.get(0, 0);
        double s2 = S.get(2, 2) * S.get(2, 2);
        this.v2.set(V.get(0, 1), V.get(1, 1), V.get(2, 1));
        double a = Math.sqrt(1.0 - s2);
        double b = Math.sqrt(s0 - 1.0);
        double div = Math.sqrt(s0 - s2);
        for (int i = 0; i < 3; ++i) {
            double e1 = (a * V.get(i, 0) + b * V.get(i, 2)) / div;
            double e2 = (a * V.get(i, 0) - b * V.get(i, 2)) / div;
            this.u1.setIndex(i, e1);
            this.u2.setIndex(i, e2);
        }
        this.setU(this.U1, this.v2, this.u1);
        this.setU(this.U2, this.v2, this.u2);
        this.setW(this.W1, H, this.v2, this.u1);
        this.setW(this.W2, H, this.v2, this.u2);
        this.createSolution(this.W1, this.U1, this.u1, H, this.solutionsSE.get(0), this.solutionsN.get(0));
        this.createSolution(this.W2, this.U2, this.u2, H, this.solutionsSE.get(1), this.solutionsN.get(1));
        this.createMirrorSolution(0, 2);
        this.createMirrorSolution(1, 3);
    }

    public List<Se3_F64> getSolutionsSE() {
        return this.solutionsSE;
    }

    public List<Vector3D_F64> getSolutionsN() {
        return this.solutionsN;
    }

    private void setU(DenseMatrix64F U, Vector3D_F64 a, Vector3D_F64 b) {
        this.setColumn(U, 0, a);
        this.setColumn(U, 1, b);
        GeometryMath_F64.cross((GeoTuple3D_F64)a, (GeoTuple3D_F64)b, (GeoTuple3D_F64)this.tempV);
        this.setColumn(U, 2, this.tempV);
    }

    private void setW(DenseMatrix64F W, DenseMatrix64F H, Vector3D_F64 a, Vector3D_F64 b) {
        GeometryMath_F64.mult((DenseMatrix64F)H, (GeoTuple3D_F64)b, (GeoTuple3D_F64)this.tempV);
        this.setColumn(W, 1, this.tempV);
        GeometryMath_F64.mult((DenseMatrix64F)H, (GeoTuple3D_F64)a, (GeoTuple3D_F64)this.tempV);
        this.setColumn(W, 0, this.tempV);
        GeometryMath_F64.crossMatrix((GeoTuple3D_F64)this.tempV, (DenseMatrix64F)this.Hv2);
        CommonOps.mult((RowD1Matrix64F)this.Hv2, (RowD1Matrix64F)H, (RowD1Matrix64F)this.tempM);
        GeometryMath_F64.mult((DenseMatrix64F)this.tempM, (GeoTuple3D_F64)b, (GeoTuple3D_F64)this.tempV);
        this.setColumn(W, 2, this.tempV);
    }

    private void setColumn(DenseMatrix64F U, int column, Vector3D_F64 a) {
        U.set(0, column, a.x);
        U.set(1, column, a.y);
        U.set(2, column, a.z);
    }

    private void createSolution(DenseMatrix64F W, DenseMatrix64F U, Vector3D_F64 u, DenseMatrix64F H, Se3_F64 se, Vector3D_F64 N) {
        CommonOps.multTransB((RowD1Matrix64F)W, (RowD1Matrix64F)U, (RowD1Matrix64F)se.getR());
        GeometryMath_F64.cross((GeoTuple3D_F64)this.v2, (GeoTuple3D_F64)u, (GeoTuple3D_F64)N);
        CommonOps.sub((D1Matrix64F)H, (D1Matrix64F)se.getR(), (D1Matrix64F)this.tempM);
        GeometryMath_F64.mult((DenseMatrix64F)this.tempM, (GeoTuple3D_F64)N, (GeoTuple3D_F64)se.getT());
    }

    private void createMirrorSolution(int origIndex, int index) {
        Se3_F64 origSE = this.solutionsSE.get(origIndex);
        Vector3D_F64 origN = this.solutionsN.get(origIndex);
        Se3_F64 se = this.solutionsSE.get(index);
        Vector3D_F64 N = this.solutionsN.get(index);
        se.getR().set((D1Matrix64F)origSE.getR());
        N.x = -origN.x;
        N.y = -origN.y;
        N.z = -origN.z;
        Vector3D_F64 origT = origSE.getT();
        Vector3D_F64 T = se.getT();
        T.x = -origT.x;
        T.y = -origT.y;
        T.z = -origT.z;
    }
}

