/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.h;

import boofcv.alg.geo.MultiViewOps;
import boofcv.alg.geo.h.AdjustHomographyMatrix;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.geo.PairLineNorm;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.GeoTuple3D_F64;
import georegression.struct.point.Point3D_F64;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public class HomographyInducedStereoLinePt {
    private DenseMatrix64F F;
    private Point3D_F64 e2 = new Point3D_F64();
    private DenseMatrix64F H = new DenseMatrix64F(3, 3);
    private AdjustHomographyMatrix adjust = new AdjustHomographyMatrix();
    private DenseMatrix64F el = new DenseMatrix64F(3, 3);
    private DenseMatrix64F lf = new DenseMatrix64F(3, 3);
    private Point3D_F64 Fx = new Point3D_F64();
    private Point3D_F64 t0 = new Point3D_F64();
    private Point3D_F64 t1 = new Point3D_F64();

    public void setFundamental(DenseMatrix64F F, Point3D_F64 e2) {
        this.F = F;
        if (e2 != null) {
            this.e2.set(e2);
        } else {
            MultiViewOps.extractEpipoles(F, new Point3D_F64(), this.e2);
        }
    }

    public void process(PairLineNorm line, AssociatedPair point) {
        GeometryMath_F64.mult((DenseMatrix64F)this.F, (GeoTuple2D_F64)point.p1, (GeoTuple3D_F64)this.Fx);
        GeometryMath_F64.cross((GeoTuple3D_F64)this.Fx, (GeoTuple3D_F64)line.getL2(), (GeoTuple3D_F64)this.t0);
        GeometryMath_F64.cross((GeoTuple2D_F64)point.p2, (GeoTuple3D_F64)this.t0, (GeoTuple3D_F64)this.t1);
        GeometryMath_F64.cross((GeoTuple2D_F64)point.p2, (GeoTuple3D_F64)this.e2, (GeoTuple3D_F64)this.t0);
        double top = GeometryMath_F64.dot((GeoTuple3D_F64)this.t0, (GeoTuple3D_F64)this.t1);
        double bottom = this.t0.normSq() * (line.l1.x * point.p1.x + line.l1.y * point.p1.y + line.l1.z);
        GeometryMath_F64.outerProd((GeoTuple3D_F64)this.e2, (GeoTuple3D_F64)line.l1, (DenseMatrix64F)this.el);
        GeometryMath_F64.multCrossA((GeoTuple3D_F64)line.l2, (DenseMatrix64F)this.F, (DenseMatrix64F)this.lf);
        CommonOps.add((D1Matrix64F)this.lf, (double)(top / bottom), (D1Matrix64F)this.el, (D1Matrix64F)this.H);
        this.adjust.adjust(this.H, point);
    }

    public DenseMatrix64F getHomography() {
        return this.H;
    }
}

