/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.h;

import boofcv.alg.geo.ModelObservationResidualN;
import boofcv.struct.geo.AssociatedPair;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.point.Point2D_F64;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix64F;
import org.ejml.data.RowD1Matrix64F;
import org.ejml.factory.LinearSolverFactory;
import org.ejml.interfaces.linsol.LinearSolver;
import org.ejml.ops.CommonOps;

public class HomographyResidualSampson
implements ModelObservationResidualN<DenseMatrix64F, AssociatedPair> {
    DenseMatrix64F H;
    Point2D_F64 temp = new Point2D_F64();
    DenseMatrix64F J = new DenseMatrix64F(2, 4);
    DenseMatrix64F JJ = new DenseMatrix64F(2, 2);
    DenseMatrix64F e = new DenseMatrix64F(2, 1);
    DenseMatrix64F x = new DenseMatrix64F(2, 1);
    DenseMatrix64F error = new DenseMatrix64F(4, 1);
    LinearSolver<DenseMatrix64F> solver = LinearSolverFactory.linear((int)2);

    @Override
    public void setModel(DenseMatrix64F F) {
        this.H = F;
    }

    @Override
    public int computeResiduals(AssociatedPair p, double[] residuals, int index) {
        GeometryMath_F64.mult((DenseMatrix64F)this.H, (GeoTuple2D_F64)p.p1, (GeoTuple2D_F64)this.temp);
        double top1 = this.error1(p.p1.x, p.p1.y, p.p2.x, p.p2.y);
        double top2 = this.error2(p.p1.x, p.p1.y, p.p2.x, p.p2.y);
        this.computeJacobian(p.p1, p.p2);
        CommonOps.multTransB((RowD1Matrix64F)this.J, (RowD1Matrix64F)this.J, (RowD1Matrix64F)this.JJ);
        this.e.data[0] = -top1;
        this.e.data[1] = -top2;
        if (this.solver.setA((Matrix64F)this.JJ)) {
            this.solver.solve((Matrix64F)this.e, (Matrix64F)this.x);
            CommonOps.multTransA((RowD1Matrix64F)this.J, (RowD1Matrix64F)this.x, (RowD1Matrix64F)this.error);
            residuals[index++] = this.error.data[0];
            residuals[index++] = this.error.data[1];
            residuals[index++] = this.error.data[2];
            residuals[index++] = this.error.data[3];
        } else {
            residuals[index++] = 0.0;
            residuals[index++] = 0.0;
            residuals[index++] = 0.0;
            residuals[index++] = 0.0;
        }
        return index;
    }

    public double error1(double x1, double y1, double x2, double y2) {
        double ret = -(x1 * this.H.get(1, 0) + y1 * this.H.get(1, 1) + this.H.get(1, 2));
        return ret += y2 * (x1 * this.H.get(2, 0) + y1 * this.H.get(2, 1) + this.H.get(2, 2));
    }

    public double error2(double x1, double y1, double x2, double y2) {
        double ret = x1 * this.H.get(0, 0) + y1 * this.H.get(0, 1) + this.H.get(0, 2);
        return ret -= x2 * (x1 * this.H.get(2, 0) + y1 * this.H.get(2, 1) + this.H.get(2, 2));
    }

    public void computeJacobian(Point2D_F64 x1, Point2D_F64 x2) {
        this.J.data[0] = -this.H.get(1, 0) + x2.y * this.H.get(2, 0);
        this.J.data[1] = -this.H.get(1, 1) + x2.y * this.H.get(2, 1);
        this.J.data[2] = 0.0;
        this.J.data[3] = x1.x * this.H.get(2, 0) + x1.y * this.H.get(2, 1) + this.H.get(2, 2);
        this.J.data[4] = this.H.get(0, 0) - x2.x * this.H.get(2, 0);
        this.J.data[5] = this.H.get(0, 1) - x2.x * this.H.get(2, 1);
        this.J.data[6] = -this.J.data[3];
        this.J.data[7] = 0.0;
    }

    @Override
    public int getN() {
        return 4;
    }
}

