/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo;

import boofcv.alg.distort.AddRadialPtoP_F32;
import boofcv.alg.distort.AddRadialPtoP_F64;
import boofcv.alg.distort.DistortImageOps;
import boofcv.alg.distort.FlipVertical_F32;
import boofcv.alg.distort.FlipVertical_F64;
import boofcv.alg.distort.ImageDistort;
import boofcv.alg.distort.LensDistortionOps;
import boofcv.alg.distort.PixelToNormalized_F64;
import boofcv.alg.distort.PointToPixelTransform_F32;
import boofcv.alg.distort.PointTransformHomography_F32;
import boofcv.alg.distort.PointTransformHomography_F64;
import boofcv.alg.distort.RemoveRadialPtoP_F32;
import boofcv.alg.distort.RemoveRadialPtoP_F64;
import boofcv.alg.geo.rectify.RectifyCalibrated;
import boofcv.alg.geo.rectify.RectifyFundamental;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.factory.distort.FactoryDistort;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.calib.IntrinsicParameters;
import boofcv.struct.distort.PixelTransform_F32;
import boofcv.struct.distort.PointTransform_F32;
import boofcv.struct.distort.PointTransform_F64;
import boofcv.struct.distort.SequencePointTransform_F32;
import boofcv.struct.distort.SequencePointTransform_F64;
import boofcv.struct.image.ImageSingleBand;
import georegression.struct.shapes.RectangleLength2D_F32;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;
import org.ejml.simple.SimpleBase;
import org.ejml.simple.SimpleMatrix;

public class RectifyImageOps {
    public static RectifyCalibrated createCalibrated() {
        return new RectifyCalibrated();
    }

    public static RectifyFundamental createUncalibrated() {
        return new RectifyFundamental();
    }

    public static void fullViewLeft(IntrinsicParameters paramLeft, DenseMatrix64F rectifyLeft, DenseMatrix64F rectifyRight, DenseMatrix64F rectifyK) {
        paramLeft = new IntrinsicParameters(paramLeft);
        paramLeft.flipY = false;
        PointTransform_F32 tranLeft = RectifyImageOps.transformPixelToRect_F32(paramLeft, rectifyLeft);
        RectangleLength2D_F32 bound = DistortImageOps.boundBox_F32((int)paramLeft.width, (int)paramLeft.height, (PixelTransform_F32)new PointToPixelTransform_F32(tranLeft));
        double scaleX = (float)paramLeft.width / bound.width;
        double scaleY = (float)paramLeft.height / bound.height;
        double scale = Math.min(scaleX, scaleY);
        RectifyImageOps.adjustCalibrated(rectifyLeft, rectifyRight, rectifyK, bound, scale);
    }

    public static void fullViewLeft(int imageWidth, int imageHeight, DenseMatrix64F rectifyLeft, DenseMatrix64F rectifyRight) {
        PointTransformHomography_F32 tranLeft = new PointTransformHomography_F32(rectifyLeft);
        RectangleLength2D_F32 bound = DistortImageOps.boundBox_F32((int)imageWidth, (int)imageHeight, (PixelTransform_F32)new PointToPixelTransform_F32((PointTransform_F32)tranLeft));
        double scaleX = (float)imageWidth / bound.width;
        double scaleY = (float)imageHeight / bound.height;
        double scale = Math.min(scaleX, scaleY);
        RectifyImageOps.adjustUncalibrated(rectifyLeft, rectifyRight, bound, scale);
    }

    public static void allInsideLeft(IntrinsicParameters paramLeft, DenseMatrix64F rectifyLeft, DenseMatrix64F rectifyRight, DenseMatrix64F rectifyK) {
        paramLeft = new IntrinsicParameters(paramLeft);
        paramLeft.flipY = false;
        PointTransform_F32 tranLeft = RectifyImageOps.transformPixelToRect_F32(paramLeft, rectifyLeft);
        RectangleLength2D_F32 bound = LensDistortionOps.boundBoxInside(paramLeft.width, paramLeft.height, (PixelTransform_F32)new PointToPixelTransform_F32(tranLeft));
        LensDistortionOps.roundInside(bound);
        double scaleX = (double)paramLeft.width / (double)bound.width;
        double scaleY = (double)paramLeft.height / (double)bound.height;
        double scale = Math.max(scaleX, scaleY);
        RectifyImageOps.adjustCalibrated(rectifyLeft, rectifyRight, rectifyK, bound, scale);
    }

    public static void allInsideLeft(int imageWidth, int imageHeight, DenseMatrix64F rectifyLeft, DenseMatrix64F rectifyRight) {
        PointTransformHomography_F32 tranLeft = new PointTransformHomography_F32(rectifyLeft);
        RectangleLength2D_F32 bound = LensDistortionOps.boundBoxInside(imageWidth, imageHeight, (PixelTransform_F32)new PointToPixelTransform_F32((PointTransform_F32)tranLeft));
        double scaleX = (double)imageWidth / (double)bound.width;
        double scaleY = (double)imageHeight / (double)bound.height;
        double scale = Math.max(scaleX, scaleY);
        RectifyImageOps.adjustUncalibrated(rectifyLeft, rectifyRight, bound, scale);
    }

    private static void adjustCalibrated(DenseMatrix64F rectifyLeft, DenseMatrix64F rectifyRight, DenseMatrix64F rectifyK, RectangleLength2D_F32 bound, double scale) {
        double deltaX = (double)(-bound.x0) * scale;
        double deltaY = (double)(-bound.y0) * scale;
        SimpleMatrix A = new SimpleMatrix(3, 3, true, new double[]{scale, 0.0, deltaX, 0.0, scale, deltaY, 0.0, 0.0, 1.0});
        SimpleMatrix rL = SimpleMatrix.wrap((DenseMatrix64F)rectifyLeft);
        SimpleMatrix rR = SimpleMatrix.wrap((DenseMatrix64F)rectifyRight);
        SimpleMatrix K = SimpleMatrix.wrap((DenseMatrix64F)rectifyK);
        SimpleMatrix K_inv = (SimpleMatrix)K.invert();
        rL = (SimpleMatrix)K_inv.mult((SimpleBase)rL);
        rR = (SimpleMatrix)K_inv.mult((SimpleBase)rR);
        K = (SimpleMatrix)A.mult((SimpleBase)K);
        rectifyK.set((D1Matrix64F)K.getMatrix());
        rectifyLeft.set((D1Matrix64F)((SimpleMatrix)K.mult((SimpleBase)rL)).getMatrix());
        rectifyRight.set((D1Matrix64F)((SimpleMatrix)K.mult((SimpleBase)rR)).getMatrix());
    }

    private static void adjustUncalibrated(DenseMatrix64F rectifyLeft, DenseMatrix64F rectifyRight, RectangleLength2D_F32 bound, double scale) {
        double deltaX = (double)(-bound.x0) * scale;
        double deltaY = (double)(-bound.y0) * scale;
        SimpleMatrix A = new SimpleMatrix(3, 3, true, new double[]{scale, 0.0, deltaX, 0.0, scale, deltaY, 0.0, 0.0, 1.0});
        SimpleMatrix rL = SimpleMatrix.wrap((DenseMatrix64F)rectifyLeft);
        SimpleMatrix rR = SimpleMatrix.wrap((DenseMatrix64F)rectifyRight);
        rectifyLeft.set((D1Matrix64F)((SimpleMatrix)A.mult((SimpleBase)rL)).getMatrix());
        rectifyRight.set((D1Matrix64F)((SimpleMatrix)A.mult((SimpleBase)rR)).getMatrix());
    }

    public static PointTransform_F32 transformRectToPixel_F32(IntrinsicParameters param, DenseMatrix64F rectify) {
        AddRadialPtoP_F32 addDistortion = new AddRadialPtoP_F32();
        addDistortion.set(param.fx, param.fy, param.skew, param.cx, param.cy, param.radial);
        DenseMatrix64F rectifyInv = new DenseMatrix64F(3, 3);
        CommonOps.invert((DenseMatrix64F)rectify, (DenseMatrix64F)rectifyInv);
        PointTransformHomography_F32 removeRect = new PointTransformHomography_F32(rectifyInv);
        if (param.flipY) {
            FlipVertical_F32 flip = new FlipVertical_F32(param.height);
            return new SequencePointTransform_F32(new PointTransform_F32[]{flip, removeRect, addDistortion, flip});
        }
        return new SequencePointTransform_F32(new PointTransform_F32[]{removeRect, addDistortion});
    }

    public static PointTransform_F64 transformRectToPixel_F64(IntrinsicParameters param, DenseMatrix64F rectify) {
        AddRadialPtoP_F64 addDistortion = new AddRadialPtoP_F64();
        addDistortion.set(param.fx, param.fy, param.skew, param.cx, param.cy, param.radial);
        DenseMatrix64F rectifyInv = new DenseMatrix64F(3, 3);
        CommonOps.invert((DenseMatrix64F)rectify, (DenseMatrix64F)rectifyInv);
        PointTransformHomography_F64 removeRect = new PointTransformHomography_F64(rectifyInv);
        if (param.flipY) {
            FlipVertical_F64 flip = new FlipVertical_F64(param.height);
            return new SequencePointTransform_F64(new PointTransform_F64[]{flip, removeRect, addDistortion, flip});
        }
        return new SequencePointTransform_F64(new PointTransform_F64[]{removeRect, addDistortion});
    }

    public static PointTransform_F32 transformPixelToRect_F32(IntrinsicParameters param, DenseMatrix64F rectify) {
        RemoveRadialPtoP_F32 removeDistortion = new RemoveRadialPtoP_F32();
        removeDistortion.set(param.fx, param.fy, param.skew, param.cx, param.cy, param.radial);
        PointTransformHomography_F32 rectifyPixel = new PointTransformHomography_F32(rectify);
        if (param.flipY) {
            FlipVertical_F32 flip = new FlipVertical_F32(param.height);
            return new SequencePointTransform_F32(new PointTransform_F32[]{flip, removeDistortion, rectifyPixel, flip});
        }
        return new SequencePointTransform_F32(new PointTransform_F32[]{removeDistortion, rectifyPixel});
    }

    public static PointTransform_F64 transformPixelToRect_F64(IntrinsicParameters param, DenseMatrix64F rectify) {
        RemoveRadialPtoP_F64 distortedToPixel = new RemoveRadialPtoP_F64();
        distortedToPixel.set(param.fx, param.fy, param.skew, param.cx, param.cy, param.radial);
        PointTransformHomography_F64 rectifyDistort = new PointTransformHomography_F64(rectify);
        if (param.flipY) {
            FlipVertical_F64 flip = new FlipVertical_F64(param.height);
            return new SequencePointTransform_F64(new PointTransform_F64[]{flip, distortedToPixel, rectifyDistort, flip});
        }
        return new SequencePointTransform_F64(new PointTransform_F64[]{distortedToPixel, rectifyDistort});
    }

    public static PointTransform_F64 transformPixelToRectNorm_F64(IntrinsicParameters param, DenseMatrix64F rectify, DenseMatrix64F rectifyK) {
        if (rectifyK.get(0, 1) != 0.0) {
            throw new IllegalArgumentException("Skew should be zero in rectified images");
        }
        RemoveRadialPtoP_F64 radialDistort = new RemoveRadialPtoP_F64();
        radialDistort.set(param.fx, param.fy, param.skew, param.cx, param.cy, param.radial);
        PointTransformHomography_F64 rectifyDistort = new PointTransformHomography_F64(rectify);
        PixelToNormalized_F64 pixelToNorm = new PixelToNormalized_F64();
        pixelToNorm.set(rectifyK.get(0, 0), rectifyK.get(1, 1), rectifyK.get(0, 1), rectifyK.get(0, 2), rectifyK.get(1, 2));
        if (param.flipY) {
            FlipVertical_F64 flip = new FlipVertical_F64(param.height);
            return new SequencePointTransform_F64(new PointTransform_F64[]{flip, radialDistort, rectifyDistort, pixelToNorm});
        }
        return new SequencePointTransform_F64(new PointTransform_F64[]{radialDistort, rectifyDistort, pixelToNorm});
    }

    public static <T extends ImageSingleBand> ImageDistort<T, T> rectifyImage(DenseMatrix64F rectify, Class<T> imageType) {
        InterpolatePixelS interp = FactoryInterpolation.bilinearPixelS(imageType);
        DenseMatrix64F rectifyInv = new DenseMatrix64F(3, 3);
        CommonOps.invert((DenseMatrix64F)rectify, (DenseMatrix64F)rectifyInv);
        PointTransformHomography_F32 rectifyTran = new PointTransformHomography_F32(rectifyInv);
        ImageDistort ret = FactoryDistort.distort((boolean)false, (InterpolatePixelS)interp, null, imageType);
        ret.setModel((PixelTransform_F32)new PointToPixelTransform_F32((PointTransform_F32)rectifyTran));
        return ret;
    }

    public static <T extends ImageSingleBand> ImageDistort<T, T> rectifyImage(IntrinsicParameters param, DenseMatrix64F rectify, Class<T> imageType) {
        InterpolatePixelS interp = FactoryInterpolation.bilinearPixelS(imageType);
        ImageDistort ret = FactoryDistort.distort((boolean)true, (InterpolatePixelS)interp, null, imageType);
        PointTransform_F32 transform = RectifyImageOps.transformRectToPixel_F32(param, rectify);
        ret.setModel((PixelTransform_F32)new PointToPixelTransform_F32(transform));
        return ret;
    }
}

