/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.bundle;

import boofcv.alg.geo.RodriguesRotationJacobian;
import boofcv.alg.geo.bundle.PointIndexObservation;
import boofcv.alg.geo.bundle.ViewPointObservations;
import georegression.geometry.ConvertRotation3D_F64;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.GeoTuple3D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.struct.so.Rodrigues_F64;
import java.util.Arrays;
import java.util.List;
import org.ddogleg.optimization.functions.FunctionNtoMxN;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;

public class CalibPoseAndPointRodriguesJacobian
implements FunctionNtoMxN {
    Se3_F64[] extrinsic;
    List<ViewPointObservations> observations;
    int numViews;
    int numPoints;
    int numViewsUnknown;
    int numObservations;
    int numParameters;
    RodriguesRotationJacobian rodJacobian = new RodriguesRotationJacobian();
    Rodrigues_F64 rodrigues = new Rodrigues_F64();
    DenseMatrix64F R = new DenseMatrix64F(3, 3);
    Vector3D_F64 T = new Vector3D_F64();
    Point3D_F64 worldPt = new Point3D_F64();
    Point3D_F64 cameraPt = new Point3D_F64();
    int indexFirstPoint;
    int countPointObs;
    int indexX;
    int indexY;
    double[] output;

    public void configure(List<ViewPointObservations> observations, int numPoints, Se3_F64 ... extrinsic) {
        if (extrinsic.length < observations.size()) {
            throw new RuntimeException("knownExtrinsic length is less than the number of views in 'observations'");
        }
        this.observations = observations;
        this.extrinsic = extrinsic;
        this.numViews = observations.size();
        this.numPoints = numPoints;
        this.numViewsUnknown = 0;
        this.numObservations = 0;
        for (int i = 0; i < this.numViews; ++i) {
            if (extrinsic[i] == null) {
                ++this.numViewsUnknown;
            }
            this.numObservations += observations.get((int)i).points.size;
        }
        this.indexFirstPoint = this.numViewsUnknown * 6;
        this.numParameters = this.numViewsUnknown * 6 + numPoints * 3;
    }

    public int getNumOfInputsN() {
        return this.numParameters;
    }

    public int getNumOfOutputsM() {
        return this.numObservations * 2;
    }

    public void process(double[] input, double[] output) {
        this.output = output;
        int paramIndex = 0;
        this.countPointObs = 0;
        Arrays.fill(output, 0.0);
        for (int i = 0; i < this.numViews; ++i) {
            if (this.extrinsic[i] == null) {
                double rodX = input[paramIndex++];
                double rodY = input[paramIndex++];
                double rodZ = input[paramIndex++];
                this.T.x = input[paramIndex++];
                this.T.y = input[paramIndex++];
                this.T.z = input[paramIndex++];
                this.rodrigues.setParamVector(rodX, rodY, rodZ);
                this.rodJacobian.process(rodX, rodY, rodZ);
                ConvertRotation3D_F64.rodriguesToMatrix((Rodrigues_F64)this.rodrigues, (DenseMatrix64F)this.R);
                ViewPointObservations obs = this.observations.get(i);
                this.gradientViewMotionAndPoint(input, paramIndex - 6, obs);
                continue;
            }
            this.T.set(this.extrinsic[i].getT());
            this.R.set((D1Matrix64F)this.extrinsic[i].getR());
            ViewPointObservations obs = this.observations.get(i);
            this.gradientViewPoint(input, obs);
        }
    }

    private void gradientViewMotionAndPoint(double[] input, int extrinsicParamStart, ViewPointObservations obs) {
        int j = 0;
        while (j < obs.points.size) {
            PointIndexObservation o = (PointIndexObservation)obs.points.get(j);
            int indexParamWorld = this.indexFirstPoint + o.pointIndex * 3;
            this.worldPt.x = input[indexParamWorld++];
            this.worldPt.y = input[indexParamWorld++];
            this.worldPt.z = input[indexParamWorld];
            this.indexX = this.numParameters * this.countPointObs * 2 + extrinsicParamStart;
            this.indexY = this.indexX + this.numParameters;
            GeometryMath_F64.mult((DenseMatrix64F)this.R, (GeoTuple3D_F64)this.worldPt, (GeoTuple3D_F64)this.cameraPt);
            this.cameraPt.x += this.T.x;
            this.cameraPt.y += this.T.y;
            this.cameraPt.z += this.T.z;
            this.addRodriguesJacobian(this.rodJacobian.Rx, this.worldPt);
            this.addRodriguesJacobian(this.rodJacobian.Ry, this.worldPt);
            this.addRodriguesJacobian(this.rodJacobian.Rz, this.worldPt);
            this.addTranslationJacobian();
            this.indexX = this.numParameters * this.countPointObs * 2 + this.indexFirstPoint + o.pointIndex * 3;
            this.indexY = this.indexX + this.numParameters;
            this.addWorldPointGradient(this.R);
            ++j;
            ++this.countPointObs;
        }
    }

    private void gradientViewPoint(double[] input, ViewPointObservations obs) {
        int j = 0;
        while (j < obs.points.size) {
            PointIndexObservation o = (PointIndexObservation)obs.points.get(j);
            int indexParamWorld = this.indexFirstPoint + o.pointIndex * 3;
            this.worldPt.x = input[indexParamWorld];
            this.worldPt.y = input[indexParamWorld + 1];
            this.worldPt.z = input[indexParamWorld + 2];
            GeometryMath_F64.mult((DenseMatrix64F)this.R, (GeoTuple3D_F64)this.worldPt, (GeoTuple3D_F64)this.cameraPt);
            this.cameraPt.x += this.T.x;
            this.cameraPt.y += this.T.y;
            this.cameraPt.z += this.T.z;
            this.indexX = this.numParameters * this.countPointObs * 2 + this.indexFirstPoint + o.pointIndex * 3;
            this.indexY = this.indexX + this.numParameters;
            this.addWorldPointGradient(this.R);
            ++j;
            ++this.countPointObs;
        }
    }

    private void addRodriguesJacobian(DenseMatrix64F Rj, Point3D_F64 worldPt) {
        double Rx = (Rj.data[0] * worldPt.x + Rj.data[1] * worldPt.y + Rj.data[2] * worldPt.z) / this.cameraPt.z;
        double Ry = (Rj.data[3] * worldPt.x + Rj.data[4] * worldPt.y + Rj.data[5] * worldPt.z) / this.cameraPt.z;
        double zDot_div_z2 = (Rj.data[6] * worldPt.x + Rj.data[7] * worldPt.y + Rj.data[8] * worldPt.z) / (this.cameraPt.z * this.cameraPt.z);
        this.output[this.indexX++] = -zDot_div_z2 * this.cameraPt.x + Rx;
        this.output[this.indexY++] = -zDot_div_z2 * this.cameraPt.y + Ry;
    }

    private void addTranslationJacobian() {
        double divZ = 1.0 / this.cameraPt.z;
        double divZ2 = 1.0 / (this.cameraPt.z * this.cameraPt.z);
        this.output[this.indexX++] = divZ;
        this.output[this.indexY++] = 0.0;
        this.output[this.indexX++] = 0.0;
        this.output[this.indexY++] = divZ;
        this.output[this.indexX++] = -this.cameraPt.x * divZ2;
        this.output[this.indexY++] = -this.cameraPt.y * divZ2;
    }

    private void addWorldPointGradient(DenseMatrix64F R) {
        double divZ2 = 1.0 / (this.cameraPt.z * this.cameraPt.z);
        this.output[this.indexX++] = -R.data[6] * divZ2 * this.cameraPt.x + R.data[0] / this.cameraPt.z;
        this.output[this.indexY++] = -R.data[6] * divZ2 * this.cameraPt.y + R.data[3] / this.cameraPt.z;
        this.output[this.indexX++] = -R.data[7] * divZ2 * this.cameraPt.x + R.data[1] / this.cameraPt.z;
        this.output[this.indexY++] = -R.data[7] * divZ2 * this.cameraPt.y + R.data[4] / this.cameraPt.z;
        this.output[this.indexX++] = -R.data[8] * divZ2 * this.cameraPt.x + R.data[2] / this.cameraPt.z;
        this.output[this.indexY++] = -R.data[8] * divZ2 * this.cameraPt.y + R.data[5] / this.cameraPt.z;
    }
}

