/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.javabean.JavaBeanConverter;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.core.ClassLoaderReference;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.XppDriver;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.Reader;
import javax.swing.JFileChooser;

public class UtilIO {
    public static String getPathToBase() {
        String path = "./";
        for (int i = 0; i < 3; ++i) {
            File f = new File(path);
            if (!f.exists()) {
                throw new RuntimeException("Failed");
            }
            String[] files = f.list();
            boolean foundMain = false;
            boolean foundLib = false;
            for (String s : files) {
                if (s.compareToIgnoreCase("main") == 0) {
                    foundMain = true;
                    continue;
                }
                if (s.compareToIgnoreCase("lib") != 0) continue;
                foundLib = true;
            }
            if (foundMain && foundLib) {
                return path;
            }
            path = "../" + path;
        }
        throw new RuntimeException("Base not found");
    }

    public static String selectFile(boolean exitOnCancel) {
        String fileName = null;
        JFileChooser fc = new JFileChooser();
        int returnVal = fc.showOpenDialog(null);
        if (returnVal == 0) {
            fileName = fc.getSelectedFile().getAbsolutePath();
        } else if (exitOnCancel) {
            System.exit(0);
        }
        return fileName;
    }

    public static void loadLibrarySmart(String libraryName) {
        String[] stuff;
        if (UtilIO.loadLibrary(libraryName)) {
            return;
        }
        String classPath = System.getProperty("java.class.path");
        for (String s : stuff = classPath.split(":")) {
            File f = new File(s);
            if (!f.isDirectory() || !(f = new File(s + "/" + libraryName)).exists()) continue;
            String libraryPath = System.getProperty("java.library.path");
            libraryPath = libraryPath + ":" + s;
            System.setProperty("java.library.path", libraryPath);
            if (!UtilIO.loadLibrary(libraryName)) {
                throw new RuntimeException("Shouldn't have failed to load this time");
            }
            return;
        }
        System.out.println("classPath");
    }

    public static boolean loadLibrary(String libraryName) {
        try {
            System.out.println("tring to load: " + libraryName);
            System.loadLibrary(libraryName);
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            return false;
        }
    }

    public static void saveXML(Object o, String fileName) {
        XStream xstream = UtilIO.createXStream();
        try {
            xstream.toXML(o, (OutputStream)new FileOutputStream(fileName));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T loadXML(String fileName) {
        try {
            return UtilIO.loadXML(new FileReader(fileName));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T loadXML(Reader r) {
        XStream xstream = UtilIO.createXStream();
        return (T)xstream.fromXML(r);
    }

    private static XStream createXStream() {
        XStream xstream = new XStream((ReflectionProvider)new PureJavaReflectionProvider(), (HierarchicalStreamDriver)new XppDriver(), new ClassLoaderReference(Thread.currentThread().getContextClassLoader()));
        xstream.registerConverter((Converter)new JavaBeanConverter(xstream.getMapper()));
        return xstream;
    }
}

