/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.video;

import boofcv.misc.BoofMiscOps;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.ddogleg.struct.GrowQueue_I8;

public class CombineFilesTogether {
    public static void combine(List<String> fileNames, String outputName) throws IOException {
        FileOutputStream fos = new FileOutputStream(outputName);
        GrowQueue_I8 buffer = new GrowQueue_I8();
        for (String s : fileNames) {
            File f = new File(s);
            FileInputStream fis = new FileInputStream(f);
            long length = f.length();
            buffer.resize((int)length);
            fos.write(255);
            fos.write(255);
            fos.write(255);
            fos.write((byte)(length >> 24));
            fos.write((byte)(length >> 16));
            fos.write((byte)(length >> 8));
            fos.write((byte)length);
            fis.read(buffer.data, 0, (int)length);
            fos.write(buffer.data, 0, (int)length);
        }
    }

    public static boolean readNext(DataInputStream fis, GrowQueue_I8 output) throws IOException {
        int r = fis.read();
        if (r != 255 || (r = fis.read()) != 255 || (r = fis.read()) != 255) {
            if (r == -1) {
                return false;
            }
            throw new IllegalArgumentException("Bad header byte: " + r);
        }
        int length = (fis.read() & 0xFF) << 24 | (fis.read() & 0xFF) << 16 | (fis.read() & 0xFF) << 8 | fis.read() & 0xFF;
        output.resize(length);
        fis.read(output.data, 0, length);
        return true;
    }

    public static void main(String[] args) throws IOException {
        List fileNames = BoofMiscOps.directoryList((String)"log", (String)"depth");
        Collections.sort(fileNames);
        CombineFilesTogether.combine(fileNames, "combined.mpng");
    }
}

