/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.javabean.JavaBeanConverter;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.core.ClassLoaderReference;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.XppDriver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import javax.swing.JFileChooser;

public class UtilIO {
    public static String pathExample(String path) {
        File f;
        if (new File(path).isAbsolute()) {
            return path;
        }
        File pathExample = new File(UtilIO.getPathToBase(), "data/example/");
        if (!pathExample.exists()) {
            System.err.println();
            System.err.println("Can't find data/example directory!  There are three likely causes for this problem.");
            System.err.println();
            System.err.println("1) You checked out the source code from git and did not pull the data submodule too.");
            System.err.println("2) You are trying to run an example from outside the BoofCV directory tree.");
            System.err.println("3) You are trying to pass in your own image.");
            System.err.println();
            System.err.println("Solutions:");
            System.err.println("1) Follow instructions in the boofcv/readme.md file to grab the data directory.");
            System.err.println("2) Launch the example from inside BoofCV's directory tree!");
            System.err.println("3) Don't use this function and just pass in the path directly");
            System.exit(1);
        }
        if ((f = new File(pathExample.getPath(), path)).isDirectory()) {
            return f.getAbsolutePath() + "/";
        }
        return f.getAbsolutePath();
    }

    public static String path(String path) {
        return new File(UtilIO.getPathToBase(), path).getAbsolutePath();
    }

    public static File getFileToBase() {
        return new File(UtilIO.getPathToBase());
    }

    public static String getPathToBase() {
        String path = "./";
        for (int i = 0; i < 3; ++i) {
            File f = new File(path);
            if (!f.exists()) {
                throw new RuntimeException("Failed");
            }
            String[] files = f.list();
            boolean foundMain = false;
            boolean foundExamples = false;
            boolean foundIntegration = false;
            for (String s : files) {
                if (s.compareToIgnoreCase("main") == 0) {
                    foundMain = true;
                    continue;
                }
                if (s.compareToIgnoreCase("examples") == 0) {
                    foundExamples = true;
                    continue;
                }
                if (s.compareToIgnoreCase("integration") != 0) continue;
                foundIntegration = true;
            }
            if (foundMain && foundExamples && foundIntegration) {
                return path;
            }
            path = i > 0 ? "../" + path : "../";
        }
        throw new RuntimeException("Base not found");
    }

    public static String selectFile(boolean exitOnCancel) {
        String fileName = null;
        JFileChooser fc = new JFileChooser();
        int returnVal = fc.showOpenDialog(null);
        if (returnVal == 0) {
            fileName = fc.getSelectedFile().getAbsolutePath();
        } else if (exitOnCancel) {
            System.exit(0);
        }
        return fileName;
    }

    public static void loadLibrarySmart(String libraryName) {
        String[] stuff;
        if (UtilIO.loadLibrary(libraryName)) {
            return;
        }
        String classPath = System.getProperty("java.class.path");
        for (String s : stuff = classPath.split(":")) {
            File f = new File(s);
            if (!f.isDirectory() || !(f = new File(s + "/" + libraryName)).exists()) continue;
            String libraryPath = System.getProperty("java.library.path");
            libraryPath = libraryPath + ":" + s;
            System.setProperty("java.library.path", libraryPath);
            if (!UtilIO.loadLibrary(libraryName)) {
                throw new RuntimeException("Shouldn't have failed to load this time");
            }
            return;
        }
        System.out.println("classPath");
    }

    public static boolean loadLibrary(String libraryName) {
        try {
            System.out.println("tring to load: " + libraryName);
            System.loadLibrary(libraryName);
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            return false;
        }
    }

    public static void saveXML(Object o, String fileName) {
        XStream xstream = UtilIO.createXStream();
        try {
            xstream.toXML(o, (OutputStream)new FileOutputStream(fileName));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T loadXML(URL url) {
        return UtilIO.loadXML(url.getPath());
    }

    public static <T> T loadXML(String directory, String fileName) {
        return UtilIO.loadXML(new File(directory, fileName).getPath());
    }

    public static <T> T loadXML(String fileName) {
        try {
            return UtilIO.loadXML(new FileReader(fileName));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T loadXML(Reader r) {
        XStream xstream = UtilIO.createXStream();
        return (T)xstream.fromXML(r);
    }

    private static XStream createXStream() {
        XStream xstream = new XStream((ReflectionProvider)new PureJavaReflectionProvider(), (HierarchicalStreamDriver)new XppDriver(), new ClassLoaderReference(Thread.currentThread().getContextClassLoader()));
        xstream.registerConverter((Converter)new JavaBeanConverter(xstream.getMapper()));
        return xstream;
    }

    public static void save(Object o, String fileName) {
        try {
            FileOutputStream fileOut = new FileOutputStream(fileName);
            ObjectOutputStream out = new ObjectOutputStream(fileOut);
            out.writeObject(o);
            out.close();
            fileOut.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T load(String fileName) {
        try {
            FileInputStream fileIn = new FileInputStream(fileName);
            ObjectInputStream in = new ObjectInputStream(fileIn);
            Object obj = in.readObject();
            in.close();
            fileIn.close();
            return (T)obj;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static void deleteRecursive(File f) {
        if (f.isDirectory()) {
            for (File c : f.listFiles()) {
                UtilIO.deleteRecursive(c);
            }
        }
        if (!f.delete()) {
            throw new RuntimeException("Failed to delete file: " + f);
        }
    }
}

