/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.convolve.noborder;

import boofcv.struct.convolve.Kernel1D_F32;
import boofcv.struct.convolve.Kernel1D_F64;
import boofcv.struct.convolve.Kernel1D_I32;
import boofcv.struct.convolve.Kernel2D_F32;
import boofcv.struct.convolve.Kernel2D_F64;
import boofcv.struct.convolve.Kernel2D_I32;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageFloat64;
import boofcv.struct.image.ImageInt16;
import boofcv.struct.image.ImageInt8;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageUInt8;

public class ConvolveImageStandard {
    public static void horizontal(Kernel1D_F32 kernel, ImageFloat32 image, ImageFloat32 dest) {
        float[] dataSrc = image.data;
        float[] dataDst = dest.data;
        float[] dataKer = kernel.data;
        int offset = kernel.getOffset();
        int kernelWidth = kernel.getWidth();
        int width = image.getWidth();
        for (int i = 0; i < image.height; ++i) {
            int j;
            int indexDst = dest.startIndex + i * dest.stride + offset;
            int jEnd = j + width - (kernelWidth - 1);
            for (j = image.startIndex + i * image.stride; j < jEnd; ++j) {
                float total = 0.0f;
                int indexSrc = j;
                for (int k = 0; k < kernelWidth; ++k) {
                    total += dataSrc[indexSrc++] * dataKer[k];
                }
                dataDst[indexDst++] = total;
            }
        }
    }

    public static void vertical(Kernel1D_F32 kernel, ImageFloat32 image, ImageFloat32 dest) {
        float[] dataSrc = image.data;
        float[] dataDst = dest.data;
        float[] dataKer = kernel.data;
        int offset = kernel.getOffset();
        int kernelWidth = kernel.getWidth();
        int imgWidth = dest.getWidth();
        int imgHeight = dest.getHeight();
        int yEnd = imgHeight - (kernelWidth - offset - 1);
        for (int y = offset; y < yEnd; ++y) {
            int i;
            int indexDst = dest.startIndex + y * dest.stride;
            int iEnd = i + imgWidth;
            for (i = image.startIndex + (y - offset) * image.stride; i < iEnd; ++i) {
                float total = 0.0f;
                int indexSrc = i;
                for (int k = 0; k < kernelWidth; ++k) {
                    total += dataSrc[indexSrc] * dataKer[k];
                    indexSrc += image.stride;
                }
                dataDst[indexDst++] = total;
            }
        }
    }

    public static void convolve(Kernel2D_F32 kernel, ImageFloat32 src, ImageFloat32 dest) {
        int kernelRadius;
        float[] dataKernel = kernel.data;
        float[] dataSrc = src.data;
        float[] dataDst = dest.data;
        int width = src.getWidth();
        int height = src.getHeight();
        for (int y = kernelRadius = kernel.width / 2; y < height - kernelRadius; ++y) {
            int indexDst = dest.startIndex + y * dest.stride + kernelRadius;
            for (int x = kernelRadius; x < width - kernelRadius; ++x) {
                float total = 0.0f;
                int indexKer = 0;
                for (int ki = -kernelRadius; ki <= kernelRadius; ++ki) {
                    int indexSrc = src.startIndex + (y + ki) * src.stride + x;
                    for (int kj = -kernelRadius; kj <= kernelRadius; ++kj) {
                        total += dataSrc[indexSrc + kj] * dataKernel[indexKer++];
                    }
                }
                dataDst[indexDst++] = total;
            }
        }
    }

    public static void horizontal(Kernel1D_F64 kernel, ImageFloat64 image, ImageFloat64 dest) {
        double[] dataSrc = image.data;
        double[] dataDst = dest.data;
        double[] dataKer = kernel.data;
        int offset = kernel.getOffset();
        int kernelWidth = kernel.getWidth();
        int width = image.getWidth();
        for (int i = 0; i < image.height; ++i) {
            int j;
            int indexDst = dest.startIndex + i * dest.stride + offset;
            int jEnd = j + width - (kernelWidth - 1);
            for (j = image.startIndex + i * image.stride; j < jEnd; ++j) {
                double total = 0.0;
                int indexSrc = j;
                for (int k = 0; k < kernelWidth; ++k) {
                    total += dataSrc[indexSrc++] * dataKer[k];
                }
                dataDst[indexDst++] = total;
            }
        }
    }

    public static void vertical(Kernel1D_F64 kernel, ImageFloat64 image, ImageFloat64 dest) {
        double[] dataSrc = image.data;
        double[] dataDst = dest.data;
        double[] dataKer = kernel.data;
        int offset = kernel.getOffset();
        int kernelWidth = kernel.getWidth();
        int imgWidth = dest.getWidth();
        int imgHeight = dest.getHeight();
        int yEnd = imgHeight - (kernelWidth - offset - 1);
        for (int y = offset; y < yEnd; ++y) {
            int i;
            int indexDst = dest.startIndex + y * dest.stride;
            int iEnd = i + imgWidth;
            for (i = image.startIndex + (y - offset) * image.stride; i < iEnd; ++i) {
                double total = 0.0;
                int indexSrc = i;
                for (int k = 0; k < kernelWidth; ++k) {
                    total += dataSrc[indexSrc] * dataKer[k];
                    indexSrc += image.stride;
                }
                dataDst[indexDst++] = total;
            }
        }
    }

    public static void convolve(Kernel2D_F64 kernel, ImageFloat64 src, ImageFloat64 dest) {
        int kernelRadius;
        double[] dataKernel = kernel.data;
        double[] dataSrc = src.data;
        double[] dataDst = dest.data;
        int width = src.getWidth();
        int height = src.getHeight();
        for (int y = kernelRadius = kernel.width / 2; y < height - kernelRadius; ++y) {
            int indexDst = dest.startIndex + y * dest.stride + kernelRadius;
            for (int x = kernelRadius; x < width - kernelRadius; ++x) {
                double total = 0.0;
                int indexKer = 0;
                for (int ki = -kernelRadius; ki <= kernelRadius; ++ki) {
                    int indexSrc = src.startIndex + (y + ki) * src.stride + x;
                    for (int kj = -kernelRadius; kj <= kernelRadius; ++kj) {
                        total += dataSrc[indexSrc + kj] * dataKernel[indexKer++];
                    }
                }
                dataDst[indexDst++] = total;
            }
        }
    }

    public static void horizontal(Kernel1D_I32 kernel, ImageUInt8 image, ImageInt16 dest) {
        byte[] dataSrc = image.data;
        short[] dataDst = dest.data;
        int[] dataKer = kernel.data;
        int offset = kernel.getOffset();
        int kernelWidth = kernel.getWidth();
        int width = image.getWidth();
        for (int i = 0; i < image.height; ++i) {
            int j;
            int indexDst = dest.startIndex + i * dest.stride + offset;
            int jEnd = j + width - (kernelWidth - 1);
            for (j = image.startIndex + i * image.stride; j < jEnd; ++j) {
                int total = 0;
                int indexSrc = j;
                for (int k = 0; k < kernelWidth; ++k) {
                    total += (dataSrc[indexSrc++] & 0xFF) * dataKer[k];
                }
                dataDst[indexDst++] = (short)total;
            }
        }
    }

    public static void vertical(Kernel1D_I32 kernel, ImageUInt8 image, ImageInt16 dest) {
        byte[] dataSrc = image.data;
        short[] dataDst = dest.data;
        int[] dataKer = kernel.data;
        int offset = kernel.getOffset();
        int kernelWidth = kernel.getWidth();
        int imgWidth = dest.getWidth();
        int imgHeight = dest.getHeight();
        int yEnd = imgHeight - (kernelWidth - offset - 1);
        for (int y = offset; y < yEnd; ++y) {
            int i;
            int indexDst = dest.startIndex + y * dest.stride;
            int iEnd = i + imgWidth;
            for (i = image.startIndex + (y - offset) * image.stride; i < iEnd; ++i) {
                int total = 0;
                int indexSrc = i;
                for (int k = 0; k < kernelWidth; ++k) {
                    total += (dataSrc[indexSrc] & 0xFF) * dataKer[k];
                    indexSrc += image.stride;
                }
                dataDst[indexDst++] = (short)total;
            }
        }
    }

    public static void convolve(Kernel2D_I32 kernel, ImageUInt8 src, ImageInt16 dest) {
        int kernelRadius;
        int[] dataKernel = kernel.data;
        byte[] dataSrc = src.data;
        short[] dataDst = dest.data;
        int width = src.getWidth();
        int height = src.getHeight();
        for (int y = kernelRadius = kernel.width / 2; y < height - kernelRadius; ++y) {
            int indexDst = dest.startIndex + y * dest.stride + kernelRadius;
            for (int x = kernelRadius; x < width - kernelRadius; ++x) {
                int total = 0;
                int indexKer = 0;
                for (int ki = -kernelRadius; ki <= kernelRadius; ++ki) {
                    int indexSrc = src.startIndex + (y + ki) * src.stride + x;
                    for (int kj = -kernelRadius; kj <= kernelRadius; ++kj) {
                        total += (dataSrc[indexSrc + kj] & 0xFF) * dataKernel[indexKer++];
                    }
                }
                dataDst[indexDst++] = (short)total;
            }
        }
    }

    public static void horizontal(Kernel1D_I32 kernel, ImageUInt8 image, ImageSInt32 dest) {
        byte[] dataSrc = image.data;
        int[] dataDst = dest.data;
        int[] dataKer = kernel.data;
        int offset = kernel.getOffset();
        int kernelWidth = kernel.getWidth();
        int width = image.getWidth();
        for (int i = 0; i < image.height; ++i) {
            int j;
            int indexDst = dest.startIndex + i * dest.stride + offset;
            int jEnd = j + width - (kernelWidth - 1);
            for (j = image.startIndex + i * image.stride; j < jEnd; ++j) {
                int total = 0;
                int indexSrc = j;
                for (int k = 0; k < kernelWidth; ++k) {
                    total += (dataSrc[indexSrc++] & 0xFF) * dataKer[k];
                }
                dataDst[indexDst++] = total;
            }
        }
    }

    public static void vertical(Kernel1D_I32 kernel, ImageUInt8 image, ImageSInt32 dest) {
        byte[] dataSrc = image.data;
        int[] dataDst = dest.data;
        int[] dataKer = kernel.data;
        int offset = kernel.getOffset();
        int kernelWidth = kernel.getWidth();
        int imgWidth = dest.getWidth();
        int imgHeight = dest.getHeight();
        int yEnd = imgHeight - (kernelWidth - offset - 1);
        for (int y = offset; y < yEnd; ++y) {
            int i;
            int indexDst = dest.startIndex + y * dest.stride;
            int iEnd = i + imgWidth;
            for (i = image.startIndex + (y - offset) * image.stride; i < iEnd; ++i) {
                int total = 0;
                int indexSrc = i;
                for (int k = 0; k < kernelWidth; ++k) {
                    total += (dataSrc[indexSrc] & 0xFF) * dataKer[k];
                    indexSrc += image.stride;
                }
                dataDst[indexDst++] = total;
            }
        }
    }

    public static void convolve(Kernel2D_I32 kernel, ImageUInt8 src, ImageSInt32 dest) {
        int kernelRadius;
        int[] dataKernel = kernel.data;
        byte[] dataSrc = src.data;
        int[] dataDst = dest.data;
        int width = src.getWidth();
        int height = src.getHeight();
        for (int y = kernelRadius = kernel.width / 2; y < height - kernelRadius; ++y) {
            int indexDst = dest.startIndex + y * dest.stride + kernelRadius;
            for (int x = kernelRadius; x < width - kernelRadius; ++x) {
                int total = 0;
                int indexKer = 0;
                for (int ki = -kernelRadius; ki <= kernelRadius; ++ki) {
                    int indexSrc = src.startIndex + (y + ki) * src.stride + x;
                    for (int kj = -kernelRadius; kj <= kernelRadius; ++kj) {
                        total += (dataSrc[indexSrc + kj] & 0xFF) * dataKernel[indexKer++];
                    }
                }
                dataDst[indexDst++] = total;
            }
        }
    }

    public static void horizontal(Kernel1D_I32 kernel, ImageSInt16 image, ImageInt16 dest) {
        short[] dataSrc = image.data;
        short[] dataDst = dest.data;
        int[] dataKer = kernel.data;
        int offset = kernel.getOffset();
        int kernelWidth = kernel.getWidth();
        int width = image.getWidth();
        for (int i = 0; i < image.height; ++i) {
            int j;
            int indexDst = dest.startIndex + i * dest.stride + offset;
            int jEnd = j + width - (kernelWidth - 1);
            for (j = image.startIndex + i * image.stride; j < jEnd; ++j) {
                int total = 0;
                int indexSrc = j;
                for (int k = 0; k < kernelWidth; ++k) {
                    total += dataSrc[indexSrc++] * dataKer[k];
                }
                dataDst[indexDst++] = (short)total;
            }
        }
    }

    public static void vertical(Kernel1D_I32 kernel, ImageSInt16 image, ImageInt16 dest) {
        short[] dataSrc = image.data;
        short[] dataDst = dest.data;
        int[] dataKer = kernel.data;
        int offset = kernel.getOffset();
        int kernelWidth = kernel.getWidth();
        int imgWidth = dest.getWidth();
        int imgHeight = dest.getHeight();
        int yEnd = imgHeight - (kernelWidth - offset - 1);
        for (int y = offset; y < yEnd; ++y) {
            int i;
            int indexDst = dest.startIndex + y * dest.stride;
            int iEnd = i + imgWidth;
            for (i = image.startIndex + (y - offset) * image.stride; i < iEnd; ++i) {
                int total = 0;
                int indexSrc = i;
                for (int k = 0; k < kernelWidth; ++k) {
                    total += dataSrc[indexSrc] * dataKer[k];
                    indexSrc += image.stride;
                }
                dataDst[indexDst++] = (short)total;
            }
        }
    }

    public static void convolve(Kernel2D_I32 kernel, ImageSInt16 src, ImageInt16 dest) {
        int kernelRadius;
        int[] dataKernel = kernel.data;
        short[] dataSrc = src.data;
        short[] dataDst = dest.data;
        int width = src.getWidth();
        int height = src.getHeight();
        for (int y = kernelRadius = kernel.width / 2; y < height - kernelRadius; ++y) {
            int indexDst = dest.startIndex + y * dest.stride + kernelRadius;
            for (int x = kernelRadius; x < width - kernelRadius; ++x) {
                int total = 0;
                int indexKer = 0;
                for (int ki = -kernelRadius; ki <= kernelRadius; ++ki) {
                    int indexSrc = src.startIndex + (y + ki) * src.stride + x;
                    for (int kj = -kernelRadius; kj <= kernelRadius; ++kj) {
                        total += dataSrc[indexSrc + kj] * dataKernel[indexKer++];
                    }
                }
                dataDst[indexDst++] = (short)total;
            }
        }
    }

    public static void horizontal(Kernel1D_I32 kernel, ImageUInt8 image, ImageInt8 dest, int divisor) {
        byte[] dataSrc = image.data;
        byte[] dataDst = dest.data;
        int[] dataKer = kernel.data;
        int offset = kernel.getOffset();
        int kernelWidth = kernel.getWidth();
        int halfDivisor = divisor / 2;
        int width = image.getWidth();
        for (int i = 0; i < image.height; ++i) {
            int j;
            int indexDst = dest.startIndex + i * dest.stride + offset;
            int jEnd = j + width - (kernelWidth - 1);
            for (j = image.startIndex + i * image.stride; j < jEnd; ++j) {
                int total = 0;
                int indexSrc = j;
                for (int k = 0; k < kernelWidth; ++k) {
                    total += (dataSrc[indexSrc++] & 0xFF) * dataKer[k];
                }
                dataDst[indexDst++] = (byte)((total + halfDivisor) / divisor);
            }
        }
    }

    public static void vertical(Kernel1D_I32 kernel, ImageUInt8 image, ImageInt8 dest, int divisor) {
        byte[] dataSrc = image.data;
        byte[] dataDst = dest.data;
        int[] dataKer = kernel.data;
        int offset = kernel.getOffset();
        int kernelWidth = kernel.getWidth();
        int halfDivisor = divisor / 2;
        int imgWidth = dest.getWidth();
        int imgHeight = dest.getHeight();
        int yEnd = imgHeight - (kernelWidth - offset - 1);
        for (int y = offset; y < yEnd; ++y) {
            int i;
            int indexDst = dest.startIndex + y * dest.stride;
            int iEnd = i + imgWidth;
            for (i = image.startIndex + (y - offset) * image.stride; i < iEnd; ++i) {
                int total = 0;
                int indexSrc = i;
                for (int k = 0; k < kernelWidth; ++k) {
                    total += (dataSrc[indexSrc] & 0xFF) * dataKer[k];
                    indexSrc += image.stride;
                }
                dataDst[indexDst++] = (byte)((total + halfDivisor) / divisor);
            }
        }
    }

    public static void convolve(Kernel2D_I32 kernel, ImageUInt8 src, ImageInt8 dest, int divisor) {
        int kernelRadius;
        int[] dataKernel = kernel.data;
        byte[] dataSrc = src.data;
        byte[] dataDst = dest.data;
        int width = src.getWidth();
        int height = src.getHeight();
        int halfDivisor = divisor / 2;
        for (int y = kernelRadius = kernel.width / 2; y < height - kernelRadius; ++y) {
            int indexDst = dest.startIndex + y * dest.stride + kernelRadius;
            for (int x = kernelRadius; x < width - kernelRadius; ++x) {
                int total = 0;
                int indexKer = 0;
                for (int ki = -kernelRadius; ki <= kernelRadius; ++ki) {
                    int indexSrc = src.startIndex + (y + ki) * src.stride + x;
                    for (int kj = -kernelRadius; kj <= kernelRadius; ++kj) {
                        total += (dataSrc[indexSrc + kj] & 0xFF) * dataKernel[indexKer++];
                    }
                }
                dataDst[indexDst++] = (byte)((total + halfDivisor) / divisor);
            }
        }
    }

    public static void horizontal(Kernel1D_I32 kernel, ImageSInt16 image, ImageInt16 dest, int divisor) {
        short[] dataSrc = image.data;
        short[] dataDst = dest.data;
        int[] dataKer = kernel.data;
        int offset = kernel.getOffset();
        int kernelWidth = kernel.getWidth();
        int halfDivisor = divisor / 2;
        int width = image.getWidth();
        for (int i = 0; i < image.height; ++i) {
            int j;
            int indexDst = dest.startIndex + i * dest.stride + offset;
            int jEnd = j + width - (kernelWidth - 1);
            for (j = image.startIndex + i * image.stride; j < jEnd; ++j) {
                int total = 0;
                int indexSrc = j;
                for (int k = 0; k < kernelWidth; ++k) {
                    total += dataSrc[indexSrc++] * dataKer[k];
                }
                dataDst[indexDst++] = (short)((total + halfDivisor) / divisor);
            }
        }
    }

    public static void vertical(Kernel1D_I32 kernel, ImageSInt16 image, ImageInt16 dest, int divisor) {
        short[] dataSrc = image.data;
        short[] dataDst = dest.data;
        int[] dataKer = kernel.data;
        int offset = kernel.getOffset();
        int kernelWidth = kernel.getWidth();
        int halfDivisor = divisor / 2;
        int imgWidth = dest.getWidth();
        int imgHeight = dest.getHeight();
        int yEnd = imgHeight - (kernelWidth - offset - 1);
        for (int y = offset; y < yEnd; ++y) {
            int i;
            int indexDst = dest.startIndex + y * dest.stride;
            int iEnd = i + imgWidth;
            for (i = image.startIndex + (y - offset) * image.stride; i < iEnd; ++i) {
                int total = 0;
                int indexSrc = i;
                for (int k = 0; k < kernelWidth; ++k) {
                    total += dataSrc[indexSrc] * dataKer[k];
                    indexSrc += image.stride;
                }
                dataDst[indexDst++] = (short)((total + halfDivisor) / divisor);
            }
        }
    }

    public static void convolve(Kernel2D_I32 kernel, ImageSInt16 src, ImageInt16 dest, int divisor) {
        int kernelRadius;
        int[] dataKernel = kernel.data;
        short[] dataSrc = src.data;
        short[] dataDst = dest.data;
        int width = src.getWidth();
        int height = src.getHeight();
        int halfDivisor = divisor / 2;
        for (int y = kernelRadius = kernel.width / 2; y < height - kernelRadius; ++y) {
            int indexDst = dest.startIndex + y * dest.stride + kernelRadius;
            for (int x = kernelRadius; x < width - kernelRadius; ++x) {
                int total = 0;
                int indexKer = 0;
                for (int ki = -kernelRadius; ki <= kernelRadius; ++ki) {
                    int indexSrc = src.startIndex + (y + ki) * src.stride + x;
                    for (int kj = -kernelRadius; kj <= kernelRadius; ++kj) {
                        total += dataSrc[indexSrc + kj] * dataKernel[indexKer++];
                    }
                }
                dataDst[indexDst++] = (short)((total + halfDivisor) / divisor);
            }
        }
    }

    public static void horizontal(Kernel1D_I32 kernel, ImageSInt32 image, ImageSInt32 dest) {
        int[] dataSrc = image.data;
        int[] dataDst = dest.data;
        int[] dataKer = kernel.data;
        int offset = kernel.getOffset();
        int kernelWidth = kernel.getWidth();
        int width = image.getWidth();
        for (int i = 0; i < image.height; ++i) {
            int j;
            int indexDst = dest.startIndex + i * dest.stride + offset;
            int jEnd = j + width - (kernelWidth - 1);
            for (j = image.startIndex + i * image.stride; j < jEnd; ++j) {
                int total = 0;
                int indexSrc = j;
                for (int k = 0; k < kernelWidth; ++k) {
                    total += dataSrc[indexSrc++] * dataKer[k];
                }
                dataDst[indexDst++] = total;
            }
        }
    }

    public static void vertical(Kernel1D_I32 kernel, ImageSInt32 image, ImageSInt32 dest) {
        int[] dataSrc = image.data;
        int[] dataDst = dest.data;
        int[] dataKer = kernel.data;
        int offset = kernel.getOffset();
        int kernelWidth = kernel.getWidth();
        int imgWidth = dest.getWidth();
        int imgHeight = dest.getHeight();
        int yEnd = imgHeight - (kernelWidth - offset - 1);
        for (int y = offset; y < yEnd; ++y) {
            int i;
            int indexDst = dest.startIndex + y * dest.stride;
            int iEnd = i + imgWidth;
            for (i = image.startIndex + (y - offset) * image.stride; i < iEnd; ++i) {
                int total = 0;
                int indexSrc = i;
                for (int k = 0; k < kernelWidth; ++k) {
                    total += dataSrc[indexSrc] * dataKer[k];
                    indexSrc += image.stride;
                }
                dataDst[indexDst++] = total;
            }
        }
    }

    public static void convolve(Kernel2D_I32 kernel, ImageSInt32 src, ImageSInt32 dest) {
        int kernelRadius;
        int[] dataKernel = kernel.data;
        int[] dataSrc = src.data;
        int[] dataDst = dest.data;
        int width = src.getWidth();
        int height = src.getHeight();
        for (int y = kernelRadius = kernel.width / 2; y < height - kernelRadius; ++y) {
            int indexDst = dest.startIndex + y * dest.stride + kernelRadius;
            for (int x = kernelRadius; x < width - kernelRadius; ++x) {
                int total = 0;
                int indexKer = 0;
                for (int ki = -kernelRadius; ki <= kernelRadius; ++ki) {
                    int indexSrc = src.startIndex + (y + ki) * src.stride + x;
                    for (int kj = -kernelRadius; kj <= kernelRadius; ++kj) {
                        total += dataSrc[indexSrc + kj] * dataKernel[indexKer++];
                    }
                }
                dataDst[indexDst++] = total;
            }
        }
    }

    public static void horizontal(Kernel1D_I32 kernel, ImageSInt32 image, ImageSInt32 dest, int divisor) {
        int[] dataSrc = image.data;
        int[] dataDst = dest.data;
        int[] dataKer = kernel.data;
        int offset = kernel.getOffset();
        int kernelWidth = kernel.getWidth();
        int halfDivisor = divisor / 2;
        int width = image.getWidth();
        for (int i = 0; i < image.height; ++i) {
            int j;
            int indexDst = dest.startIndex + i * dest.stride + offset;
            int jEnd = j + width - (kernelWidth - 1);
            for (j = image.startIndex + i * image.stride; j < jEnd; ++j) {
                int total = 0;
                int indexSrc = j;
                for (int k = 0; k < kernelWidth; ++k) {
                    total += dataSrc[indexSrc++] * dataKer[k];
                }
                dataDst[indexDst++] = (total + halfDivisor) / divisor;
            }
        }
    }

    public static void vertical(Kernel1D_I32 kernel, ImageSInt32 image, ImageSInt32 dest, int divisor) {
        int[] dataSrc = image.data;
        int[] dataDst = dest.data;
        int[] dataKer = kernel.data;
        int offset = kernel.getOffset();
        int kernelWidth = kernel.getWidth();
        int halfDivisor = divisor / 2;
        int imgWidth = dest.getWidth();
        int imgHeight = dest.getHeight();
        int yEnd = imgHeight - (kernelWidth - offset - 1);
        for (int y = offset; y < yEnd; ++y) {
            int i;
            int indexDst = dest.startIndex + y * dest.stride;
            int iEnd = i + imgWidth;
            for (i = image.startIndex + (y - offset) * image.stride; i < iEnd; ++i) {
                int total = 0;
                int indexSrc = i;
                for (int k = 0; k < kernelWidth; ++k) {
                    total += dataSrc[indexSrc] * dataKer[k];
                    indexSrc += image.stride;
                }
                dataDst[indexDst++] = (total + halfDivisor) / divisor;
            }
        }
    }

    public static void convolve(Kernel2D_I32 kernel, ImageSInt32 src, ImageSInt32 dest, int divisor) {
        int kernelRadius;
        int[] dataKernel = kernel.data;
        int[] dataSrc = src.data;
        int[] dataDst = dest.data;
        int width = src.getWidth();
        int height = src.getHeight();
        int halfDivisor = divisor / 2;
        for (int y = kernelRadius = kernel.width / 2; y < height - kernelRadius; ++y) {
            int indexDst = dest.startIndex + y * dest.stride + kernelRadius;
            for (int x = kernelRadius; x < width - kernelRadius; ++x) {
                int total = 0;
                int indexKer = 0;
                for (int ki = -kernelRadius; ki <= kernelRadius; ++ki) {
                    int indexSrc = src.startIndex + (y + ki) * src.stride + x;
                    for (int kj = -kernelRadius; kj <= kernelRadius; ++kj) {
                        total += dataSrc[indexSrc + kj] * dataKernel[indexKer++];
                    }
                }
                dataDst[indexDst++] = (total + halfDivisor) / divisor;
            }
        }
    }
}

