/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.misc;

import boofcv.alg.misc.PixelMath;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageFloat64;
import boofcv.struct.image.ImageInt16;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageSInt64;
import boofcv.struct.image.ImageSInt8;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageUInt16;
import boofcv.struct.image.ImageUInt8;
import boofcv.struct.image.MultiSpectral;

public class GPixelMath {
    public static <T extends ImageSingleBand> void abs(T input, T output) {
        if (ImageSInt8.class == input.getClass()) {
            PixelMath.abs((ImageSInt8)input, (ImageSInt8)output);
        } else if (ImageSInt16.class == input.getClass()) {
            PixelMath.abs((ImageSInt16)input, (ImageSInt16)output);
        } else if (ImageSInt32.class == input.getClass()) {
            PixelMath.abs((ImageSInt32)input, (ImageSInt32)output);
        } else if (ImageSInt64.class == input.getClass()) {
            PixelMath.abs((ImageSInt64)input, (ImageSInt64)output);
        } else if (ImageFloat32.class == input.getClass()) {
            PixelMath.abs((ImageFloat32)input, (ImageFloat32)output);
        } else if (ImageFloat64.class == input.getClass()) {
            PixelMath.abs((ImageFloat64)input, (ImageFloat64)output);
        }
    }

    public static <T extends ImageSingleBand> void invert(T input, T output) {
        if (ImageSInt8.class == input.getClass()) {
            PixelMath.invert((ImageSInt8)input, (ImageSInt8)output);
        } else if (ImageSInt16.class == input.getClass()) {
            PixelMath.invert((ImageSInt16)input, (ImageSInt16)output);
        } else if (ImageSInt32.class == input.getClass()) {
            PixelMath.invert((ImageSInt32)input, (ImageSInt32)output);
        } else if (ImageSInt64.class == input.getClass()) {
            PixelMath.invert((ImageSInt64)input, (ImageSInt64)output);
        } else if (ImageFloat32.class == input.getClass()) {
            PixelMath.invert((ImageFloat32)input, (ImageFloat32)output);
        } else if (ImageFloat64.class == input.getClass()) {
            PixelMath.invert((ImageFloat64)input, (ImageFloat64)output);
        } else {
            throw new IllegalArgumentException("Unsupported image type.  Input image must be signed");
        }
    }

    public static <T extends ImageSingleBand> void divide(T input, double denominator, T output) {
        if (ImageUInt8.class == input.getClass()) {
            PixelMath.divide((ImageUInt8)input, denominator, (ImageUInt8)output);
        } else if (ImageSInt8.class == input.getClass()) {
            PixelMath.divide((ImageSInt8)input, denominator, (ImageSInt8)output);
        } else if (ImageUInt16.class == input.getClass()) {
            PixelMath.divide((ImageUInt16)input, denominator, (ImageUInt16)output);
        } else if (ImageSInt16.class == input.getClass()) {
            PixelMath.divide((ImageSInt16)input, denominator, (ImageSInt16)output);
        } else if (ImageSInt32.class == input.getClass()) {
            PixelMath.divide((ImageSInt32)input, denominator, (ImageSInt32)output);
        } else if (ImageSInt64.class == input.getClass()) {
            PixelMath.divide((ImageSInt64)input, denominator, (ImageSInt64)output);
        } else if (ImageFloat32.class == input.getClass()) {
            PixelMath.divide((ImageFloat32)input, (float)denominator, (ImageFloat32)output);
        } else if (ImageFloat64.class == input.getClass()) {
            PixelMath.divide((ImageFloat64)input, denominator, (ImageFloat64)output);
        } else {
            throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
        }
    }

    public static <T extends ImageSingleBand> void divide(T input, double denominator, double lower, double upper, T output) {
        if (ImageUInt8.class == input.getClass()) {
            PixelMath.divide((ImageUInt8)input, denominator, (int)lower, (int)upper, (ImageUInt8)output);
        } else if (ImageSInt8.class == input.getClass()) {
            PixelMath.divide((ImageSInt8)input, denominator, (int)lower, (int)upper, (ImageSInt8)output);
        } else if (ImageUInt16.class == input.getClass()) {
            PixelMath.divide((ImageUInt16)input, denominator, (int)lower, (int)upper, (ImageUInt16)output);
        } else if (ImageSInt16.class == input.getClass()) {
            PixelMath.divide((ImageSInt16)input, denominator, (int)lower, (int)upper, (ImageSInt16)output);
        } else if (ImageSInt32.class == input.getClass()) {
            PixelMath.divide((ImageSInt32)input, denominator, (int)lower, (int)upper, (ImageSInt32)output);
        } else if (ImageSInt64.class == input.getClass()) {
            PixelMath.divide((ImageSInt64)input, denominator, (long)lower, (long)upper, (ImageSInt64)output);
        } else if (ImageFloat32.class == input.getClass()) {
            PixelMath.divide((ImageFloat32)input, (float)denominator, (float)lower, (float)upper, (ImageFloat32)output);
        } else if (ImageFloat64.class == input.getClass()) {
            PixelMath.divide((ImageFloat64)input, denominator, lower, upper, (ImageFloat64)output);
        } else {
            throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
        }
    }

    public static <T extends ImageSingleBand> void divide(T imgA, T imgB, T output) {
        if (ImageFloat32.class == imgA.getClass()) {
            PixelMath.divide((ImageFloat32)imgA, (ImageFloat32)imgB, (ImageFloat32)output);
        } else if (ImageFloat64.class == imgA.getClass()) {
            PixelMath.divide((ImageFloat64)imgA, (ImageFloat64)imgB, (ImageFloat64)output);
        } else {
            throw new IllegalArgumentException("Unknown image Type: " + imgA.getClass().getSimpleName());
        }
    }

    public static <T extends ImageSingleBand> void multiply(T input, double value, T output) {
        if (ImageUInt8.class == input.getClass()) {
            PixelMath.multiply((ImageUInt8)input, value, (ImageUInt8)output);
        } else if (ImageSInt8.class == input.getClass()) {
            PixelMath.multiply((ImageSInt8)input, value, (ImageSInt8)output);
        } else if (ImageUInt16.class == input.getClass()) {
            PixelMath.multiply((ImageUInt16)input, value, (ImageUInt16)output);
        } else if (ImageSInt16.class == input.getClass()) {
            PixelMath.multiply((ImageSInt16)input, value, (ImageSInt16)output);
        } else if (ImageSInt32.class == input.getClass()) {
            PixelMath.multiply((ImageSInt32)input, value, (ImageSInt32)output);
        } else if (ImageSInt64.class == input.getClass()) {
            PixelMath.multiply((ImageSInt64)input, value, (ImageSInt64)output);
        } else if (ImageFloat32.class == input.getClass()) {
            PixelMath.multiply((ImageFloat32)input, (float)value, (ImageFloat32)output);
        } else if (ImageFloat64.class == input.getClass()) {
            PixelMath.multiply((ImageFloat64)input, value, (ImageFloat64)output);
        } else {
            throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
        }
    }

    public static <T extends ImageSingleBand> void multiply(T input, double value, double lower, double upper, T output) {
        if (ImageUInt8.class == input.getClass()) {
            PixelMath.multiply((ImageUInt8)input, value, (int)lower, (int)upper, (ImageUInt8)output);
        } else if (ImageSInt8.class == input.getClass()) {
            PixelMath.multiply((ImageSInt8)input, value, (int)lower, (int)upper, (ImageSInt8)output);
        } else if (ImageUInt16.class == input.getClass()) {
            PixelMath.multiply((ImageUInt16)input, value, (int)lower, (int)upper, (ImageUInt16)output);
        } else if (ImageSInt16.class == input.getClass()) {
            PixelMath.multiply((ImageSInt16)input, value, (int)lower, (int)upper, (ImageSInt16)output);
        } else if (ImageSInt32.class == input.getClass()) {
            PixelMath.multiply((ImageSInt32)input, value, (int)lower, (int)upper, (ImageSInt32)output);
        } else if (ImageSInt64.class == input.getClass()) {
            PixelMath.multiply((ImageSInt64)input, value, (long)lower, (long)upper, (ImageSInt64)output);
        } else if (ImageFloat32.class == input.getClass()) {
            PixelMath.multiply((ImageFloat32)input, (float)value, (float)lower, (float)upper, (ImageFloat32)output);
        } else if (ImageFloat64.class == input.getClass()) {
            PixelMath.multiply((ImageFloat64)input, value, lower, upper, (ImageFloat64)output);
        } else {
            throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
        }
    }

    public static <T extends ImageSingleBand> void multiply(T imgA, T imgB, T output) {
        if (ImageFloat32.class == imgA.getClass()) {
            PixelMath.multiply((ImageFloat32)imgA, (ImageFloat32)imgB, (ImageFloat32)output);
        } else if (ImageFloat64.class == imgA.getClass()) {
            PixelMath.multiply((ImageFloat64)imgA, (ImageFloat64)imgB, (ImageFloat64)output);
        } else {
            throw new IllegalArgumentException("Unknown image Type: " + imgA.getClass().getSimpleName());
        }
    }

    public static <T extends ImageSingleBand> void log(T input, T output) {
        if (ImageFloat32.class == input.getClass()) {
            PixelMath.log((ImageFloat32)input, (ImageFloat32)output);
        } else if (ImageFloat64.class == input.getClass()) {
            PixelMath.log((ImageFloat64)input, (ImageFloat64)output);
        } else {
            throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
        }
    }

    public static <T extends ImageSingleBand> void plus(T input, double value, T output) {
        if (ImageUInt8.class == input.getClass()) {
            PixelMath.plus((ImageUInt8)input, (int)value, (ImageUInt8)output);
        } else if (ImageSInt8.class == input.getClass()) {
            PixelMath.plus((ImageSInt8)input, (int)value, (ImageSInt8)output);
        } else if (ImageUInt16.class == input.getClass()) {
            PixelMath.plus((ImageUInt16)input, (int)value, (ImageUInt16)output);
        } else if (ImageSInt16.class == input.getClass()) {
            PixelMath.plus((ImageSInt16)input, (int)value, (ImageSInt16)output);
        } else if (ImageSInt32.class == input.getClass()) {
            PixelMath.plus((ImageSInt32)input, (int)value, (ImageSInt32)output);
        } else if (ImageSInt64.class == input.getClass()) {
            PixelMath.plus((ImageSInt64)input, (long)((int)value), (ImageSInt64)output);
        } else if (ImageFloat32.class == input.getClass()) {
            PixelMath.plus((ImageFloat32)input, (float)value, (ImageFloat32)output);
        } else if (ImageFloat64.class == input.getClass()) {
            PixelMath.plus((ImageFloat64)input, value, (ImageFloat64)output);
        } else {
            throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
        }
    }

    public static <T extends ImageSingleBand> void plus(T input, double value, double lower, double upper, T output) {
        if (ImageUInt8.class == input.getClass()) {
            PixelMath.plus((ImageUInt8)input, (int)value, (int)lower, (int)upper, (ImageUInt8)output);
        } else if (ImageSInt8.class == input.getClass()) {
            PixelMath.plus((ImageSInt8)input, (int)value, (int)lower, (int)upper, (ImageSInt8)output);
        } else if (ImageUInt16.class == input.getClass()) {
            PixelMath.plus((ImageUInt16)input, (int)value, (int)lower, (int)upper, (ImageUInt16)output);
        } else if (ImageSInt16.class == input.getClass()) {
            PixelMath.plus((ImageSInt16)input, (int)value, (int)lower, (int)upper, (ImageSInt16)output);
        } else if (ImageSInt32.class == input.getClass()) {
            PixelMath.plus((ImageSInt32)input, (int)value, (int)lower, (int)upper, (ImageSInt32)output);
        } else if (ImageSInt64.class == input.getClass()) {
            PixelMath.plus((ImageSInt64)input, (long)((int)value), (long)lower, (long)upper, (ImageSInt64)output);
        } else if (ImageFloat32.class == input.getClass()) {
            PixelMath.plus((ImageFloat32)input, (float)value, (float)lower, (float)upper, (ImageFloat32)output);
        } else if (ImageFloat64.class == input.getClass()) {
            PixelMath.plus((ImageFloat64)input, value, lower, upper, (ImageFloat64)output);
        } else {
            throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
        }
    }

    public static <T extends ImageSingleBand, O extends ImageSingleBand> void add(T inputA, T inputB, O output) {
        if (ImageUInt8.class == inputA.getClass()) {
            PixelMath.add((ImageUInt8)inputA, (ImageUInt8)inputB, (ImageUInt16)output);
        } else if (ImageSInt8.class == inputA.getClass()) {
            PixelMath.add((ImageSInt8)inputA, (ImageSInt8)inputB, (ImageSInt16)output);
        } else if (ImageUInt16.class == inputA.getClass()) {
            PixelMath.add((ImageUInt16)inputA, (ImageUInt16)inputB, (ImageSInt32)output);
        } else if (ImageSInt16.class == inputA.getClass()) {
            PixelMath.add((ImageSInt16)inputA, (ImageSInt16)inputB, (ImageSInt32)output);
        } else if (ImageSInt32.class == inputA.getClass()) {
            PixelMath.add((ImageSInt32)inputA, (ImageSInt32)inputB, (ImageSInt32)output);
        } else if (ImageSInt64.class == inputA.getClass()) {
            PixelMath.add((ImageSInt64)inputA, (ImageSInt64)inputB, (ImageSInt64)output);
        } else if (ImageFloat32.class == inputA.getClass()) {
            PixelMath.add((ImageFloat32)inputA, (ImageFloat32)inputB, (ImageFloat32)output);
        } else if (ImageFloat64.class == inputA.getClass()) {
            PixelMath.add((ImageFloat64)inputA, (ImageFloat64)inputB, (ImageFloat64)output);
        } else {
            throw new IllegalArgumentException("Unknown image Type: " + inputA.getClass().getSimpleName());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T extends ImageBase, O extends ImageBase> void subtract(T inputA, T inputB, O output) {
        if (!(inputA instanceof ImageSingleBand)) throw new IllegalArgumentException("Unknown image Type: " + inputA.getClass().getSimpleName());
        if (ImageUInt8.class == inputA.getClass()) {
            PixelMath.subtract((ImageUInt8)inputA, (ImageUInt8)inputB, (ImageInt16)output);
            return;
        } else if (ImageSInt8.class == inputA.getClass()) {
            PixelMath.subtract((ImageSInt8)inputA, (ImageSInt8)inputB, (ImageSInt16)output);
            return;
        } else if (ImageUInt16.class == inputA.getClass()) {
            PixelMath.subtract((ImageUInt16)inputA, (ImageUInt16)inputB, (ImageSInt32)output);
            return;
        } else if (ImageSInt16.class == inputA.getClass()) {
            PixelMath.subtract((ImageSInt16)inputA, (ImageSInt16)inputB, (ImageSInt32)output);
            return;
        } else if (ImageSInt32.class == inputA.getClass()) {
            PixelMath.subtract((ImageSInt32)inputA, (ImageSInt32)inputB, (ImageSInt32)output);
            return;
        } else if (ImageSInt64.class == inputA.getClass()) {
            PixelMath.subtract((ImageSInt64)inputA, (ImageSInt64)inputB, (ImageSInt64)output);
            return;
        } else if (ImageFloat32.class == inputA.getClass()) {
            PixelMath.subtract((ImageFloat32)inputA, (ImageFloat32)inputB, (ImageFloat32)output);
            return;
        } else {
            if (ImageFloat64.class != inputA.getClass()) throw new IllegalArgumentException("Unknown image Type: " + inputA.getClass().getSimpleName());
            PixelMath.subtract((ImageFloat64)inputA, (ImageFloat64)inputB, (ImageFloat64)output);
        }
    }

    public static <T extends ImageSingleBand> void boundImage(T input, double min, double max) {
        if (ImageUInt8.class == input.getClass()) {
            PixelMath.boundImage((ImageUInt8)input, (int)min, (int)max);
        } else if (ImageSInt8.class == input.getClass()) {
            PixelMath.boundImage((ImageSInt8)input, (int)min, (int)max);
        } else if (ImageUInt16.class == input.getClass()) {
            PixelMath.boundImage((ImageUInt16)input, (int)min, (int)max);
        } else if (ImageSInt16.class == input.getClass()) {
            PixelMath.boundImage((ImageSInt16)input, (int)min, (int)max);
        } else if (ImageSInt32.class == input.getClass()) {
            PixelMath.boundImage((ImageSInt32)input, (int)min, (int)max);
        } else if (ImageSInt64.class == input.getClass()) {
            PixelMath.boundImage((ImageSInt64)input, (long)min, (long)max);
        } else if (ImageFloat32.class == input.getClass()) {
            PixelMath.boundImage((ImageFloat32)input, (float)min, (float)max);
        } else if (ImageFloat64.class == input.getClass()) {
            PixelMath.boundImage((ImageFloat64)input, min, max);
        } else {
            throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
        }
    }

    public static <T extends ImageSingleBand> void diffAbs(T inputA, T inputB, T output) {
        if (ImageUInt8.class == inputA.getClass()) {
            PixelMath.diffAbs((ImageUInt8)inputA, (ImageUInt8)inputB, (ImageUInt8)output);
        } else if (ImageSInt8.class == inputA.getClass()) {
            PixelMath.diffAbs((ImageSInt8)inputA, (ImageSInt8)inputB, (ImageSInt8)output);
        } else if (ImageUInt16.class == inputA.getClass()) {
            PixelMath.diffAbs((ImageUInt16)inputA, (ImageUInt16)inputB, (ImageUInt16)output);
        } else if (ImageSInt16.class == inputA.getClass()) {
            PixelMath.diffAbs((ImageSInt16)inputA, (ImageSInt16)inputB, (ImageSInt16)output);
        } else if (ImageSInt32.class == inputA.getClass()) {
            PixelMath.diffAbs((ImageSInt32)inputA, (ImageSInt32)inputB, (ImageSInt32)output);
        } else if (ImageSInt64.class == inputA.getClass()) {
            PixelMath.diffAbs((ImageSInt64)inputA, (ImageSInt64)inputB, (ImageSInt64)output);
        } else if (ImageFloat32.class == inputA.getClass()) {
            PixelMath.diffAbs((ImageFloat32)inputA, (ImageFloat32)inputB, (ImageFloat32)output);
        } else if (ImageFloat64.class == inputA.getClass()) {
            PixelMath.diffAbs((ImageFloat64)inputA, (ImageFloat64)inputB, (ImageFloat64)output);
        } else {
            throw new IllegalArgumentException("Unknown image Type: " + inputA.getClass().getSimpleName());
        }
    }

    public static <T extends ImageSingleBand> void averageBand(MultiSpectral<T> input, T output) {
        if (ImageUInt8.class == input.getType()) {
            PixelMath.averageBand(input, (ImageUInt8)output);
        } else if (ImageSInt8.class == input.getType()) {
            PixelMath.averageBand(input, (ImageSInt8)output);
        } else if (ImageUInt16.class == input.getType()) {
            PixelMath.averageBand(input, (ImageUInt16)output);
        } else if (ImageSInt16.class == input.getType()) {
            PixelMath.averageBand(input, (ImageSInt16)output);
        } else if (ImageSInt32.class == input.getType()) {
            PixelMath.averageBand(input, (ImageSInt32)output);
        } else if (ImageSInt64.class == input.getType()) {
            PixelMath.averageBand(input, (ImageSInt64)output);
        } else if (ImageFloat32.class == input.getType()) {
            PixelMath.averageBand(input, (ImageFloat32)output);
        } else if (ImageFloat64.class == input.getType()) {
            PixelMath.averageBand(input, (ImageFloat64)output);
        } else {
            throw new IllegalArgumentException("Unknown image Type: " + input.getType().getSimpleName());
        }
    }
}

