/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.filter.convolve;

import boofcv.abst.filter.convolve.ConvolveInterface;
import boofcv.abst.filter.convolve.GenericConvolve;
import boofcv.alg.filter.convolve.ConvolveImageNoBorder;
import boofcv.alg.filter.convolve.ConvolveNormalized;
import boofcv.alg.filter.convolve.ConvolveWithBorder;
import boofcv.core.image.border.BorderType;
import boofcv.core.image.border.FactoryImageBorder;
import boofcv.core.image.border.ImageBorder;
import boofcv.struct.convolve.Kernel1D;
import boofcv.struct.convolve.Kernel2D;
import boofcv.struct.image.ImageSingleBand;
import boofcv.testing.BoofTesting;
import java.lang.reflect.Method;

public class FactoryConvolve {
    public static <Input extends ImageSingleBand, Output extends ImageSingleBand> ConvolveInterface<Input, Output> convolve(Kernel1D kernel, Class<Input> inputType, Class<Output> outputType, BorderType border, boolean isHorizontal) {
        Method m;
        outputType = (Class)BoofTesting.convertToGenericType(outputType);
        Class<ImageBorder> borderClassType = FactoryImageBorder.lookupBorderClassType(inputType);
        String direction = isHorizontal ? "horizontal" : "vertical";
        try {
            switch (border) {
                case SKIP: {
                    m = ConvolveImageNoBorder.class.getMethod(direction, kernel.getClass(), inputType, outputType);
                    break;
                }
                case EXTENDED: {
                    m = BoofTesting.findMethod(ConvolveWithBorder.class, direction, kernel.getClass(), inputType, outputType, borderClassType);
                    break;
                }
                case REFLECT: {
                    m = BoofTesting.findMethod(ConvolveWithBorder.class, direction, kernel.getClass(), inputType, outputType, borderClassType);
                    break;
                }
                case WRAP: {
                    m = BoofTesting.findMethod(ConvolveWithBorder.class, direction, kernel.getClass(), inputType, outputType, borderClassType);
                    break;
                }
                case NORMALIZED: {
                    m = ConvolveNormalized.class.getMethod(direction, kernel.getClass(), inputType, outputType);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown border type " + (Object)((Object)border));
                }
            }
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("The specified convolution cannot be found");
        }
        return new GenericConvolve(m, kernel, border, inputType);
    }

    public static <Input extends ImageSingleBand, Output extends ImageSingleBand> ConvolveInterface<Input, Output> convolve(Kernel2D kernel, Class<Input> inputType, Class<Output> outputType, BorderType borderType) {
        Method m;
        outputType = (Class)BoofTesting.convertToGenericType(outputType);
        Class<ImageBorder> borderClassType = FactoryImageBorder.lookupBorderClassType(inputType);
        try {
            switch (borderType) {
                case SKIP: {
                    m = ConvolveImageNoBorder.class.getMethod("convolve", kernel.getClass(), inputType, outputType);
                    break;
                }
                case EXTENDED: {
                    m = BoofTesting.findMethod(ConvolveWithBorder.class, "convolve", kernel.getClass(), inputType, outputType, borderClassType);
                    break;
                }
                case REFLECT: {
                    m = BoofTesting.findMethod(ConvolveWithBorder.class, "convolve", kernel.getClass(), inputType, outputType, borderClassType);
                    break;
                }
                case WRAP: {
                    m = BoofTesting.findMethod(ConvolveWithBorder.class, "convolve", kernel.getClass(), inputType, outputType, borderClassType);
                    break;
                }
                case NORMALIZED: {
                    m = ConvolveNormalized.class.getMethod("convolve", kernel.getClass(), inputType, outputType);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown border type " + (Object)((Object)borderType));
                }
            }
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("The specified convolution cannot be found");
        }
        return new GenericConvolve(m, kernel, borderType, inputType);
    }
}

