/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.convolve;

import boofcv.struct.convolve.Kernel1D;

public class Kernel1D_I32
extends Kernel1D {
    public int[] data;

    public Kernel1D_I32(int[] data, int width) {
        this(data, width / 2, width);
        if (width % 2 != 1) {
            throw new IllegalArgumentException("Kernel must be add to use this constructor");
        }
    }

    public Kernel1D_I32(int[] data, int offset, int width) {
        super(offset, width);
        this.data = new int[width];
        System.arraycopy(data, 0, this.data, 0, width);
    }

    public Kernel1D_I32(int width) {
        this(width / 2, width);
    }

    public Kernel1D_I32(int offset, int width) {
        super(offset, width);
        this.data = new int[width];
    }

    protected Kernel1D_I32() {
    }

    public static Kernel1D_I32 wrap(int[] data, int width) {
        Kernel1D_I32 ret = new Kernel1D_I32();
        ret.data = data;
        ret.width = width;
        ret.offset = width / 2;
        return ret;
    }

    @Override
    public boolean isInteger() {
        return true;
    }

    public int get(int i) {
        return this.data[i];
    }

    public int computeSum() {
        int sum = 0;
        for (int i = 0; i < this.data.length; ++i) {
            sum += this.data[i];
        }
        return sum;
    }

    public int[] getData() {
        return this.data;
    }

    public void print() {
        for (int i = 0; i < this.width; ++i) {
            System.out.printf("%6d ", this.data[i]);
        }
        System.out.println();
    }
}

