/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.filter.blur;

import boofcv.abst.filter.blur.BlurFilter;
import boofcv.alg.filter.blur.BlurImageOps;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class BlurStorageFilter<T extends ImageSingleBand>
implements BlurFilter<T> {
    private Method m;
    private double sigma;
    private int radius;
    private ImageSingleBand storage;
    private boolean hasSigma;
    Class<T> inputType;

    public BlurStorageFilter(String functionName, Class<T> inputType, int radius) {
        this.radius = radius;
        this.inputType = inputType;
        this.hasSigma = false;
        this.m = this.findMethod(functionName, inputType);
        Class<?>[] params = this.m.getParameterTypes();
        if (params.length == 4) {
            this.storage = GeneralizedImageOps.createSingleBand(this.m.getParameterTypes()[3], 1, 1);
        }
    }

    public BlurStorageFilter(String functionName, Class<T> inputType, double sigma, int radius) {
        this.radius = radius;
        this.sigma = sigma;
        this.inputType = inputType;
        this.hasSigma = true;
        this.m = this.findMethod(functionName, inputType);
        this.storage = GeneralizedImageOps.createSingleBand(this.m.getParameterTypes()[4], 1, 1);
    }

    private Method findMethod(String name, Class<T> inputType) {
        Method[] methods = BlurImageOps.class.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] params;
            Method m = methods[i];
            if (!m.getName().equals(name) || (params = m.getParameterTypes())[1] != inputType) continue;
            return m;
        }
        throw new RuntimeException("Can't find function " + name + "  " + inputType.getSimpleName());
    }

    @Override
    public int getRadius() {
        return this.radius;
    }

    @Override
    public void setRadius(int radius) {
        this.radius = radius;
    }

    @Override
    public void process(T input, T output) {
        try {
            if (this.storage != null) {
                this.storage.reshape(((ImageSingleBand)output).width, ((ImageSingleBand)output).height);
                if (this.hasSigma) {
                    this.m.invoke(null, input, output, this.sigma, this.radius, this.storage);
                } else {
                    this.m.invoke(null, input, output, this.radius, this.storage);
                }
            } else {
                this.m.invoke(null, input, output, this.radius);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getHorizontalBorder() {
        return 0;
    }

    @Override
    public int getVerticalBorder() {
        return 0;
    }

    @Override
    public ImageType<T> getInputType() {
        return ImageType.single(this.inputType);
    }

    @Override
    public ImageType<T> getOutputType() {
        return ImageType.single(this.inputType);
    }
}

