/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.color;

import boofcv.alg.InputSanityCheck;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageUInt8;
import boofcv.struct.image.MultiSpectral;

public class ColorXyz {
    public static void rgbToXyz(int r, int g, int b, double[] xyz) {
        ColorXyz.srgbToXyz((double)r / 255.0, (double)g / 255.0, (double)b / 255.0, xyz);
    }

    public static void rgbToXyz(int r, int g, int b, float[] xyz) {
        ColorXyz.srgbToXyz((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, xyz);
    }

    public static void srgbToXyz(double r, double g, double b, double[] xyz) {
        xyz[0] = 0.412453 * r + 0.35758 * g + 0.180423 * b;
        xyz[1] = 0.212671 * r + 0.71516 * g + 0.072169 * b;
        xyz[2] = 0.019334 * r + 0.119193 * g + 0.950227 * b;
    }

    public static void srgbToXyz(float r, float g, float b, float[] xyz) {
        xyz[0] = 0.412453f * r + 0.35758f * g + 0.180423f * b;
        xyz[1] = 0.212671f * r + 0.71516f * g + 0.072169f * b;
        xyz[2] = 0.019334f * r + 0.119193f * g + 0.950227f * b;
    }

    public static void xyzToSrgb(float x, float y, float z, float[] srgb) {
        srgb[0] = 3.240479f * x - 1.53715f * y - 0.498535f * z;
        srgb[1] = -0.969256f * x + 1.875991f * y + 0.041556f * z;
        srgb[2] = 0.055648f * x - 0.204043f * y + 1.057311f * z;
    }

    public static void xyzToSrgb(double x, double y, double z, double[] srgb) {
        srgb[0] = 3.240479 * x - 1.53715 * y - 0.498535 * z;
        srgb[1] = -0.969256 * x + 1.875991 * y + 0.041556 * z;
        srgb[2] = 0.055648 * x - 0.204043 * y + 1.057311 * z;
    }

    public static void rgbToXyz_F32(MultiSpectral<ImageFloat32> rgb, MultiSpectral<ImageFloat32> xyz) {
        InputSanityCheck.checkSameShape(xyz, rgb);
        ImageFloat32 R = rgb.getBand(0);
        ImageFloat32 G = rgb.getBand(1);
        ImageFloat32 B = rgb.getBand(2);
        ImageFloat32 X = xyz.getBand(0);
        ImageFloat32 Y = xyz.getBand(1);
        ImageFloat32 Z = xyz.getBand(2);
        for (int row = 0; row < xyz.height; ++row) {
            int indexXyz = xyz.startIndex + row * xyz.stride;
            int indexRgb = rgb.startIndex + row * rgb.stride;
            int col = 0;
            while (col < xyz.width) {
                float r = R.data[indexRgb] / 255.0f;
                float g = G.data[indexRgb] / 255.0f;
                float b = B.data[indexRgb] / 255.0f;
                X.data[indexXyz] = 0.412453f * r + 0.35758f * g + 0.180423f * b;
                Y.data[indexXyz] = 0.212671f * r + 0.71516f * g + 0.072169f * b;
                Z.data[indexXyz] = 0.019334f * r + 0.119193f * g + 0.950227f * b;
                ++col;
                ++indexXyz;
                ++indexRgb;
            }
        }
    }

    public static void rgbToXyz_U8(MultiSpectral<ImageUInt8> rgb, MultiSpectral<ImageFloat32> xyz) {
        InputSanityCheck.checkSameShape(xyz, rgb);
        ImageUInt8 R = rgb.getBand(0);
        ImageUInt8 G = rgb.getBand(1);
        ImageUInt8 B = rgb.getBand(2);
        ImageFloat32 X = xyz.getBand(0);
        ImageFloat32 Y = xyz.getBand(1);
        ImageFloat32 Z = xyz.getBand(2);
        for (int row = 0; row < xyz.height; ++row) {
            int indexXyz = xyz.startIndex + row * xyz.stride;
            int indexRgb = rgb.startIndex + row * rgb.stride;
            int col = 0;
            while (col < xyz.width) {
                float r = (float)(R.data[indexRgb] & 0xFF) / 255.0f;
                float g = (float)(G.data[indexRgb] & 0xFF) / 255.0f;
                float b = (float)(B.data[indexRgb] & 0xFF) / 255.0f;
                X.data[indexXyz] = 0.412453f * r + 0.35758f * g + 0.180423f * b;
                Y.data[indexXyz] = 0.212671f * r + 0.71516f * g + 0.072169f * b;
                Z.data[indexXyz] = 0.019334f * r + 0.119193f * g + 0.950227f * b;
                ++col;
                ++indexXyz;
                ++indexRgb;
            }
        }
    }
}

