/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.denoise.wavelet;

import boofcv.alg.denoise.ShrinkThresholdRule;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.struct.image.ImageFloat32;

public class ShrinkThresholdHard_F32
implements ShrinkThresholdRule<ImageFloat32> {
    @Override
    public void process(ImageFloat32 image, Number threshold) {
        float f = threshold.floatValue();
        if (Float.isInfinite(f)) {
            ImageMiscOps.fill(image, 0.0f);
            return;
        }
        for (int y = 0; y < image.height; ++y) {
            int index;
            int end = index + image.width;
            for (index = image.startIndex + y * image.stride; index < end; ++index) {
                float v = image.data[index];
                if (!(Math.abs(v) < f)) continue;
                image.data[index] = 0.0f;
            }
        }
    }
}

