/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.denoise.wavelet;

import boofcv.alg.denoise.ShrinkThresholdRule;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.struct.image.ImageSInt32;

public class ShrinkThresholdSoft_I32
implements ShrinkThresholdRule<ImageSInt32> {
    @Override
    public void process(ImageSInt32 image, Number threshold) {
        int f = threshold.intValue();
        if (f == Integer.MAX_VALUE) {
            ImageMiscOps.fill(image, 0);
            return;
        }
        for (int y = 0; y < image.height; ++y) {
            int index;
            int end = index + image.width;
            for (index = image.startIndex + y * image.stride; index < end; ++index) {
                float v = image.data[index];
                if (Math.abs(v) < (float)f) {
                    image.data[index] = 0;
                    continue;
                }
                if (v >= (float)f) {
                    int n = index;
                    image.data[n] = image.data[n] - f;
                    continue;
                }
                int n = index;
                image.data[n] = image.data[n] + f;
            }
        }
    }
}

