/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.convolve.down;

import boofcv.alg.filter.convolve.down.UtilDownConvolve;
import boofcv.struct.convolve.Kernel1D_F32;
import boofcv.struct.convolve.Kernel1D_I32;
import boofcv.struct.convolve.Kernel2D_F32;
import boofcv.struct.convolve.Kernel2D_I32;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageInt16;
import boofcv.struct.image.ImageInt8;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageUInt8;

public class ConvolveDownNormalized_JustBorder {
    public static void horizontal(Kernel1D_F32 kernel, ImageFloat32 input, ImageFloat32 output, int skip) {
        float[] dataSrc = input.data;
        float[] dataDst = output.data;
        float[] dataKer = kernel.data;
        int radius = kernel.getRadius();
        int offset = UtilDownConvolve.computeOffset(skip, radius);
        int offsetEnd = UtilDownConvolve.computeMaxSide(input.width, skip, radius) + skip;
        int width = input.width - input.width % skip;
        int height = input.getHeight();
        for (int y = 0; y < height; ++y) {
            float weight;
            float total;
            int indexSrc;
            int x;
            int indexDest = output.startIndex + y * output.stride;
            for (x = 0; x < offset; x += skip) {
                indexSrc = input.startIndex + y * input.stride + x;
                total = 0.0f;
                weight = 0.0f;
                for (int k = -x; k <= radius; ++k) {
                    float w = dataKer[k + radius];
                    weight += w;
                    total += dataSrc[indexSrc + k] * w;
                }
                dataDst[indexDest++] = total / weight;
            }
            indexDest = output.startIndex + y * output.stride + offsetEnd / skip;
            for (x = offsetEnd; x < width; x += skip) {
                indexSrc = input.startIndex + y * input.stride + x;
                total = 0.0f;
                weight = 0.0f;
                int endKernel = input.width - x - 1;
                if (endKernel > radius) {
                    endKernel = radius;
                }
                for (int k = -radius; k <= endKernel; ++k) {
                    float w = dataKer[k + radius];
                    weight += w;
                    total += dataSrc[indexSrc + k] * w;
                }
                dataDst[indexDest++] = total / weight;
            }
        }
    }

    public static void vertical(Kernel1D_F32 kernel, ImageFloat32 input, ImageFloat32 output, int skip) {
        int indexDest;
        int y;
        float[] dataSrc = input.data;
        float[] dataDst = output.data;
        float[] dataKer = kernel.data;
        int radius = kernel.getRadius();
        int offset = UtilDownConvolve.computeOffset(skip, radius);
        int offsetEnd = UtilDownConvolve.computeMaxSide(input.height, skip, radius) + skip;
        int width = input.width;
        int height = input.height - input.height % skip;
        for (y = 0; y < offset; y += skip) {
            indexDest = output.startIndex + y / skip * output.stride;
            for (int x = 0; x < width; ++x) {
                int indexSrc = input.startIndex + y * input.stride + x;
                float total = 0.0f;
                float weight = 0.0f;
                for (int k = -y; k <= radius; ++k) {
                    float w = dataKer[k + radius];
                    weight += w;
                    total += dataSrc[indexSrc + k * input.stride] * w;
                }
                dataDst[indexDest++] = total / weight;
            }
        }
        for (y = offsetEnd; y < height; y += skip) {
            indexDest = output.startIndex + y / skip * output.stride;
            int endKernel = input.height - y - 1;
            if (endKernel > radius) {
                endKernel = radius;
            }
            for (int x = 0; x < width; ++x) {
                int indexSrc = input.startIndex + y * input.stride + x;
                float total = 0.0f;
                float weight = 0.0f;
                for (int k = -radius; k <= endKernel; ++k) {
                    float w = dataKer[k + radius];
                    weight += w;
                    total += dataSrc[indexSrc + k * input.stride] * w;
                }
                dataDst[indexDest++] = total / weight;
            }
        }
    }

    public static void convolve(Kernel2D_F32 kernel, ImageFloat32 input, ImageFloat32 output, int skip) {
        int y;
        float[] dataSrc = input.data;
        float[] dataDst = output.data;
        float[] dataKer = kernel.data;
        int radius = kernel.getRadius();
        int kernelWidth = kernel.getWidth();
        int width = input.width - input.width % skip;
        int height = input.height - input.height % skip;
        int offset = UtilDownConvolve.computeOffset(skip, radius);
        int offsetEndX = UtilDownConvolve.computeMaxSide(input.width, skip, radius) + skip;
        int offsetEndY = UtilDownConvolve.computeMaxSide(input.height, skip, radius) + skip;
        for (y = 0; y < height; y += skip) {
            int x;
            int minI = y >= radius ? -radius : -y;
            int maxI = input.height - y - 1;
            if (maxI > radius) {
                maxI = radius;
            }
            int indexDst = output.startIndex + y / skip * output.stride;
            for (x = 0; x < offset; x += skip) {
                float total = 0.0f;
                float weight = 0.0f;
                for (int i = minI; i <= maxI; ++i) {
                    int indexSrc = input.startIndex + (y + i) * input.stride + x;
                    int indexKer = (i + radius) * kernelWidth;
                    for (int j = -x; j <= radius; ++j) {
                        float w = dataKer[indexKer + j + radius];
                        weight += w;
                        total += dataSrc[indexSrc + j] * w;
                    }
                }
                dataDst[indexDst++] = total / weight;
            }
            indexDst = output.startIndex + y / skip * output.stride + offsetEndX / skip;
            for (x = offsetEndX; x < width; x += skip) {
                int maxJ = input.width - x - 1;
                if (maxJ > radius) {
                    maxJ = radius;
                }
                float total = 0.0f;
                float weight = 0.0f;
                for (int i = minI; i <= maxI; ++i) {
                    int indexSrc = input.startIndex + (y + i) * input.stride + x;
                    int indexKer = (i + radius) * kernelWidth;
                    for (int j = -radius; j <= maxJ; ++j) {
                        float w = dataKer[indexKer + j + radius];
                        weight += w;
                        total += dataSrc[indexSrc + j] * w;
                    }
                }
                dataDst[indexDst++] = total / weight;
            }
        }
        for (y = 0; y < radius; y += skip) {
            int indexDst = output.startIndex + y / skip * output.stride + offset / skip;
            for (int x = offset; x < offsetEndX; x += skip) {
                float total = 0.0f;
                float weight = 0.0f;
                for (int i = -y; i <= radius; ++i) {
                    int indexSrc = input.startIndex + (y + i) * input.stride + x;
                    int indexKer = (i + radius) * kernelWidth;
                    for (int j = -radius; j <= radius; ++j) {
                        float w = dataKer[indexKer + j + radius];
                        weight += w;
                        total += dataSrc[indexSrc + j] * w;
                    }
                }
                dataDst[indexDst++] = total / weight;
            }
        }
        for (y = offsetEndY; y < height; y += skip) {
            int maxI = input.height - y - 1;
            if (maxI > radius) {
                maxI = radius;
            }
            int indexDst = output.startIndex + y / skip * output.stride + offset / skip;
            for (int x = offset; x < offsetEndX; x += skip) {
                float total = 0.0f;
                float weight = 0.0f;
                for (int i = -radius; i <= maxI; ++i) {
                    int indexSrc = input.startIndex + (y + i) * input.stride + x;
                    int indexKer = (i + radius) * kernelWidth;
                    for (int j = -radius; j <= radius; ++j) {
                        float w = dataKer[indexKer + j + radius];
                        weight += w;
                        total += dataSrc[indexSrc + j] * w;
                    }
                }
                dataDst[indexDst++] = total / weight;
            }
        }
    }

    public static void horizontal(Kernel1D_I32 kernel, ImageUInt8 input, ImageInt8 output, int skip) {
        byte[] dataSrc = input.data;
        byte[] dataDst = output.data;
        int[] dataKer = kernel.data;
        int radius = kernel.getRadius();
        int offset = UtilDownConvolve.computeOffset(skip, radius);
        int offsetEnd = UtilDownConvolve.computeMaxSide(input.width, skip, radius) + skip;
        int width = input.width - input.width % skip;
        int height = input.getHeight();
        for (int y = 0; y < height; ++y) {
            int weight;
            int total;
            int indexSrc;
            int x;
            int indexDest = output.startIndex + y * output.stride;
            for (x = 0; x < offset; x += skip) {
                indexSrc = input.startIndex + y * input.stride + x;
                total = 0;
                weight = 0;
                for (int k = -x; k <= radius; ++k) {
                    int w = dataKer[k + radius];
                    weight += w;
                    total += (dataSrc[indexSrc + k] & 0xFF) * w;
                }
                dataDst[indexDest++] = (byte)((total + weight / 2) / weight);
            }
            indexDest = output.startIndex + y * output.stride + offsetEnd / skip;
            for (x = offsetEnd; x < width; x += skip) {
                indexSrc = input.startIndex + y * input.stride + x;
                total = 0;
                weight = 0;
                int endKernel = input.width - x - 1;
                if (endKernel > radius) {
                    endKernel = radius;
                }
                for (int k = -radius; k <= endKernel; ++k) {
                    int w = dataKer[k + radius];
                    weight += w;
                    total += (dataSrc[indexSrc + k] & 0xFF) * w;
                }
                dataDst[indexDest++] = (byte)((total + weight / 2) / weight);
            }
        }
    }

    public static void vertical(Kernel1D_I32 kernel, ImageUInt8 input, ImageInt8 output, int skip) {
        int indexDest;
        int y;
        byte[] dataSrc = input.data;
        byte[] dataDst = output.data;
        int[] dataKer = kernel.data;
        int radius = kernel.getRadius();
        int offset = UtilDownConvolve.computeOffset(skip, radius);
        int offsetEnd = UtilDownConvolve.computeMaxSide(input.height, skip, radius) + skip;
        int width = input.width;
        int height = input.height - input.height % skip;
        for (y = 0; y < offset; y += skip) {
            indexDest = output.startIndex + y / skip * output.stride;
            for (int x = 0; x < width; ++x) {
                int indexSrc = input.startIndex + y * input.stride + x;
                int total = 0;
                int weight = 0;
                for (int k = -y; k <= radius; ++k) {
                    int w = dataKer[k + radius];
                    weight += w;
                    total += (dataSrc[indexSrc + k * input.stride] & 0xFF) * w;
                }
                dataDst[indexDest++] = (byte)((total + weight / 2) / weight);
            }
        }
        for (y = offsetEnd; y < height; y += skip) {
            indexDest = output.startIndex + y / skip * output.stride;
            int endKernel = input.height - y - 1;
            if (endKernel > radius) {
                endKernel = radius;
            }
            for (int x = 0; x < width; ++x) {
                int indexSrc = input.startIndex + y * input.stride + x;
                int total = 0;
                int weight = 0;
                for (int k = -radius; k <= endKernel; ++k) {
                    int w = dataKer[k + radius];
                    weight += w;
                    total += (dataSrc[indexSrc + k * input.stride] & 0xFF) * w;
                }
                dataDst[indexDest++] = (byte)((total + weight / 2) / weight);
            }
        }
    }

    public static void convolve(Kernel2D_I32 kernel, ImageUInt8 input, ImageInt8 output, int skip) {
        int y;
        byte[] dataSrc = input.data;
        byte[] dataDst = output.data;
        int[] dataKer = kernel.data;
        int radius = kernel.getRadius();
        int kernelWidth = kernel.getWidth();
        int width = input.width - input.width % skip;
        int height = input.height - input.height % skip;
        int offset = UtilDownConvolve.computeOffset(skip, radius);
        int offsetEndX = UtilDownConvolve.computeMaxSide(input.width, skip, radius) + skip;
        int offsetEndY = UtilDownConvolve.computeMaxSide(input.height, skip, radius) + skip;
        for (y = 0; y < height; y += skip) {
            int x;
            int minI = y >= radius ? -radius : -y;
            int maxI = input.height - y - 1;
            if (maxI > radius) {
                maxI = radius;
            }
            int indexDst = output.startIndex + y / skip * output.stride;
            for (x = 0; x < offset; x += skip) {
                int total = 0;
                int weight = 0;
                for (int i = minI; i <= maxI; ++i) {
                    int indexSrc = input.startIndex + (y + i) * input.stride + x;
                    int indexKer = (i + radius) * kernelWidth;
                    for (int j = -x; j <= radius; ++j) {
                        int w = dataKer[indexKer + j + radius];
                        weight += w;
                        total += (dataSrc[indexSrc + j] & 0xFF) * w;
                    }
                }
                dataDst[indexDst++] = (byte)((total + weight / 2) / weight);
            }
            indexDst = output.startIndex + y / skip * output.stride + offsetEndX / skip;
            for (x = offsetEndX; x < width; x += skip) {
                int maxJ = input.width - x - 1;
                if (maxJ > radius) {
                    maxJ = radius;
                }
                int total = 0;
                int weight = 0;
                for (int i = minI; i <= maxI; ++i) {
                    int indexSrc = input.startIndex + (y + i) * input.stride + x;
                    int indexKer = (i + radius) * kernelWidth;
                    for (int j = -radius; j <= maxJ; ++j) {
                        int w = dataKer[indexKer + j + radius];
                        weight += w;
                        total += (dataSrc[indexSrc + j] & 0xFF) * w;
                    }
                }
                dataDst[indexDst++] = (byte)((total + weight / 2) / weight);
            }
        }
        for (y = 0; y < radius; y += skip) {
            int indexDst = output.startIndex + y / skip * output.stride + offset / skip;
            for (int x = offset; x < offsetEndX; x += skip) {
                int total = 0;
                int weight = 0;
                for (int i = -y; i <= radius; ++i) {
                    int indexSrc = input.startIndex + (y + i) * input.stride + x;
                    int indexKer = (i + radius) * kernelWidth;
                    for (int j = -radius; j <= radius; ++j) {
                        int w = dataKer[indexKer + j + radius];
                        weight += w;
                        total += (dataSrc[indexSrc + j] & 0xFF) * w;
                    }
                }
                dataDst[indexDst++] = (byte)((total + weight / 2) / weight);
            }
        }
        for (y = offsetEndY; y < height; y += skip) {
            int maxI = input.height - y - 1;
            if (maxI > radius) {
                maxI = radius;
            }
            int indexDst = output.startIndex + y / skip * output.stride + offset / skip;
            for (int x = offset; x < offsetEndX; x += skip) {
                int total = 0;
                int weight = 0;
                for (int i = -radius; i <= maxI; ++i) {
                    int indexSrc = input.startIndex + (y + i) * input.stride + x;
                    int indexKer = (i + radius) * kernelWidth;
                    for (int j = -radius; j <= radius; ++j) {
                        int w = dataKer[indexKer + j + radius];
                        weight += w;
                        total += (dataSrc[indexSrc + j] & 0xFF) * w;
                    }
                }
                dataDst[indexDst++] = (byte)((total + weight / 2) / weight);
            }
        }
    }

    public static void horizontal(Kernel1D_I32 kernel, ImageSInt16 input, ImageInt16 output, int skip) {
        short[] dataSrc = input.data;
        short[] dataDst = output.data;
        int[] dataKer = kernel.data;
        int radius = kernel.getRadius();
        int offset = UtilDownConvolve.computeOffset(skip, radius);
        int offsetEnd = UtilDownConvolve.computeMaxSide(input.width, skip, radius) + skip;
        int width = input.width - input.width % skip;
        int height = input.getHeight();
        for (int y = 0; y < height; ++y) {
            int weight;
            int total;
            int indexSrc;
            int x;
            int indexDest = output.startIndex + y * output.stride;
            for (x = 0; x < offset; x += skip) {
                indexSrc = input.startIndex + y * input.stride + x;
                total = 0;
                weight = 0;
                for (int k = -x; k <= radius; ++k) {
                    int w = dataKer[k + radius];
                    weight += w;
                    total += dataSrc[indexSrc + k] * w;
                }
                dataDst[indexDest++] = (short)((total + weight / 2) / weight);
            }
            indexDest = output.startIndex + y * output.stride + offsetEnd / skip;
            for (x = offsetEnd; x < width; x += skip) {
                indexSrc = input.startIndex + y * input.stride + x;
                total = 0;
                weight = 0;
                int endKernel = input.width - x - 1;
                if (endKernel > radius) {
                    endKernel = radius;
                }
                for (int k = -radius; k <= endKernel; ++k) {
                    int w = dataKer[k + radius];
                    weight += w;
                    total += dataSrc[indexSrc + k] * w;
                }
                dataDst[indexDest++] = (short)((total + weight / 2) / weight);
            }
        }
    }

    public static void vertical(Kernel1D_I32 kernel, ImageSInt16 input, ImageInt16 output, int skip) {
        int indexDest;
        int y;
        short[] dataSrc = input.data;
        short[] dataDst = output.data;
        int[] dataKer = kernel.data;
        int radius = kernel.getRadius();
        int offset = UtilDownConvolve.computeOffset(skip, radius);
        int offsetEnd = UtilDownConvolve.computeMaxSide(input.height, skip, radius) + skip;
        int width = input.width;
        int height = input.height - input.height % skip;
        for (y = 0; y < offset; y += skip) {
            indexDest = output.startIndex + y / skip * output.stride;
            for (int x = 0; x < width; ++x) {
                int indexSrc = input.startIndex + y * input.stride + x;
                int total = 0;
                int weight = 0;
                for (int k = -y; k <= radius; ++k) {
                    int w = dataKer[k + radius];
                    weight += w;
                    total += dataSrc[indexSrc + k * input.stride] * w;
                }
                dataDst[indexDest++] = (short)((total + weight / 2) / weight);
            }
        }
        for (y = offsetEnd; y < height; y += skip) {
            indexDest = output.startIndex + y / skip * output.stride;
            int endKernel = input.height - y - 1;
            if (endKernel > radius) {
                endKernel = radius;
            }
            for (int x = 0; x < width; ++x) {
                int indexSrc = input.startIndex + y * input.stride + x;
                int total = 0;
                int weight = 0;
                for (int k = -radius; k <= endKernel; ++k) {
                    int w = dataKer[k + radius];
                    weight += w;
                    total += dataSrc[indexSrc + k * input.stride] * w;
                }
                dataDst[indexDest++] = (short)((total + weight / 2) / weight);
            }
        }
    }

    public static void convolve(Kernel2D_I32 kernel, ImageSInt16 input, ImageInt16 output, int skip) {
        int y;
        short[] dataSrc = input.data;
        short[] dataDst = output.data;
        int[] dataKer = kernel.data;
        int radius = kernel.getRadius();
        int kernelWidth = kernel.getWidth();
        int width = input.width - input.width % skip;
        int height = input.height - input.height % skip;
        int offset = UtilDownConvolve.computeOffset(skip, radius);
        int offsetEndX = UtilDownConvolve.computeMaxSide(input.width, skip, radius) + skip;
        int offsetEndY = UtilDownConvolve.computeMaxSide(input.height, skip, radius) + skip;
        for (y = 0; y < height; y += skip) {
            int x;
            int minI = y >= radius ? -radius : -y;
            int maxI = input.height - y - 1;
            if (maxI > radius) {
                maxI = radius;
            }
            int indexDst = output.startIndex + y / skip * output.stride;
            for (x = 0; x < offset; x += skip) {
                int total = 0;
                int weight = 0;
                for (int i = minI; i <= maxI; ++i) {
                    int indexSrc = input.startIndex + (y + i) * input.stride + x;
                    int indexKer = (i + radius) * kernelWidth;
                    for (int j = -x; j <= radius; ++j) {
                        int w = dataKer[indexKer + j + radius];
                        weight += w;
                        total += dataSrc[indexSrc + j] * w;
                    }
                }
                dataDst[indexDst++] = (short)((total + weight / 2) / weight);
            }
            indexDst = output.startIndex + y / skip * output.stride + offsetEndX / skip;
            for (x = offsetEndX; x < width; x += skip) {
                int maxJ = input.width - x - 1;
                if (maxJ > radius) {
                    maxJ = radius;
                }
                int total = 0;
                int weight = 0;
                for (int i = minI; i <= maxI; ++i) {
                    int indexSrc = input.startIndex + (y + i) * input.stride + x;
                    int indexKer = (i + radius) * kernelWidth;
                    for (int j = -radius; j <= maxJ; ++j) {
                        int w = dataKer[indexKer + j + radius];
                        weight += w;
                        total += dataSrc[indexSrc + j] * w;
                    }
                }
                dataDst[indexDst++] = (short)((total + weight / 2) / weight);
            }
        }
        for (y = 0; y < radius; y += skip) {
            int indexDst = output.startIndex + y / skip * output.stride + offset / skip;
            for (int x = offset; x < offsetEndX; x += skip) {
                int total = 0;
                int weight = 0;
                for (int i = -y; i <= radius; ++i) {
                    int indexSrc = input.startIndex + (y + i) * input.stride + x;
                    int indexKer = (i + radius) * kernelWidth;
                    for (int j = -radius; j <= radius; ++j) {
                        int w = dataKer[indexKer + j + radius];
                        weight += w;
                        total += dataSrc[indexSrc + j] * w;
                    }
                }
                dataDst[indexDst++] = (short)((total + weight / 2) / weight);
            }
        }
        for (y = offsetEndY; y < height; y += skip) {
            int maxI = input.height - y - 1;
            if (maxI > radius) {
                maxI = radius;
            }
            int indexDst = output.startIndex + y / skip * output.stride + offset / skip;
            for (int x = offset; x < offsetEndX; x += skip) {
                int total = 0;
                int weight = 0;
                for (int i = -radius; i <= maxI; ++i) {
                    int indexSrc = input.startIndex + (y + i) * input.stride + x;
                    int indexKer = (i + radius) * kernelWidth;
                    for (int j = -radius; j <= radius; ++j) {
                        int w = dataKer[indexKer + j + radius];
                        weight += w;
                        total += dataSrc[indexSrc + j] * w;
                    }
                }
                dataDst[indexDst++] = (short)((total + weight / 2) / weight);
            }
        }
    }
}

