/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.derivative.impl;

import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageInteger;

public class GradientSobel_Naive {
    public static void process(ImageInteger orig, ImageInteger derivX, ImageInteger derivY) {
        int width = orig.getWidth();
        int height = orig.getHeight();
        for (int y = 1; y < height - 1; ++y) {
            for (int x = 1; x < width - 1; ++x) {
                int dy = -(orig.get(x - 1, y - 1) + 2 * orig.get(x, y - 1) + orig.get(x + 1, y - 1));
                int dx = -(orig.get(x - 1, y - 1) + 2 * orig.get(x - 1, y) + orig.get(x - 1, y + 1));
                derivX.set(x, y, dx += orig.get(x + 1, y - 1) + 2 * orig.get(x + 1, y) + orig.get(x + 1, y + 1));
                derivY.set(x, y, dy += orig.get(x - 1, y + 1) + 2 * orig.get(x, y + 1) + orig.get(x + 1, y + 1));
            }
        }
    }

    public static void process(ImageFloat32 orig, ImageFloat32 derivX, ImageFloat32 derivY) {
        int width = orig.getWidth();
        int height = orig.getHeight();
        for (int y = 1; y < height - 1; ++y) {
            for (int x = 1; x < width - 1; ++x) {
                float dy = -(orig.get(x - 1, y - 1) * 0.25f + orig.get(x, y - 1) * 0.5f + orig.get(x + 1, y - 1) * 0.25f);
                float dx = -(orig.get(x - 1, y - 1) * 0.25f + orig.get(x - 1, y) * 0.5f + orig.get(x - 1, y + 1) * 0.25f);
                derivX.set(x, y, dx += orig.get(x + 1, y - 1) * 0.25f + orig.get(x + 1, y) * 0.5f + orig.get(x + 1, y + 1) * 0.25f);
                derivY.set(x, y, dy += orig.get(x - 1, y + 1) * 0.25f + orig.get(x, y + 1) * 0.5f + orig.get(x + 1, y + 1) * 0.25f);
            }
        }
    }
}

