/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.interpolate.impl;

import boofcv.alg.interpolate.BilinearPixel;
import boofcv.struct.image.ImageFloat64;
import boofcv.struct.image.ImageType;

public class ImplBilinearPixel_F64
extends BilinearPixel<ImageFloat64> {
    public ImplBilinearPixel_F64() {
    }

    public ImplBilinearPixel_F64(ImageFloat64 orig) {
        this.setImage(orig);
    }

    @Override
    public float get_fast(float x, float y) {
        int xt = (int)x;
        int yt = (int)y;
        double ax = x - (float)xt;
        double ay = y - (float)yt;
        int index = ((ImageFloat64)this.orig).startIndex + yt * this.stride + xt;
        double[] data = ((ImageFloat64)this.orig).data;
        double val = (1.0 - ax) * (1.0 - ay) * data[index];
        val += ax * (1.0 - ay) * data[index + 1];
        val += ax * ay * data[index + 1 + this.stride];
        return (float)(val += (1.0 - ax) * ay * data[index + this.stride]);
    }

    @Override
    public float get(float x, float y) {
        if (x < 0.0f || y < 0.0f || x > (float)(this.width - 1) || y > (float)(this.height - 1)) {
            throw new IllegalArgumentException("Point is outside of the image " + x + " " + y);
        }
        int xt = (int)x;
        int yt = (int)y;
        double ax = x - (float)xt;
        double ay = y - (float)yt;
        int index = ((ImageFloat64)this.orig).startIndex + yt * this.stride + xt;
        int dx = xt == this.width - 1 ? 0 : 1;
        int dy = yt == this.height - 1 ? 0 : this.stride;
        double[] data = ((ImageFloat64)this.orig).data;
        double val = (1.0 - ax) * (1.0 - ay) * data[index];
        val += ax * (1.0 - ay) * data[index + dx];
        val += ax * ay * data[index + dx + dy];
        return (float)(val += (1.0 - ax) * ay * data[index + dy]);
    }

    @Override
    public ImageType<ImageFloat64> getImageType() {
        return ImageType.single(ImageFloat64.class);
    }
}

