/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.misc;

import boofcv.alg.InputSanityCheck;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageFloat64;
import boofcv.struct.image.ImageInt16;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageSInt64;
import boofcv.struct.image.ImageSInt8;
import boofcv.struct.image.ImageUInt16;
import boofcv.struct.image.ImageUInt8;
import boofcv.struct.image.MultiSpectral;

public class PixelMath {
    public static void abs(ImageSInt8 input, ImageSInt8 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                output.data[indexDst] = (byte)Math.abs(input.data[indexSrc]);
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void invert(ImageSInt8 input, ImageSInt8 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                output.data[indexDst] = -input.data[indexSrc];
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void abs(ImageSInt16 input, ImageSInt16 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                output.data[indexDst] = (short)Math.abs(input.data[indexSrc]);
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void invert(ImageSInt16 input, ImageSInt16 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                output.data[indexDst] = -input.data[indexSrc];
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void abs(ImageSInt32 input, ImageSInt32 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                output.data[indexDst] = Math.abs(input.data[indexSrc]);
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void invert(ImageSInt32 input, ImageSInt32 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                output.data[indexDst] = -input.data[indexSrc];
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void abs(ImageSInt64 input, ImageSInt64 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                output.data[indexDst] = Math.abs(input.data[indexSrc]);
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void invert(ImageSInt64 input, ImageSInt64 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                output.data[indexDst] = -input.data[indexSrc];
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void abs(ImageFloat32 input, ImageFloat32 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                output.data[indexDst] = Math.abs(input.data[indexSrc]);
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void invert(ImageFloat32 input, ImageFloat32 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                output.data[indexDst] = -input.data[indexSrc];
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void abs(ImageFloat64 input, ImageFloat64 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                output.data[indexDst] = Math.abs(input.data[indexSrc]);
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void invert(ImageFloat64 input, ImageFloat64 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                output.data[indexDst] = -input.data[indexSrc];
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void multiply(ImageUInt8 input, double value, ImageUInt8 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                output.data[indexDst] = (byte)((double)(input.data[indexSrc] & 0xFF) * value);
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void multiply(ImageUInt8 input, double value, int lower, int upper, ImageUInt8 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                int val = (int)((double)(input.data[indexSrc] & 0xFF) * value);
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output.data[indexDst] = (byte)val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void divide(ImageUInt8 input, double denominator, ImageUInt8 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                output.data[indexDst] = (byte)((double)(input.data[indexSrc] & 0xFF) / denominator);
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void divide(ImageUInt8 input, double denominator, int lower, int upper, ImageUInt8 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                int val = (int)((double)(input.data[indexSrc] & 0xFF) / denominator);
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output.data[indexDst] = (byte)val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void plus(ImageUInt8 input, int value, ImageUInt8 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                output.data[indexDst] = (byte)((input.data[indexSrc] & 0xFF) + value);
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void plus(ImageUInt8 input, int value, int lower, int upper, ImageUInt8 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                int val = (input.data[indexSrc] & 0xFF) + value;
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output.data[indexDst] = (byte)val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void boundImage(ImageUInt8 img, int min, int max) {
        int h = img.getHeight();
        int w = img.getWidth();
        byte[] data = img.data;
        for (int y = 0; y < h; ++y) {
            int index;
            int indexEnd = index + w;
            for (index = img.getStartIndex() + y * img.getStride(); index < indexEnd; ++index) {
                int value = data[index] & 0xFF;
                if (value < min) {
                    data[index] = (byte)min;
                    continue;
                }
                if (value <= max) continue;
                data[index] = (byte)max;
            }
        }
    }

    public static void diffAbs(ImageUInt8 imgA, ImageUInt8 imgB, ImageUInt8 diff) {
        InputSanityCheck.checkSameShape(imgA, imgB, diff);
        int h = imgA.getHeight();
        int w = imgA.getWidth();
        for (int y = 0; y < h; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int indexDiff = diff.getStartIndex() + y * diff.getStride();
            int indexEnd = indexA + w;
            while (indexA < indexEnd) {
                diff.data[indexDiff] = (byte)Math.abs((imgA.data[indexA] & 0xFF) - (imgB.data[indexB] & 0xFF));
                ++indexA;
                ++indexB;
                ++indexDiff;
            }
        }
    }

    public static void averageBand(MultiSpectral<ImageUInt8> input, ImageUInt8 output) {
        int h = input.getHeight();
        int w = input.getWidth();
        ImageUInt8[] bands = (ImageUInt8[])input.bands;
        for (int y = 0; y < h; ++y) {
            int indexInput = input.getStartIndex() + y * input.getStride();
            int indexOutput = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexInput + w;
            while (indexInput < indexEnd) {
                int total = 0;
                for (int i = 0; i < bands.length; ++i) {
                    total += bands[i].data[indexInput] & 0xFF;
                }
                output.data[indexOutput] = (byte)(total / bands.length);
                ++indexInput;
                ++indexOutput;
            }
        }
    }

    public static void multiply(ImageSInt8 input, double value, ImageSInt8 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                output.data[indexDst] = (byte)((double)input.data[indexSrc] * value);
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void multiply(ImageSInt8 input, double value, int lower, int upper, ImageSInt8 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                int val = (int)((double)input.data[indexSrc] * value);
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output.data[indexDst] = (byte)val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void divide(ImageSInt8 input, double denominator, ImageSInt8 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                output.data[indexDst] = (byte)((double)input.data[indexSrc] / denominator);
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void divide(ImageSInt8 input, double denominator, int lower, int upper, ImageSInt8 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                int val = (int)((double)input.data[indexSrc] / denominator);
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output.data[indexDst] = (byte)val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void plus(ImageSInt8 input, int value, ImageSInt8 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                output.data[indexDst] = (byte)(input.data[indexSrc] + value);
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void plus(ImageSInt8 input, int value, int lower, int upper, ImageSInt8 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                int val = input.data[indexSrc] + value;
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output.data[indexDst] = (byte)val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void boundImage(ImageSInt8 img, int min, int max) {
        int h = img.getHeight();
        int w = img.getWidth();
        byte[] data = img.data;
        for (int y = 0; y < h; ++y) {
            int index;
            int indexEnd = index + w;
            for (index = img.getStartIndex() + y * img.getStride(); index < indexEnd; ++index) {
                byte value = data[index];
                if (value < min) {
                    data[index] = (byte)min;
                    continue;
                }
                if (value <= max) continue;
                data[index] = (byte)max;
            }
        }
    }

    public static void diffAbs(ImageSInt8 imgA, ImageSInt8 imgB, ImageSInt8 diff) {
        InputSanityCheck.checkSameShape(imgA, imgB, diff);
        int h = imgA.getHeight();
        int w = imgA.getWidth();
        for (int y = 0; y < h; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int indexDiff = diff.getStartIndex() + y * diff.getStride();
            int indexEnd = indexA + w;
            while (indexA < indexEnd) {
                diff.data[indexDiff] = (byte)Math.abs(imgA.data[indexA] - imgB.data[indexB]);
                ++indexA;
                ++indexB;
                ++indexDiff;
            }
        }
    }

    public static void averageBand(MultiSpectral<ImageSInt8> input, ImageSInt8 output) {
        int h = input.getHeight();
        int w = input.getWidth();
        ImageSInt8[] bands = (ImageSInt8[])input.bands;
        for (int y = 0; y < h; ++y) {
            int indexInput = input.getStartIndex() + y * input.getStride();
            int indexOutput = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexInput + w;
            while (indexInput < indexEnd) {
                int total = 0;
                for (int i = 0; i < bands.length; ++i) {
                    total += bands[i].data[indexInput];
                }
                output.data[indexOutput] = (byte)(total / bands.length);
                ++indexInput;
                ++indexOutput;
            }
        }
    }

    public static void multiply(ImageUInt16 input, double value, ImageUInt16 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                output.data[indexDst] = (short)((double)(input.data[indexSrc] & 0xFFFF) * value);
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void multiply(ImageUInt16 input, double value, int lower, int upper, ImageUInt16 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                int val = (int)((double)(input.data[indexSrc] & 0xFFFF) * value);
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output.data[indexDst] = (short)val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void divide(ImageUInt16 input, double denominator, ImageUInt16 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                output.data[indexDst] = (short)((double)(input.data[indexSrc] & 0xFFFF) / denominator);
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void divide(ImageUInt16 input, double denominator, int lower, int upper, ImageUInt16 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                int val = (int)((double)(input.data[indexSrc] & 0xFFFF) / denominator);
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output.data[indexDst] = (short)val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void plus(ImageUInt16 input, int value, ImageUInt16 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                output.data[indexDst] = (short)((input.data[indexSrc] & 0xFFFF) + value);
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void plus(ImageUInt16 input, int value, int lower, int upper, ImageUInt16 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                int val = (input.data[indexSrc] & 0xFFFF) + value;
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output.data[indexDst] = (short)val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void boundImage(ImageUInt16 img, int min, int max) {
        int h = img.getHeight();
        int w = img.getWidth();
        short[] data = img.data;
        for (int y = 0; y < h; ++y) {
            int index;
            int indexEnd = index + w;
            for (index = img.getStartIndex() + y * img.getStride(); index < indexEnd; ++index) {
                int value = data[index] & 0xFFFF;
                if (value < min) {
                    data[index] = (short)min;
                    continue;
                }
                if (value <= max) continue;
                data[index] = (short)max;
            }
        }
    }

    public static void diffAbs(ImageUInt16 imgA, ImageUInt16 imgB, ImageUInt16 diff) {
        InputSanityCheck.checkSameShape(imgA, imgB, diff);
        int h = imgA.getHeight();
        int w = imgA.getWidth();
        for (int y = 0; y < h; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int indexDiff = diff.getStartIndex() + y * diff.getStride();
            int indexEnd = indexA + w;
            while (indexA < indexEnd) {
                diff.data[indexDiff] = (short)Math.abs((imgA.data[indexA] & 0xFFFF) - (imgB.data[indexB] & 0xFFFF));
                ++indexA;
                ++indexB;
                ++indexDiff;
            }
        }
    }

    public static void averageBand(MultiSpectral<ImageUInt16> input, ImageUInt16 output) {
        int h = input.getHeight();
        int w = input.getWidth();
        ImageUInt16[] bands = (ImageUInt16[])input.bands;
        for (int y = 0; y < h; ++y) {
            int indexInput = input.getStartIndex() + y * input.getStride();
            int indexOutput = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexInput + w;
            while (indexInput < indexEnd) {
                int total = 0;
                for (int i = 0; i < bands.length; ++i) {
                    total += bands[i].data[indexInput] & 0xFFFF;
                }
                output.data[indexOutput] = (short)(total / bands.length);
                ++indexInput;
                ++indexOutput;
            }
        }
    }

    public static void multiply(ImageSInt16 input, double value, ImageSInt16 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                output.data[indexDst] = (short)((double)input.data[indexSrc] * value);
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void multiply(ImageSInt16 input, double value, int lower, int upper, ImageSInt16 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                int val = (int)((double)input.data[indexSrc] * value);
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output.data[indexDst] = (short)val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void divide(ImageSInt16 input, double denominator, ImageSInt16 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                output.data[indexDst] = (short)((double)input.data[indexSrc] / denominator);
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void divide(ImageSInt16 input, double denominator, int lower, int upper, ImageSInt16 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                int val = (int)((double)input.data[indexSrc] / denominator);
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output.data[indexDst] = (short)val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void plus(ImageSInt16 input, int value, ImageSInt16 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                output.data[indexDst] = (short)(input.data[indexSrc] + value);
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void plus(ImageSInt16 input, int value, int lower, int upper, ImageSInt16 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                int val = input.data[indexSrc] + value;
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output.data[indexDst] = (short)val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void boundImage(ImageSInt16 img, int min, int max) {
        int h = img.getHeight();
        int w = img.getWidth();
        short[] data = img.data;
        for (int y = 0; y < h; ++y) {
            int index;
            int indexEnd = index + w;
            for (index = img.getStartIndex() + y * img.getStride(); index < indexEnd; ++index) {
                short value = data[index];
                if (value < min) {
                    data[index] = (short)min;
                    continue;
                }
                if (value <= max) continue;
                data[index] = (short)max;
            }
        }
    }

    public static void diffAbs(ImageSInt16 imgA, ImageSInt16 imgB, ImageSInt16 diff) {
        InputSanityCheck.checkSameShape(imgA, imgB, diff);
        int h = imgA.getHeight();
        int w = imgA.getWidth();
        for (int y = 0; y < h; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int indexDiff = diff.getStartIndex() + y * diff.getStride();
            int indexEnd = indexA + w;
            while (indexA < indexEnd) {
                diff.data[indexDiff] = (short)Math.abs(imgA.data[indexA] - imgB.data[indexB]);
                ++indexA;
                ++indexB;
                ++indexDiff;
            }
        }
    }

    public static void averageBand(MultiSpectral<ImageSInt16> input, ImageSInt16 output) {
        int h = input.getHeight();
        int w = input.getWidth();
        ImageSInt16[] bands = (ImageSInt16[])input.bands;
        for (int y = 0; y < h; ++y) {
            int indexInput = input.getStartIndex() + y * input.getStride();
            int indexOutput = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexInput + w;
            while (indexInput < indexEnd) {
                int total = 0;
                for (int i = 0; i < bands.length; ++i) {
                    total += bands[i].data[indexInput];
                }
                output.data[indexOutput] = (short)(total / bands.length);
                ++indexInput;
                ++indexOutput;
            }
        }
    }

    public static void multiply(ImageSInt32 input, double value, ImageSInt32 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                output.data[indexDst] = (int)((double)input.data[indexSrc] * value);
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void multiply(ImageSInt32 input, double value, int lower, int upper, ImageSInt32 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                int val = (int)((double)input.data[indexSrc] * value);
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output.data[indexDst] = val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void divide(ImageSInt32 input, double denominator, ImageSInt32 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                output.data[indexDst] = (int)((double)input.data[indexSrc] / denominator);
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void divide(ImageSInt32 input, double denominator, int lower, int upper, ImageSInt32 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                int val = (int)((double)input.data[indexSrc] / denominator);
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output.data[indexDst] = val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void plus(ImageSInt32 input, int value, ImageSInt32 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                output.data[indexDst] = input.data[indexSrc] + value;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void plus(ImageSInt32 input, int value, int lower, int upper, ImageSInt32 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                int val = input.data[indexSrc] + value;
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output.data[indexDst] = val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void boundImage(ImageSInt32 img, int min, int max) {
        int h = img.getHeight();
        int w = img.getWidth();
        int[] data = img.data;
        for (int y = 0; y < h; ++y) {
            int index;
            int indexEnd = index + w;
            for (index = img.getStartIndex() + y * img.getStride(); index < indexEnd; ++index) {
                int value = data[index];
                if (value < min) {
                    data[index] = min;
                    continue;
                }
                if (value <= max) continue;
                data[index] = max;
            }
        }
    }

    public static void diffAbs(ImageSInt32 imgA, ImageSInt32 imgB, ImageSInt32 diff) {
        InputSanityCheck.checkSameShape(imgA, imgB, diff);
        int h = imgA.getHeight();
        int w = imgA.getWidth();
        for (int y = 0; y < h; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int indexDiff = diff.getStartIndex() + y * diff.getStride();
            int indexEnd = indexA + w;
            while (indexA < indexEnd) {
                diff.data[indexDiff] = Math.abs(imgA.data[indexA] - imgB.data[indexB]);
                ++indexA;
                ++indexB;
                ++indexDiff;
            }
        }
    }

    public static void averageBand(MultiSpectral<ImageSInt32> input, ImageSInt32 output) {
        int h = input.getHeight();
        int w = input.getWidth();
        ImageSInt32[] bands = (ImageSInt32[])input.bands;
        for (int y = 0; y < h; ++y) {
            int indexInput = input.getStartIndex() + y * input.getStride();
            int indexOutput = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexInput + w;
            while (indexInput < indexEnd) {
                int total = 0;
                for (int i = 0; i < bands.length; ++i) {
                    total += bands[i].data[indexInput];
                }
                output.data[indexOutput] = total / bands.length;
                ++indexInput;
                ++indexOutput;
            }
        }
    }

    public static void multiply(ImageSInt64 input, double value, ImageSInt64 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                output.data[indexDst] = (long)((double)input.data[indexSrc] * value);
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void multiply(ImageSInt64 input, double value, long lower, long upper, ImageSInt64 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                long val = (long)((double)input.data[indexSrc] * value);
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output.data[indexDst] = val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void divide(ImageSInt64 input, double denominator, ImageSInt64 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                output.data[indexDst] = (long)((double)input.data[indexSrc] / denominator);
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void divide(ImageSInt64 input, double denominator, long lower, long upper, ImageSInt64 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                long val = (long)((double)input.data[indexSrc] / denominator);
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output.data[indexDst] = val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void plus(ImageSInt64 input, long value, ImageSInt64 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                output.data[indexDst] = input.data[indexSrc] + value;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void plus(ImageSInt64 input, long value, long lower, long upper, ImageSInt64 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                long val = input.data[indexSrc] + value;
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output.data[indexDst] = val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void boundImage(ImageSInt64 img, long min, long max) {
        int h = img.getHeight();
        int w = img.getWidth();
        long[] data = img.data;
        for (int y = 0; y < h; ++y) {
            int index;
            int indexEnd = index + w;
            for (index = img.getStartIndex() + y * img.getStride(); index < indexEnd; ++index) {
                long value = data[index];
                if (value < min) {
                    data[index] = min;
                    continue;
                }
                if (value <= max) continue;
                data[index] = max;
            }
        }
    }

    public static void diffAbs(ImageSInt64 imgA, ImageSInt64 imgB, ImageSInt64 diff) {
        InputSanityCheck.checkSameShape(imgA, imgB, diff);
        int h = imgA.getHeight();
        int w = imgA.getWidth();
        for (int y = 0; y < h; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int indexDiff = diff.getStartIndex() + y * diff.getStride();
            int indexEnd = indexA + w;
            while (indexA < indexEnd) {
                diff.data[indexDiff] = Math.abs(imgA.data[indexA] - imgB.data[indexB]);
                ++indexA;
                ++indexB;
                ++indexDiff;
            }
        }
    }

    public static void averageBand(MultiSpectral<ImageSInt64> input, ImageSInt64 output) {
        int h = input.getHeight();
        int w = input.getWidth();
        ImageSInt64[] bands = (ImageSInt64[])input.bands;
        for (int y = 0; y < h; ++y) {
            int indexInput = input.getStartIndex() + y * input.getStride();
            int indexOutput = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexInput + w;
            while (indexInput < indexEnd) {
                long total = 0L;
                for (int i = 0; i < bands.length; ++i) {
                    total += bands[i].data[indexInput];
                }
                output.data[indexOutput] = total / (long)bands.length;
                ++indexInput;
                ++indexOutput;
            }
        }
    }

    public static void multiply(ImageFloat32 input, float value, ImageFloat32 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                output.data[indexDst] = input.data[indexSrc] * value;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void multiply(ImageFloat32 input, float value, float lower, float upper, ImageFloat32 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                float val = input.data[indexSrc] * value;
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output.data[indexDst] = val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void divide(ImageFloat32 input, float denominator, ImageFloat32 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                output.data[indexDst] = input.data[indexSrc] / denominator;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void divide(ImageFloat32 input, float denominator, float lower, float upper, ImageFloat32 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                float val = input.data[indexSrc] / denominator;
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output.data[indexDst] = val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void plus(ImageFloat32 input, float value, ImageFloat32 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                output.data[indexDst] = input.data[indexSrc] + value;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void plus(ImageFloat32 input, float value, float lower, float upper, ImageFloat32 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                float val = input.data[indexSrc] + value;
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output.data[indexDst] = val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void boundImage(ImageFloat32 img, float min, float max) {
        int h = img.getHeight();
        int w = img.getWidth();
        float[] data = img.data;
        for (int y = 0; y < h; ++y) {
            int index;
            int indexEnd = index + w;
            for (index = img.getStartIndex() + y * img.getStride(); index < indexEnd; ++index) {
                float value = data[index];
                if (value < min) {
                    data[index] = min;
                    continue;
                }
                if (!(value > max)) continue;
                data[index] = max;
            }
        }
    }

    public static void diffAbs(ImageFloat32 imgA, ImageFloat32 imgB, ImageFloat32 diff) {
        InputSanityCheck.checkSameShape(imgA, imgB, diff);
        int h = imgA.getHeight();
        int w = imgA.getWidth();
        for (int y = 0; y < h; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int indexDiff = diff.getStartIndex() + y * diff.getStride();
            int indexEnd = indexA + w;
            while (indexA < indexEnd) {
                diff.data[indexDiff] = Math.abs(imgA.data[indexA] - imgB.data[indexB]);
                ++indexA;
                ++indexB;
                ++indexDiff;
            }
        }
    }

    public static void averageBand(MultiSpectral<ImageFloat32> input, ImageFloat32 output) {
        int h = input.getHeight();
        int w = input.getWidth();
        ImageFloat32[] bands = (ImageFloat32[])input.bands;
        for (int y = 0; y < h; ++y) {
            int indexInput = input.getStartIndex() + y * input.getStride();
            int indexOutput = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexInput + w;
            while (indexInput < indexEnd) {
                float total = 0.0f;
                for (int i = 0; i < bands.length; ++i) {
                    total += bands[i].data[indexInput];
                }
                output.data[indexOutput] = total / (float)bands.length;
                ++indexInput;
                ++indexOutput;
            }
        }
    }

    public static void multiply(ImageFloat64 input, double value, ImageFloat64 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                output.data[indexDst] = input.data[indexSrc] * value;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void multiply(ImageFloat64 input, double value, double lower, double upper, ImageFloat64 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                double val = input.data[indexSrc] * value;
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output.data[indexDst] = val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void divide(ImageFloat64 input, double denominator, ImageFloat64 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                output.data[indexDst] = input.data[indexSrc] / denominator;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void divide(ImageFloat64 input, double denominator, double lower, double upper, ImageFloat64 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                double val = input.data[indexSrc] / denominator;
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output.data[indexDst] = val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void plus(ImageFloat64 input, double value, ImageFloat64 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                output.data[indexDst] = input.data[indexSrc] + value;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void plus(ImageFloat64 input, double value, double lower, double upper, ImageFloat64 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                double val = input.data[indexSrc] + value;
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output.data[indexDst] = val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void boundImage(ImageFloat64 img, double min, double max) {
        int h = img.getHeight();
        int w = img.getWidth();
        double[] data = img.data;
        for (int y = 0; y < h; ++y) {
            int index;
            int indexEnd = index + w;
            for (index = img.getStartIndex() + y * img.getStride(); index < indexEnd; ++index) {
                double value = data[index];
                if (value < min) {
                    data[index] = min;
                    continue;
                }
                if (!(value > max)) continue;
                data[index] = max;
            }
        }
    }

    public static void diffAbs(ImageFloat64 imgA, ImageFloat64 imgB, ImageFloat64 diff) {
        InputSanityCheck.checkSameShape(imgA, imgB, diff);
        int h = imgA.getHeight();
        int w = imgA.getWidth();
        for (int y = 0; y < h; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int indexDiff = diff.getStartIndex() + y * diff.getStride();
            int indexEnd = indexA + w;
            while (indexA < indexEnd) {
                diff.data[indexDiff] = Math.abs(imgA.data[indexA] - imgB.data[indexB]);
                ++indexA;
                ++indexB;
                ++indexDiff;
            }
        }
    }

    public static void averageBand(MultiSpectral<ImageFloat64> input, ImageFloat64 output) {
        int h = input.getHeight();
        int w = input.getWidth();
        ImageFloat64[] bands = (ImageFloat64[])input.bands;
        for (int y = 0; y < h; ++y) {
            int indexInput = input.getStartIndex() + y * input.getStride();
            int indexOutput = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexInput + w;
            while (indexInput < indexEnd) {
                double total = 0.0;
                for (int i = 0; i < bands.length; ++i) {
                    total += bands[i].data[indexInput];
                }
                output.data[indexOutput] = total / (double)bands.length;
                ++indexInput;
                ++indexOutput;
            }
        }
    }

    public static void add(ImageUInt8 imgA, ImageUInt8 imgB, ImageUInt16 output) {
        InputSanityCheck.checkSameShape(imgA, imgB, output);
        int h = imgA.getHeight();
        int w = imgA.getWidth();
        for (int y = 0; y < h; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int indexOut = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexA + w;
            while (indexA < indexEnd) {
                output.data[indexOut] = (short)((imgA.data[indexA] & 0xFF) + (imgB.data[indexB] & 0xFF));
                ++indexA;
                ++indexB;
                ++indexOut;
            }
        }
    }

    public static void subtract(ImageUInt8 imgA, ImageUInt8 imgB, ImageInt16 output) {
        InputSanityCheck.checkSameShape(imgA, imgB, output);
        int h = imgA.getHeight();
        int w = imgA.getWidth();
        for (int y = 0; y < h; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int indexOut = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexA + w;
            while (indexA < indexEnd) {
                output.data[indexOut] = (short)((imgA.data[indexA] & 0xFF) - (imgB.data[indexB] & 0xFF));
                ++indexA;
                ++indexB;
                ++indexOut;
            }
        }
    }

    public static void add(ImageSInt8 imgA, ImageSInt8 imgB, ImageSInt16 output) {
        InputSanityCheck.checkSameShape(imgA, imgB, output);
        int h = imgA.getHeight();
        int w = imgA.getWidth();
        for (int y = 0; y < h; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int indexOut = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexA + w;
            while (indexA < indexEnd) {
                output.data[indexOut] = (short)(imgA.data[indexA] + imgB.data[indexB]);
                ++indexA;
                ++indexB;
                ++indexOut;
            }
        }
    }

    public static void subtract(ImageSInt8 imgA, ImageSInt8 imgB, ImageSInt16 output) {
        InputSanityCheck.checkSameShape(imgA, imgB, output);
        int h = imgA.getHeight();
        int w = imgA.getWidth();
        for (int y = 0; y < h; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int indexOut = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexA + w;
            while (indexA < indexEnd) {
                output.data[indexOut] = (short)(imgA.data[indexA] - imgB.data[indexB]);
                ++indexA;
                ++indexB;
                ++indexOut;
            }
        }
    }

    public static void add(ImageUInt16 imgA, ImageUInt16 imgB, ImageSInt32 output) {
        InputSanityCheck.checkSameShape(imgA, imgB, output);
        int h = imgA.getHeight();
        int w = imgA.getWidth();
        for (int y = 0; y < h; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int indexOut = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexA + w;
            while (indexA < indexEnd) {
                output.data[indexOut] = (imgA.data[indexA] & 0xFFFF) + (imgB.data[indexB] & 0xFFFF);
                ++indexA;
                ++indexB;
                ++indexOut;
            }
        }
    }

    public static void subtract(ImageUInt16 imgA, ImageUInt16 imgB, ImageSInt32 output) {
        InputSanityCheck.checkSameShape(imgA, imgB, output);
        int h = imgA.getHeight();
        int w = imgA.getWidth();
        for (int y = 0; y < h; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int indexOut = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexA + w;
            while (indexA < indexEnd) {
                output.data[indexOut] = (imgA.data[indexA] & 0xFFFF) - (imgB.data[indexB] & 0xFFFF);
                ++indexA;
                ++indexB;
                ++indexOut;
            }
        }
    }

    public static void add(ImageSInt16 imgA, ImageSInt16 imgB, ImageSInt32 output) {
        InputSanityCheck.checkSameShape(imgA, imgB, output);
        int h = imgA.getHeight();
        int w = imgA.getWidth();
        for (int y = 0; y < h; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int indexOut = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexA + w;
            while (indexA < indexEnd) {
                output.data[indexOut] = imgA.data[indexA] + imgB.data[indexB];
                ++indexA;
                ++indexB;
                ++indexOut;
            }
        }
    }

    public static void subtract(ImageSInt16 imgA, ImageSInt16 imgB, ImageSInt32 output) {
        InputSanityCheck.checkSameShape(imgA, imgB, output);
        int h = imgA.getHeight();
        int w = imgA.getWidth();
        for (int y = 0; y < h; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int indexOut = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexA + w;
            while (indexA < indexEnd) {
                output.data[indexOut] = imgA.data[indexA] - imgB.data[indexB];
                ++indexA;
                ++indexB;
                ++indexOut;
            }
        }
    }

    public static void add(ImageSInt32 imgA, ImageSInt32 imgB, ImageSInt32 output) {
        InputSanityCheck.checkSameShape(imgA, imgB, output);
        int h = imgA.getHeight();
        int w = imgA.getWidth();
        for (int y = 0; y < h; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int indexOut = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexA + w;
            while (indexA < indexEnd) {
                output.data[indexOut] = imgA.data[indexA] + imgB.data[indexB];
                ++indexA;
                ++indexB;
                ++indexOut;
            }
        }
    }

    public static void subtract(ImageSInt32 imgA, ImageSInt32 imgB, ImageSInt32 output) {
        InputSanityCheck.checkSameShape(imgA, imgB, output);
        int h = imgA.getHeight();
        int w = imgA.getWidth();
        for (int y = 0; y < h; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int indexOut = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexA + w;
            while (indexA < indexEnd) {
                output.data[indexOut] = imgA.data[indexA] - imgB.data[indexB];
                ++indexA;
                ++indexB;
                ++indexOut;
            }
        }
    }

    public static void add(ImageSInt64 imgA, ImageSInt64 imgB, ImageSInt64 output) {
        InputSanityCheck.checkSameShape(imgA, imgB, output);
        int h = imgA.getHeight();
        int w = imgA.getWidth();
        for (int y = 0; y < h; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int indexOut = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexA + w;
            while (indexA < indexEnd) {
                output.data[indexOut] = imgA.data[indexA] + imgB.data[indexB];
                ++indexA;
                ++indexB;
                ++indexOut;
            }
        }
    }

    public static void subtract(ImageSInt64 imgA, ImageSInt64 imgB, ImageSInt64 output) {
        InputSanityCheck.checkSameShape(imgA, imgB, output);
        int h = imgA.getHeight();
        int w = imgA.getWidth();
        for (int y = 0; y < h; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int indexOut = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexA + w;
            while (indexA < indexEnd) {
                output.data[indexOut] = imgA.data[indexA] - imgB.data[indexB];
                ++indexA;
                ++indexB;
                ++indexOut;
            }
        }
    }

    public static void add(ImageFloat32 imgA, ImageFloat32 imgB, ImageFloat32 output) {
        InputSanityCheck.checkSameShape(imgA, imgB, output);
        int h = imgA.getHeight();
        int w = imgA.getWidth();
        for (int y = 0; y < h; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int indexOut = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexA + w;
            while (indexA < indexEnd) {
                output.data[indexOut] = imgA.data[indexA] + imgB.data[indexB];
                ++indexA;
                ++indexB;
                ++indexOut;
            }
        }
    }

    public static void subtract(ImageFloat32 imgA, ImageFloat32 imgB, ImageFloat32 output) {
        InputSanityCheck.checkSameShape(imgA, imgB, output);
        int h = imgA.getHeight();
        int w = imgA.getWidth();
        for (int y = 0; y < h; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int indexOut = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexA + w;
            while (indexA < indexEnd) {
                output.data[indexOut] = imgA.data[indexA] - imgB.data[indexB];
                ++indexA;
                ++indexB;
                ++indexOut;
            }
        }
    }

    public static void multiply(ImageFloat32 imgA, ImageFloat32 imgB, ImageFloat32 output) {
        InputSanityCheck.checkSameShape(imgA, imgB, output);
        int h = imgA.getHeight();
        int w = imgA.getWidth();
        for (int y = 0; y < h; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int indexOut = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexA + w;
            while (indexA < indexEnd) {
                output.data[indexOut] = imgA.data[indexA] * imgB.data[indexB];
                ++indexA;
                ++indexB;
                ++indexOut;
            }
        }
    }

    public static void divide(ImageFloat32 imgA, ImageFloat32 imgB, ImageFloat32 output) {
        InputSanityCheck.checkSameShape(imgA, imgB, output);
        int h = imgA.getHeight();
        int w = imgA.getWidth();
        for (int y = 0; y < h; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int indexOut = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexA + w;
            while (indexA < indexEnd) {
                output.data[indexOut] = imgA.data[indexA] / imgB.data[indexB];
                ++indexA;
                ++indexB;
                ++indexOut;
            }
        }
    }

    public static void log(ImageFloat32 input, ImageFloat32 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                output.data[indexDst] = (float)Math.log(1.0f + input.data[indexSrc]);
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void pow2(ImageFloat32 input, ImageFloat32 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                float v = input.data[indexSrc];
                output.data[indexDst] = v * v;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void sqrt(ImageFloat32 input, ImageFloat32 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                output.data[indexDst] = (float)Math.sqrt(input.data[indexSrc]);
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void add(ImageFloat64 imgA, ImageFloat64 imgB, ImageFloat64 output) {
        InputSanityCheck.checkSameShape(imgA, imgB, output);
        int h = imgA.getHeight();
        int w = imgA.getWidth();
        for (int y = 0; y < h; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int indexOut = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexA + w;
            while (indexA < indexEnd) {
                output.data[indexOut] = imgA.data[indexA] + imgB.data[indexB];
                ++indexA;
                ++indexB;
                ++indexOut;
            }
        }
    }

    public static void subtract(ImageFloat64 imgA, ImageFloat64 imgB, ImageFloat64 output) {
        InputSanityCheck.checkSameShape(imgA, imgB, output);
        int h = imgA.getHeight();
        int w = imgA.getWidth();
        for (int y = 0; y < h; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int indexOut = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexA + w;
            while (indexA < indexEnd) {
                output.data[indexOut] = imgA.data[indexA] - imgB.data[indexB];
                ++indexA;
                ++indexB;
                ++indexOut;
            }
        }
    }

    public static void multiply(ImageFloat64 imgA, ImageFloat64 imgB, ImageFloat64 output) {
        InputSanityCheck.checkSameShape(imgA, imgB, output);
        int h = imgA.getHeight();
        int w = imgA.getWidth();
        for (int y = 0; y < h; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int indexOut = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexA + w;
            while (indexA < indexEnd) {
                output.data[indexOut] = imgA.data[indexA] * imgB.data[indexB];
                ++indexA;
                ++indexB;
                ++indexOut;
            }
        }
    }

    public static void divide(ImageFloat64 imgA, ImageFloat64 imgB, ImageFloat64 output) {
        InputSanityCheck.checkSameShape(imgA, imgB, output);
        int h = imgA.getHeight();
        int w = imgA.getWidth();
        for (int y = 0; y < h; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int indexOut = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexA + w;
            while (indexA < indexEnd) {
                output.data[indexOut] = imgA.data[indexA] / imgB.data[indexB];
                ++indexA;
                ++indexB;
                ++indexOut;
            }
        }
    }

    public static void log(ImageFloat64 input, ImageFloat64 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                output.data[indexDst] = Math.log(1.0 + input.data[indexSrc]);
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void pow2(ImageFloat64 input, ImageFloat64 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                double v = input.data[indexSrc];
                output.data[indexDst] = v * v;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void sqrt(ImageFloat64 input, ImageFloat64 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                output.data[indexDst] = Math.sqrt(input.data[indexSrc]);
                ++indexSrc;
                ++indexDst;
            }
        }
    }
}

