/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.image;

import boofcv.struct.image.ImageAccessException;
import boofcv.struct.image.ImageDataType;
import boofcv.struct.image.ImageSingleBand;

public class ImageSInt64
extends ImageSingleBand<ImageSInt64> {
    public long[] data;

    public ImageSInt64(int width, int height) {
        super(width, height);
    }

    public ImageSInt64() {
    }

    public long get(int x, int y) {
        if (!this.isInBounds(x, y)) {
            throw new ImageAccessException("Requested pixel is out of bounds");
        }
        return this.unsafe_get(x, y);
    }

    public long unsafe_get(int x, int y) {
        return this.data[this.getIndex(x, y)];
    }

    public void set(int x, int y, long value) {
        if (!this.isInBounds(x, y)) {
            throw new ImageAccessException("Requested pixel is out of bounds");
        }
        this.unsafe_set(x, y, value);
    }

    public void unsafe_set(int x, int y, long value) {
        this.data[this.getIndex((int)x, (int)y)] = value;
    }

    @Override
    public ImageDataType getDataType() {
        return ImageDataType.S64;
    }

    @Override
    protected Object _getData() {
        return this.data;
    }

    @Override
    protected void _setData(Object data) {
        this.data = (long[])data;
    }

    @Override
    public ImageSInt64 _createNew(int imgWidth, int imgHeight) {
        if (imgWidth == -1 || imgHeight == -1) {
            return new ImageSInt64();
        }
        return new ImageSInt64(imgWidth, imgHeight);
    }

    public long[] getData() {
        return this.data;
    }

    public void setData(long[] data) {
        this.data = data;
    }
}

