/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort;

import boofcv.alg.distort.ImageDistortBasic;
import boofcv.alg.interpolate.InterpolatePixelMB;
import boofcv.struct.image.ImageInterleaved;

public abstract class ImageDistortBasic_IL<Input extends ImageInterleaved, Output extends ImageInterleaved>
extends ImageDistortBasic<Input, Output, InterpolatePixelMB<Input>> {
    float[] values = new float[0];

    public ImageDistortBasic_IL(InterpolatePixelMB<Input> interp) {
        super(interp);
    }

    @Override
    protected void init(Input srcImg, Output dstImg) {
        super.init(srcImg, dstImg);
        if (this.values.length != ((ImageInterleaved)srcImg).getNumBands()) {
            this.values = new float[((ImageInterleaved)srcImg).getNumBands()];
        }
    }

    @Override
    public void applyAll() {
        for (int y = this.y0; y < this.y1; ++y) {
            int indexDst = ((ImageInterleaved)this.dstImg).startIndex + ((ImageInterleaved)this.dstImg).stride * y + this.x0 * ((ImageInterleaved)this.dstImg).numBands;
            int x = this.x0;
            while (x < this.x1) {
                this.dstToSrc.compute(x, y);
                ((InterpolatePixelMB)this.interp).get(this.dstToSrc.distX, this.dstToSrc.distY, this.values);
                this.assign(indexDst, this.values);
                ++x;
                indexDst += ((ImageInterleaved)this.dstImg).numBands;
            }
        }
    }

    @Override
    public void applyOnlyInside() {
        float maxWidth = ((ImageInterleaved)this.srcImg).getWidth() - 1;
        float maxHeight = ((ImageInterleaved)this.srcImg).getHeight() - 1;
        for (int y = this.y0; y < this.y1; ++y) {
            int indexDst = ((ImageInterleaved)this.dstImg).startIndex + ((ImageInterleaved)this.dstImg).stride * y + this.x0 * ((ImageInterleaved)this.dstImg).numBands;
            int x = this.x0;
            while (x < this.x1) {
                this.dstToSrc.compute(x, y);
                if (this.dstToSrc.distX >= 0.0f && this.dstToSrc.distX <= maxWidth && this.dstToSrc.distY >= 0.0f && this.dstToSrc.distY <= maxHeight) {
                    ((InterpolatePixelMB)this.interp).get(this.dstToSrc.distX, this.dstToSrc.distY, this.values);
                    this.assign(indexDst, this.values);
                }
                ++x;
                indexDst += ((ImageInterleaved)this.dstImg).numBands;
            }
        }
    }

    protected abstract void assign(int var1, float[] var2);
}

