/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.blur;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.filter.blur.GBlurImageOps;
import boofcv.alg.filter.blur.impl.ImplMedianHistogramInner;
import boofcv.alg.filter.blur.impl.ImplMedianSortEdgeNaive;
import boofcv.alg.filter.blur.impl.ImplMedianSortNaive;
import boofcv.alg.filter.convolve.ConvolveImageMean;
import boofcv.alg.filter.convolve.ConvolveNormalized;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.factory.filter.kernel.FactoryKernelGaussian;
import boofcv.struct.convolve.Kernel1D_F32;
import boofcv.struct.convolve.Kernel1D_F64;
import boofcv.struct.convolve.Kernel1D_I32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.Planar;

public class BlurImageOps {
    public static GrayU8 mean(GrayU8 input, GrayU8 output, int radius, GrayU8 storage) {
        if (radius <= 0) {
            throw new IllegalArgumentException("Radius must be > 0");
        }
        output = InputSanityCheck.checkDeclare(input, output);
        storage = InputSanityCheck.checkDeclare(input, storage);
        ConvolveImageMean.horizontal(input, storage, radius);
        ConvolveImageMean.vertical(storage, output, radius);
        return output;
    }

    public static GrayU8 median(GrayU8 input, GrayU8 output, int radius) {
        if (radius <= 0) {
            throw new IllegalArgumentException("Radius must be > 0");
        }
        output = InputSanityCheck.checkDeclare(input, output);
        int w = radius * 2 + 1;
        int[] offset = new int[w * w];
        int[] histogram = new int[256];
        ImplMedianHistogramInner.process(input, output, radius, offset, histogram);
        ImplMedianSortEdgeNaive.process(input, output, radius, offset);
        return output;
    }

    public static GrayU8 gaussian(GrayU8 input, GrayU8 output, double sigma, int radius, GrayU8 storage) {
        output = InputSanityCheck.checkDeclare(input, output);
        storage = InputSanityCheck.checkDeclare(input, storage, GrayU8.class);
        Kernel1D_I32 kernel = FactoryKernelGaussian.gaussian(Kernel1D_I32.class, sigma, radius);
        ConvolveNormalized.horizontal(kernel, input, storage);
        ConvolveNormalized.vertical(kernel, storage, output);
        return output;
    }

    public static GrayF32 mean(GrayF32 input, GrayF32 output, int radius, GrayF32 storage) {
        if (radius <= 0) {
            throw new IllegalArgumentException("Radius must be > 0");
        }
        output = InputSanityCheck.checkDeclare(input, output);
        storage = InputSanityCheck.checkDeclare(input, storage);
        ConvolveImageMean.horizontal(input, storage, radius);
        ConvolveImageMean.vertical(storage, output, radius);
        return output;
    }

    public static GrayF64 mean(GrayF64 input, GrayF64 output, int radius, GrayF64 storage) {
        if (radius <= 0) {
            throw new IllegalArgumentException("Radius must be > 0");
        }
        output = InputSanityCheck.checkDeclare(input, output);
        storage = InputSanityCheck.checkDeclare(input, storage);
        ConvolveImageMean.horizontal(input, storage, radius);
        ConvolveImageMean.vertical(storage, output, radius);
        return output;
    }

    public static GrayF32 median(GrayF32 input, GrayF32 output, int radius) {
        if (radius <= 0) {
            throw new IllegalArgumentException("Radius must be > 0");
        }
        output = InputSanityCheck.checkDeclare(input, output);
        ImplMedianSortNaive.process(input, output, radius, null);
        return output;
    }

    public static GrayF32 gaussian(GrayF32 input, GrayF32 output, double sigma, int radius, GrayF32 storage) {
        output = InputSanityCheck.checkDeclare(input, output);
        storage = InputSanityCheck.checkDeclare(input, storage);
        Kernel1D_F32 kernel = FactoryKernelGaussian.gaussian(Kernel1D_F32.class, sigma, radius);
        ConvolveNormalized.horizontal(kernel, input, storage);
        ConvolveNormalized.vertical(kernel, storage, output);
        return output;
    }

    public static GrayF64 gaussian(GrayF64 input, GrayF64 output, double sigma, int radius, GrayF64 storage) {
        output = InputSanityCheck.checkDeclare(input, output);
        storage = InputSanityCheck.checkDeclare(input, storage);
        Kernel1D_F64 kernel = FactoryKernelGaussian.gaussian(Kernel1D_F64.class, sigma, radius);
        ConvolveNormalized.horizontal(kernel, input, storage);
        ConvolveNormalized.vertical(kernel, storage, output);
        return output;
    }

    public static <T extends ImageGray> Planar<T> mean(Planar<T> input, Planar<T> output, int radius, T storage) {
        if (storage == null) {
            storage = GeneralizedImageOps.createSingleBand(input.getBandType(), input.width, input.height);
        }
        if (output == null) {
            output = input._createNew(input.width, input.height);
        }
        for (int band = 0; band < input.getNumBands(); ++band) {
            GBlurImageOps.median(input.getBand(band), ((Planar)output).getBand(band), radius);
        }
        return output;
    }

    public static <T extends ImageGray> Planar<T> median(Planar<T> input, Planar<T> output, int radius) {
        if (output == null) {
            output = input._createNew(input.width, input.height);
        }
        for (int band = 0; band < input.getNumBands(); ++band) {
            GBlurImageOps.median(input.getBand(band), ((Planar)output).getBand(band), radius);
        }
        return output;
    }

    public static <T extends ImageGray> Planar<T> gaussian(Planar<T> input, Planar<T> output, double sigma, int radius, T storage) {
        if (storage == null) {
            storage = GeneralizedImageOps.createSingleBand(input.getBandType(), input.width, input.height);
        }
        if (output == null) {
            output = input._createNew(input.width, input.height);
        }
        for (int band = 0; band < input.getNumBands(); ++band) {
            GBlurImageOps.gaussian(input.getBand(band), ((Planar)output).getBand(band), sigma, radius, storage);
        }
        return output;
    }
}

