/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.transform.pyramid;

import boofcv.alg.filter.misc.AverageDownSampleOps;
import boofcv.struct.image.ImageGray;
import boofcv.struct.pyramid.PyramidDiscrete;

public class PyramidDiscreteAverage<T extends ImageGray>
extends PyramidDiscrete<T> {
    public PyramidDiscreteAverage(Class<T> imageType, boolean saveOriginalReference, int ... scaleFactors) {
        super(imageType, saveOriginalReference, scaleFactors);
    }

    @Override
    public void process(T input) {
        super.initialize(((ImageGray)input).width, ((ImageGray)input).height);
        if (this.scale[0] == 1) {
            if (this.isSaveOriginalReference()) {
                this.setFirstLayer(input);
            } else {
                ((ImageGray)this.getLayer(0)).setTo(input);
            }
        } else {
            AverageDownSampleOps.down(input, this.scale[0], (ImageGray)this.getLayer(0));
        }
        for (int index = 1; index < this.getNumLayers(); ++index) {
            int width = this.scale[index] / this.scale[index - 1];
            AverageDownSampleOps.down((ImageGray)this.getLayer(index - 1), width, (ImageGray)this.getLayer(index));
        }
    }

    @Override
    public double getSampleOffset(int layer) {
        return (double)(this.scale[layer] - 1) / 2.0;
    }

    @Override
    public double getSigma(int layer) {
        return 0.0;
    }
}

