/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.transform.wavelet.impl;

import boofcv.alg.transform.wavelet.UtilWavelet;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS32;
import boofcv.struct.wavelet.WlCoef_F32;
import boofcv.struct.wavelet.WlCoef_I32;

public class ImplWaveletTransformInner {
    public static void horizontal(WlCoef_F32 coefficients, GrayF32 input, GrayF32 output) {
        int offsetA = coefficients.offsetScaling;
        int offsetB = coefficients.offsetWavelet;
        float[] alpha = coefficients.scaling;
        float[] beta = coefficients.wavelet;
        float[] dataIn = input.data;
        float[] dataOut = output.data;
        int width = output.width;
        int height = input.height;
        int widthD2 = width / 2;
        int startX = UtilWavelet.borderForwardLower(coefficients);
        int endOffsetX = input.width - UtilWavelet.borderForwardUpper(coefficients, input.width) - startX;
        for (int y = 0; y < height; ++y) {
            int indexIn;
            int indexOut = output.startIndex + output.stride * y + startX / 2;
            int end = indexIn + endOffsetX;
            for (indexIn = input.startIndex + input.stride * y + startX; indexIn < end; indexIn += 2) {
                float scale = 0.0f;
                int index = indexIn + offsetA;
                for (int i = 0; i < alpha.length; ++i) {
                    scale += dataIn[index++] * alpha[i];
                }
                float wavelet = 0.0f;
                index = indexIn + offsetB;
                for (int i = 0; i < beta.length; ++i) {
                    wavelet += dataIn[index++] * beta[i];
                }
                dataOut[indexOut + widthD2] = wavelet;
                dataOut[indexOut++] = scale;
            }
        }
    }

    public static void vertical(WlCoef_F32 coefficients, GrayF32 input, GrayF32 output) {
        int offsetA = coefficients.offsetScaling * input.stride;
        int offsetB = coefficients.offsetWavelet * input.stride;
        float[] alpha = coefficients.scaling;
        float[] beta = coefficients.wavelet;
        float[] dataIn = input.data;
        float[] dataOut = output.data;
        int width = input.width;
        int height = output.height;
        int heightD2 = height / 2 * output.stride;
        int startY = UtilWavelet.borderForwardLower(coefficients);
        int endY = input.height - UtilWavelet.borderForwardUpper(coefficients, input.width);
        for (int y = startY; y < endY; y += 2) {
            int indexIn = input.startIndex + input.stride * y;
            int indexOut = output.startIndex + output.stride * (y / 2);
            int x = 0;
            while (x < width) {
                float scale = 0.0f;
                int index = indexIn + offsetA;
                for (int i = 0; i < alpha.length; ++i) {
                    scale += dataIn[index] * alpha[i];
                    index += input.stride;
                }
                float wavelet = 0.0f;
                index = indexIn + offsetB;
                for (int i = 0; i < beta.length; ++i) {
                    wavelet += dataIn[index] * beta[i];
                    index += input.stride;
                }
                dataOut[indexOut + heightD2] = wavelet;
                dataOut[indexOut++] = scale;
                ++x;
                ++indexIn;
            }
        }
    }

    public static void horizontalInverse(WlCoef_F32 coefficients, GrayF32 input, GrayF32 output) {
        int offsetA = coefficients.offsetScaling;
        int offsetB = coefficients.offsetWavelet;
        float[] alpha = coefficients.scaling;
        float[] beta = coefficients.wavelet;
        float[] trends = new float[output.width];
        float[] details = new float[output.width];
        int width = input.width;
        int height = output.height;
        int widthD2 = width / 2;
        int lowerBorder = UtilWavelet.borderForwardLower(coefficients);
        int upperBorder = output.width - UtilWavelet.borderForwardUpper(coefficients, output.width);
        for (int y = 0; y < height; ++y) {
            int i;
            int i2;
            float d;
            float a;
            int indexSrc = input.startIndex + y * input.stride + lowerBorder / 2;
            int x = lowerBorder;
            while (x < upperBorder) {
                a = input.data[indexSrc];
                d = input.data[indexSrc + widthD2];
                for (i2 = 0; i2 < 2; ++i2) {
                    trends[i2 + x + offsetA] = a * alpha[i2];
                }
                for (i2 = 0; i2 < 2; ++i2) {
                    details[i2 + x + offsetB] = d * beta[i2];
                }
                x += 2;
                ++indexSrc;
            }
            for (i = upperBorder + offsetA; i < upperBorder; ++i) {
                trends[i] = 0.0f;
            }
            for (i = upperBorder + offsetB; i < upperBorder; ++i) {
                details[i] = 0.0f;
            }
            indexSrc = input.startIndex + y * input.stride + lowerBorder / 2;
            x = lowerBorder;
            while (x < upperBorder) {
                a = input.data[indexSrc];
                d = input.data[indexSrc + widthD2];
                for (i2 = 2; i2 < alpha.length; ++i2) {
                    int n = i2 + x + offsetA;
                    trends[n] = trends[n] + a * alpha[i2];
                }
                for (i2 = 2; i2 < beta.length; ++i2) {
                    int n = i2 + x + offsetB;
                    details[n] = details[n] + d * beta[i2];
                }
                x += 2;
                ++indexSrc;
            }
            int indexDst = output.startIndex + y * output.stride + lowerBorder;
            for (int x2 = lowerBorder; x2 < upperBorder; ++x2) {
                output.data[indexDst++] = trends[x2] + details[x2];
            }
        }
    }

    public static void verticalInverse(WlCoef_F32 coefficients, GrayF32 input, GrayF32 output) {
        int offsetA = coefficients.offsetScaling;
        int offsetB = coefficients.offsetWavelet;
        float[] alpha = coefficients.scaling;
        float[] beta = coefficients.wavelet;
        float[] trends = new float[output.height];
        float[] details = new float[output.height];
        int width = output.width;
        int height = input.height;
        int heightD2 = height / 2 * input.stride;
        int lowerBorder = UtilWavelet.borderForwardLower(coefficients);
        int upperBorder = output.height - UtilWavelet.borderForwardUpper(coefficients, output.height);
        for (int x = 0; x < width; ++x) {
            int i;
            int i2;
            float d;
            float a;
            int indexSrc = input.startIndex + lowerBorder / 2 * input.stride + x;
            int y = lowerBorder;
            while (y < upperBorder) {
                a = input.data[indexSrc];
                d = input.data[indexSrc + heightD2];
                for (i2 = 0; i2 < 2; ++i2) {
                    trends[i2 + y + offsetA] = a * alpha[i2];
                }
                for (i2 = 0; i2 < 2; ++i2) {
                    details[i2 + y + offsetB] = d * beta[i2];
                }
                y += 2;
                indexSrc += input.stride;
            }
            for (i = upperBorder + offsetA; i < upperBorder; ++i) {
                trends[i] = 0.0f;
            }
            for (i = upperBorder + offsetB; i < upperBorder; ++i) {
                details[i] = 0.0f;
            }
            indexSrc = input.startIndex + lowerBorder / 2 * input.stride + x;
            y = lowerBorder;
            while (y < upperBorder) {
                a = input.data[indexSrc];
                d = input.data[indexSrc + heightD2];
                for (i2 = 2; i2 < alpha.length; ++i2) {
                    int n = y + offsetA + i2;
                    trends[n] = trends[n] + a * alpha[i2];
                }
                for (i2 = 2; i2 < beta.length; ++i2) {
                    int n = y + offsetB + i2;
                    details[n] = details[n] + d * beta[i2];
                }
                y += 2;
                indexSrc += input.stride;
            }
            int indexDst = output.startIndex + x + lowerBorder * output.stride;
            int y2 = lowerBorder;
            while (y2 < upperBorder) {
                output.data[indexDst] = trends[y2] + details[y2];
                ++y2;
                indexDst += output.stride;
            }
        }
    }

    public static void horizontal(WlCoef_I32 coefficients, GrayS32 input, GrayS32 output) {
        int offsetA = coefficients.offsetScaling;
        int offsetB = coefficients.offsetWavelet;
        int[] alpha = coefficients.scaling;
        int[] beta = coefficients.wavelet;
        int[] dataIn = input.data;
        int[] dataOut = output.data;
        int width = output.width;
        int height = input.height;
        int widthD2 = width / 2;
        int startX = UtilWavelet.borderForwardLower(coefficients);
        int endOffsetX = input.width - UtilWavelet.borderForwardUpper(coefficients, input.width) - startX;
        for (int y = 0; y < height; ++y) {
            int indexIn;
            int indexOut = output.startIndex + output.stride * y + startX / 2;
            int end = indexIn + endOffsetX;
            for (indexIn = input.startIndex + input.stride * y + startX; indexIn < end; indexIn += 2) {
                int scale = 0;
                int index = indexIn + offsetA;
                for (int i = 0; i < alpha.length; ++i) {
                    scale += dataIn[index++] * alpha[i];
                }
                int wavelet = 0;
                index = indexIn + offsetB;
                for (int i = 0; i < beta.length; ++i) {
                    wavelet += dataIn[index++] * beta[i];
                }
                scale = 2 * scale / coefficients.denominatorScaling;
                dataOut[indexOut + widthD2] = wavelet = 2 * wavelet / coefficients.denominatorWavelet;
                dataOut[indexOut++] = scale;
            }
        }
    }

    public static void vertical(WlCoef_I32 coefficients, GrayS32 input, GrayS32 output) {
        int offsetA = coefficients.offsetScaling * input.stride;
        int offsetB = coefficients.offsetWavelet * input.stride;
        int[] alpha = coefficients.scaling;
        int[] beta = coefficients.wavelet;
        int[] dataIn = input.data;
        int[] dataOut = output.data;
        int width = input.width;
        int height = output.height;
        int heightD2 = height / 2 * output.stride;
        int startY = UtilWavelet.borderForwardLower(coefficients);
        int endY = input.height - UtilWavelet.borderForwardUpper(coefficients, input.width);
        for (int y = startY; y < endY; y += 2) {
            int indexIn = input.startIndex + input.stride * y;
            int indexOut = output.startIndex + output.stride * (y / 2);
            int x = 0;
            while (x < width) {
                int scale = 0;
                int index = indexIn + offsetA;
                for (int i = 0; i < alpha.length; ++i) {
                    scale += dataIn[index] * alpha[i];
                    index += input.stride;
                }
                int wavelet = 0;
                index = indexIn + offsetB;
                for (int i = 0; i < beta.length; ++i) {
                    wavelet += dataIn[index] * beta[i];
                    index += input.stride;
                }
                scale = 2 * scale / coefficients.denominatorScaling;
                dataOut[indexOut + heightD2] = wavelet = 2 * wavelet / coefficients.denominatorWavelet;
                dataOut[indexOut++] = scale;
                ++x;
                ++indexIn;
            }
        }
    }

    public static void horizontalInverse(WlCoef_I32 coefficients, GrayS32 input, GrayS32 output) {
        int offsetA = coefficients.offsetScaling;
        int offsetB = coefficients.offsetWavelet;
        int[] alpha = coefficients.scaling;
        int[] beta = coefficients.wavelet;
        int[] trends = new int[output.width];
        int[] details = new int[output.width];
        int width = input.width;
        int height = output.height;
        int widthD2 = width / 2;
        int lowerBorder = UtilWavelet.borderForwardLower(coefficients);
        int upperBorder = output.width - UtilWavelet.borderForwardUpper(coefficients, output.width);
        int e = coefficients.denominatorScaling * 2;
        int f = coefficients.denominatorWavelet * 2;
        int ef = e * f;
        int ef2 = ef / 2;
        for (int y = 0; y < height; ++y) {
            int i;
            int i2;
            int d;
            int a;
            int indexSrc = input.startIndex + y * input.stride + lowerBorder / 2;
            int x = lowerBorder;
            while (x < upperBorder) {
                a = input.data[indexSrc];
                d = input.data[indexSrc + widthD2];
                for (i2 = 0; i2 < 2; ++i2) {
                    trends[i2 + x + offsetA] = a * alpha[i2];
                }
                for (i2 = 0; i2 < 2; ++i2) {
                    details[i2 + x + offsetB] = d * beta[i2];
                }
                x += 2;
                ++indexSrc;
            }
            for (i = upperBorder + offsetA; i < upperBorder; ++i) {
                trends[i] = 0;
            }
            for (i = upperBorder + offsetB; i < upperBorder; ++i) {
                details[i] = 0;
            }
            indexSrc = input.startIndex + y * input.stride + lowerBorder / 2;
            x = lowerBorder;
            while (x < upperBorder) {
                a = input.data[indexSrc];
                d = input.data[indexSrc + widthD2];
                for (i2 = 2; i2 < alpha.length; ++i2) {
                    int n = i2 + x + offsetA;
                    trends[n] = trends[n] + a * alpha[i2];
                }
                for (i2 = 2; i2 < beta.length; ++i2) {
                    int n = i2 + x + offsetB;
                    details[n] = details[n] + d * beta[i2];
                }
                x += 2;
                ++indexSrc;
            }
            int indexDst = output.startIndex + y * output.stride + lowerBorder;
            for (int x2 = lowerBorder; x2 < upperBorder; ++x2) {
                output.data[indexDst++] = UtilWavelet.round(trends[x2] * f + details[x2] * e, ef2, ef);
            }
        }
    }

    public static void verticalInverse(WlCoef_I32 coefficients, GrayS32 input, GrayS32 output) {
        int offsetA = coefficients.offsetScaling;
        int offsetB = coefficients.offsetWavelet;
        int[] alpha = coefficients.scaling;
        int[] beta = coefficients.wavelet;
        int[] trends = new int[output.height];
        int[] details = new int[output.height];
        int width = output.width;
        int height = input.height;
        int heightD2 = height / 2 * input.stride;
        int lowerBorder = UtilWavelet.borderForwardLower(coefficients);
        int upperBorder = output.height - UtilWavelet.borderForwardUpper(coefficients, output.height);
        int e = coefficients.denominatorScaling * 2;
        int f = coefficients.denominatorWavelet * 2;
        int ef = e * f;
        int ef2 = ef / 2;
        for (int x = 0; x < width; ++x) {
            int i;
            int i2;
            int d;
            int a;
            int indexSrc = input.startIndex + lowerBorder / 2 * input.stride + x;
            int y = lowerBorder;
            while (y < upperBorder) {
                a = input.data[indexSrc];
                d = input.data[indexSrc + heightD2];
                for (i2 = 0; i2 < 2; ++i2) {
                    trends[i2 + y + offsetA] = a * alpha[i2];
                }
                for (i2 = 0; i2 < 2; ++i2) {
                    details[i2 + y + offsetB] = d * beta[i2];
                }
                y += 2;
                indexSrc += input.stride;
            }
            for (i = upperBorder + offsetA; i < upperBorder; ++i) {
                trends[i] = 0;
            }
            for (i = upperBorder + offsetB; i < upperBorder; ++i) {
                details[i] = 0;
            }
            indexSrc = input.startIndex + lowerBorder / 2 * input.stride + x;
            y = lowerBorder;
            while (y < upperBorder) {
                a = input.data[indexSrc];
                d = input.data[indexSrc + heightD2];
                for (i2 = 2; i2 < alpha.length; ++i2) {
                    int n = y + offsetA + i2;
                    trends[n] = trends[n] + a * alpha[i2];
                }
                for (i2 = 2; i2 < beta.length; ++i2) {
                    int n = y + offsetB + i2;
                    details[n] = details[n] + d * beta[i2];
                }
                y += 2;
                indexSrc += input.stride;
            }
            int indexDst = output.startIndex + x + lowerBorder * output.stride;
            int y2 = lowerBorder;
            while (y2 < upperBorder) {
                output.data[indexDst] = UtilWavelet.round(trends[y2] * f + details[y2] * e, ef2, ef);
                ++y2;
                indexDst += output.stride;
            }
        }
    }
}

