/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.filter.derivative;

import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.abst.filter.derivative.ImageGradient_Gaussian;
import boofcv.abst.filter.derivative.ImageGradient_PL;
import boofcv.abst.filter.derivative.ImageGradient_Reflection;
import boofcv.abst.filter.derivative.ImageHessian;
import boofcv.abst.filter.derivative.ImageHessianDirect;
import boofcv.abst.filter.derivative.ImageHessianDirect_Reflection;
import boofcv.abst.filter.derivative.ImageHessian_Reflection;
import boofcv.alg.filter.derivative.DerivativeType;
import boofcv.alg.filter.derivative.GImageDerivativeOps;
import boofcv.alg.filter.derivative.GradientPrewitt;
import boofcv.alg.filter.derivative.GradientSobel;
import boofcv.alg.filter.derivative.GradientThree;
import boofcv.alg.filter.derivative.GradientTwo0;
import boofcv.alg.filter.derivative.GradientTwo1;
import boofcv.alg.filter.derivative.HessianFromGradient;
import boofcv.alg.filter.derivative.HessianSobel;
import boofcv.alg.filter.derivative.HessianThree;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.core.image.border.ImageBorder_F32;
import boofcv.core.image.border.ImageBorder_S32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.Planar;
import java.lang.reflect.Method;

public class FactoryDerivative {
    public static <I extends ImageGray, D extends ImageGray> ImageGradient<I, D> gradientSB(DerivativeType type, Class<I> inputType, Class<D> derivType) {
        Class which;
        if (derivType == null) {
            derivType = GImageDerivativeOps.getDerivativeType(inputType);
        }
        switch (type) {
            case PREWITT: {
                which = GradientPrewitt.class;
                break;
            }
            case SOBEL: {
                which = GradientSobel.class;
                break;
            }
            case THREE: {
                which = GradientThree.class;
                break;
            }
            case TWO_0: {
                which = GradientTwo0.class;
                break;
            }
            case TWO_1: {
                which = GradientTwo1.class;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type " + (Object)((Object)type));
            }
        }
        Method m = FactoryDerivative.findDerivative(which, inputType, derivType);
        return new ImageGradient_Reflection(m);
    }

    public static <I extends ImageGray, D extends ImageGray> ImageGradient<Planar<I>, Planar<D>> gradientPL(DerivativeType type, int numBands, Class<I> inputType, Class<D> derivType) {
        ImageGradient<I, D> g = FactoryDerivative.gradientSB(type, inputType, derivType);
        return new ImageGradient_PL<I, D>(g, numBands);
    }

    public static <I extends ImageBase, D extends ImageBase> ImageGradient<I, D> gradient(DerivativeType type, ImageType<I> inputType, ImageType<D> derivType) {
        if (derivType != null && inputType.getFamily() != derivType.getFamily()) {
            throw new IllegalArgumentException("input and output must be of the same family");
        }
        switch (inputType.getFamily()) {
            case GRAY: {
                Class derivClass = derivType != null ? derivType.getImageClass() : null;
                return FactoryDerivative.gradientSB(type, inputType.getImageClass(), derivClass);
            }
            case PLANAR: {
                int numBands = inputType.getNumBands();
                Class derivClass = derivType != null ? derivType.getImageClass() : null;
                return FactoryDerivative.gradientPL(type, numBands, inputType.getImageClass(), derivClass);
            }
            case INTERLEAVED: {
                throw new IllegalArgumentException("INTERLEAVED images not yet supported");
            }
        }
        throw new IllegalArgumentException("Unknown image type");
    }

    public static <I extends ImageGray, D extends ImageGray> ImageGradient<I, D> prewitt(Class<I> inputType, Class<D> derivType) {
        if (derivType == null) {
            derivType = GImageDerivativeOps.getDerivativeType(inputType);
        }
        Method m = FactoryDerivative.findDerivative(GradientPrewitt.class, inputType, derivType);
        return new ImageGradient_Reflection(m);
    }

    public static <I extends ImageGray, D extends ImageGray> ImageGradient<I, D> sobel(Class<I> inputType, Class<D> derivType) {
        if (derivType == null) {
            derivType = GImageDerivativeOps.getDerivativeType(inputType);
        }
        Method m = FactoryDerivative.findDerivative(GradientSobel.class, inputType, derivType);
        return new ImageGradient_Reflection(m);
    }

    public static <I extends ImageGray, D extends ImageGray> ImageGradient<I, D> three(Class<I> inputType, Class<D> derivType) {
        if (derivType == null) {
            derivType = GImageDerivativeOps.getDerivativeType(inputType);
        }
        Method m = FactoryDerivative.findDerivative(GradientThree.class, inputType, derivType);
        return new ImageGradient_Reflection(m);
    }

    public static <I extends ImageGray, D extends ImageGray> ImageGradient<I, D> two0(Class<I> inputType, Class<D> derivType) {
        if (derivType == null) {
            derivType = GImageDerivativeOps.getDerivativeType(inputType);
        }
        Method m = FactoryDerivative.findDerivative(GradientTwo0.class, inputType, derivType);
        return new ImageGradient_Reflection(m);
    }

    public static <I extends ImageGray, D extends ImageGray> ImageGradient<I, D> two1(Class<I> inputType, Class<D> derivType) {
        if (derivType == null) {
            derivType = GImageDerivativeOps.getDerivativeType(inputType);
        }
        Method m = FactoryDerivative.findDerivative(GradientTwo1.class, inputType, derivType);
        return new ImageGradient_Reflection(m);
    }

    public static <I extends ImageGray, D extends ImageGray> ImageHessianDirect<I, D> hessianDirectThree(Class<I> inputType, Class<D> derivType) {
        if (derivType == null) {
            derivType = GImageDerivativeOps.getDerivativeType(inputType);
        }
        Method m = FactoryDerivative.findHessian(HessianThree.class, inputType, derivType);
        return new ImageHessianDirect_Reflection(m);
    }

    public static <I extends ImageGray, D extends ImageGray> ImageHessianDirect<I, D> hessianDirectSobel(Class<I> inputType, Class<D> derivType) {
        if (derivType == null) {
            derivType = GImageDerivativeOps.getDerivativeType(inputType);
        }
        Method m = FactoryDerivative.findHessian(HessianSobel.class, inputType, derivType);
        return new ImageHessianDirect_Reflection(m);
    }

    public static <D extends ImageGray> ImageHessian<D> hessian(Class<?> gradientType, Class<D> derivType) {
        Method m = FactoryDerivative.findHessianFromGradient(gradientType, derivType);
        return new ImageHessian_Reflection(m);
    }

    public static <I extends ImageGray, D extends ImageGray> ImageGradient<I, D> gaussian(double sigma, int radius, Class<I> inputType, Class<D> derivType) {
        if (derivType == null) {
            derivType = GImageDerivativeOps.getDerivativeType(inputType);
        }
        return new ImageGradient_Gaussian<I, D>(sigma, radius, inputType, derivType);
    }

    public static <D extends ImageGray> ImageHessian<D> hessianSobel(Class<D> derivType) {
        if (derivType == GrayF32.class) {
            return FactoryDerivative.hessian(GradientSobel.class, GrayF32.class);
        }
        if (derivType == GrayS16.class) {
            return FactoryDerivative.hessian(GradientSobel.class, GrayS16.class);
        }
        throw new IllegalArgumentException("Not supported yet");
    }

    public static <D extends ImageGray> ImageHessian<D> hessianPrewitt(Class<D> derivType) {
        if (derivType == GrayF32.class) {
            return FactoryDerivative.hessian(GradientPrewitt.class, GrayF32.class);
        }
        if (derivType == GrayS16.class) {
            return FactoryDerivative.hessian(GradientPrewitt.class, GrayS16.class);
        }
        throw new IllegalArgumentException("Not supported yet");
    }

    public static <D extends ImageGray> ImageHessian<D> hessianThree(Class<D> derivType) {
        if (derivType == GrayF32.class) {
            return FactoryDerivative.hessian(GradientThree.class, GrayF32.class);
        }
        if (derivType == GrayS16.class) {
            return FactoryDerivative.hessian(GradientThree.class, GrayS16.class);
        }
        throw new IllegalArgumentException("Not supported yet");
    }

    private static Method findDerivative(Class<?> derivativeClass, Class<?> inputType, Class<?> derivType) {
        Method m;
        try {
            Class borderType = GeneralizedImageOps.isFloatingPoint(inputType) ? ImageBorder_F32.class : ImageBorder_S32.class;
            m = derivativeClass.getDeclaredMethod("process", inputType, derivType, derivType, borderType);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Input and derivative types are probably not compatible", e);
        }
        return m;
    }

    private static Method findHessian(Class<?> derivativeClass, Class<?> inputType, Class<?> derivType) {
        Method m;
        try {
            Class borderType = GeneralizedImageOps.isFloatingPoint(inputType) ? ImageBorder_F32.class : ImageBorder_S32.class;
            m = derivativeClass.getDeclaredMethod("process", inputType, derivType, derivType, derivType, borderType);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Input and derivative types are probably not compatible", e);
        }
        return m;
    }

    private static Method findHessianFromGradient(Class<?> derivativeClass, Class<?> imageType) {
        Method m;
        String name = derivativeClass.getSimpleName().substring(8);
        try {
            Class borderType = GeneralizedImageOps.isFloatingPoint(imageType) ? ImageBorder_F32.class : ImageBorder_S32.class;
            m = HessianFromGradient.class.getDeclaredMethod("hessian" + name, imageType, imageType, imageType, imageType, imageType, borderType);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Input and derivative types are probably not compatible", e);
        }
        return m;
    }
}

