/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.convolve;

import boofcv.struct.convolve.Kernel2D;

public class Kernel2D_F64
extends Kernel2D {
    public double[] data;

    public Kernel2D_F64(int width, double[] data) {
        super(width);
        this.data = new double[width * width];
        System.arraycopy(data, 0, this.data, 0, this.data.length);
    }

    public Kernel2D_F64(int width) {
        super(width);
        this.data = new double[width * width];
    }

    public Kernel2D_F64(int width, int offset) {
        super(width, offset);
        this.data = new double[width * width];
    }

    protected Kernel2D_F64() {
    }

    public static Kernel2D_F64 wrap(double[] data, int width, int offset) {
        if (width % 2 == 0 && width <= 0 && width * width > data.length) {
            throw new IllegalArgumentException("invalid width");
        }
        Kernel2D_F64 ret = new Kernel2D_F64();
        ret.data = data;
        ret.width = width;
        ret.offset = offset;
        return ret;
    }

    public double get(int x, int y) {
        return this.data[y * this.width + x];
    }

    public void set(int x, int y, double value) {
        this.data[y * this.width + x] = value;
    }

    @Override
    public boolean isInteger() {
        return false;
    }

    public double[] getData() {
        return this.data;
    }

    public double computeSum() {
        int N = this.width * this.width;
        double total = 0.0;
        for (int i = 0; i < N; ++i) {
            total += this.data[i];
        }
        return total;
    }

    public void print() {
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.width; ++j) {
                System.out.printf("%15f ", this.data[i * this.width + j]);
            }
            System.out.println();
        }
        System.out.println();
    }

    public Kernel2D_F64 copy() {
        Kernel2D_F64 ret = new Kernel2D_F64(this.width);
        ret.offset = this.offset;
        System.arraycopy(this.data, 0, ret.data, 0, this.data.length);
        return ret;
    }

    @Override
    public double getDouble(int x, int y) {
        return this.get(x, y);
    }
}

