/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.image;

import boofcv.struct.image.ImageAccessException;
import boofcv.struct.image.ImageDataType;
import boofcv.struct.image.InterleavedInteger;

public class InterleavedS32
extends InterleavedInteger<InterleavedS32> {
    public int[] data;

    public InterleavedS32(int width, int height, int numBands) {
        super(width, height, numBands);
    }

    public InterleavedS32() {
    }

    @Override
    public ImageDataType getDataType() {
        return ImageDataType.S32;
    }

    @Override
    public void get_unsafe(int x, int y, int[] storage) {
        int index = this.getIndex(x, y, 0);
        int i = 0;
        while (i < this.numBands) {
            storage[i] = this.data[index];
            ++i;
            ++index;
        }
    }

    @Override
    public void set_unsafe(int x, int y, int ... value) {
        int index = this.getIndex(x, y, 0);
        int i = 0;
        while (i < this.numBands) {
            this.data[index] = value[i];
            ++i;
            ++index;
        }
    }

    @Override
    public int getBand(int x, int y, int band) {
        if (!this.isInBounds(x, y)) {
            throw new ImageAccessException("Requested pixel is out of bounds.");
        }
        if (band < 0 || band >= this.numBands) {
            throw new ImageAccessException("Invalid band requested.");
        }
        return this.data[this.getIndex(x, y, band)];
    }

    @Override
    public void setBand(int x, int y, int band, int value) {
        if (!this.isInBounds(x, y)) {
            throw new ImageAccessException("Requested pixel is out of bounds.");
        }
        if (band < 0 || band >= this.numBands) {
            throw new ImageAccessException("Invalid band requested.");
        }
        this.data[this.getIndex((int)x, (int)y, (int)band)] = value;
    }

    @Override
    protected Object _getData() {
        return this.data;
    }

    @Override
    protected Class getPrimitiveDataType() {
        return Integer.TYPE;
    }

    @Override
    protected void _setData(Object data) {
        this.data = (int[])data;
    }

    @Override
    public InterleavedS32 _createNew(int imgWidth, int imgHeight) {
        if (imgWidth == -1 || imgHeight == -1) {
            return new InterleavedS32();
        }
        return new InterleavedS32(imgWidth, imgHeight, this.numBands);
    }
}

