/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.image;

import boofcv.struct.image.ImageAccessException;
import boofcv.struct.image.ImageDataType;
import boofcv.struct.image.InterleavedI8;

public class InterleavedU8
extends InterleavedI8<InterleavedU8> {
    public InterleavedU8(int width, int height, int numBands) {
        super(width, height, numBands);
    }

    public InterleavedU8() {
    }

    @Override
    public ImageDataType getDataType() {
        return ImageDataType.U8;
    }

    @Override
    public int getBand(int x, int y, int band) {
        if (!this.isInBounds(x, y)) {
            throw new ImageAccessException("Requested pixel is out of bounds.");
        }
        if (band < 0 || band >= this.numBands) {
            throw new ImageAccessException("Invalid band requested.");
        }
        return this.data[this.getIndex(x, y, band)] & 0xFF;
    }

    @Override
    public void get_unsafe(int x, int y, int[] storage) {
        int index = this.getIndex(x, y, 0);
        int i = 0;
        while (i < this.numBands) {
            storage[i] = this.data[index] & 0xFF;
            ++i;
            ++index;
        }
    }

    @Override
    public InterleavedU8 _createNew(int imgWidth, int imgHeight) {
        if (imgWidth == -1 || imgHeight == -1) {
            return new InterleavedU8();
        }
        return new InterleavedU8(imgWidth, imgHeight, this.numBands);
    }
}

