/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.denoise;

import boofcv.abst.filter.FilterImageInterface;
import boofcv.abst.transform.wavelet.WaveletTransform;
import boofcv.alg.denoise.DenoiseWavelet;
import boofcv.alg.transform.wavelet.UtilWavelet;
import boofcv.struct.image.ImageDimension;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;

public class WaveletDenoiseFilter<T extends ImageGray>
implements FilterImageInterface<T, T> {
    private WaveletTransform<T, ImageGray, ?> wavelet;
    private DenoiseWavelet alg;
    private ImageGray transform;

    public WaveletDenoiseFilter(WaveletTransform<T, ?, ?> wavelet, DenoiseWavelet denoiser) {
        this.wavelet = wavelet;
        this.alg = denoiser;
    }

    @Override
    public void process(T original, T denoised) {
        if (this.transform != null) {
            ImageDimension d = UtilWavelet.transformDimension(original, this.wavelet.getLevels());
            this.transform.reshape(d.width, d.height);
        }
        this.transform = this.wavelet.transform((ImageGray)original, this.transform);
        this.alg.denoise(this.transform, this.wavelet.getLevels());
        this.wavelet.invert(this.transform, (ImageGray)denoised);
    }

    @Override
    public int getHorizontalBorder() {
        return 0;
    }

    @Override
    public int getVerticalBorder() {
        return 0;
    }

    @Override
    public ImageType<T> getInputType() {
        return ImageType.single(this.wavelet.getOriginalType());
    }

    @Override
    public ImageType<T> getOutputType() {
        return ImageType.single(this.wavelet.getOriginalType());
    }
}

