/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.transform.wavelet.impl;

import boofcv.abst.transform.wavelet.WaveletTransform;
import boofcv.alg.transform.wavelet.UtilWavelet;
import boofcv.alg.transform.wavelet.WaveletTransformOps;
import boofcv.core.image.border.BorderType;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageDimension;
import boofcv.struct.wavelet.WaveletDescription;
import boofcv.struct.wavelet.WlCoef_F32;

public class WaveletTransformFloat32
implements WaveletTransform<GrayF32, GrayF32, WlCoef_F32> {
    GrayF32 copy = new GrayF32(1, 1);
    GrayF32 temp = new GrayF32(1, 1);
    WaveletDescription<WlCoef_F32> desc;
    int numLevels;
    float minPixelValue;
    float maxPixelValue;

    public WaveletTransformFloat32(WaveletDescription<WlCoef_F32> desc, int numLevels, float minPixelValue, float maxPixelValue) {
        this.desc = desc;
        this.numLevels = numLevels;
        this.minPixelValue = minPixelValue;
        this.maxPixelValue = maxPixelValue;
    }

    @Override
    public GrayF32 transform(GrayF32 original, GrayF32 transformed) {
        if (transformed == null) {
            ImageDimension d = UtilWavelet.transformDimension(original, this.numLevels);
            transformed = new GrayF32(d.width, d.height);
        }
        this.temp.reshape(transformed.width, transformed.height);
        this.copy.reshape(original.width, original.height);
        this.copy.setTo(original);
        WaveletTransformOps.transformN(this.desc, this.copy, transformed, this.temp, this.numLevels);
        return transformed;
    }

    @Override
    public void invert(GrayF32 transformed, GrayF32 original) {
        this.temp.reshape(transformed.width, transformed.height);
        this.copy.reshape(transformed.width, transformed.height);
        this.copy.setTo(transformed);
        WaveletTransformOps.inverseN(this.desc, this.copy, original, this.temp, this.numLevels, this.minPixelValue, this.maxPixelValue);
    }

    @Override
    public int getLevels() {
        return this.numLevels;
    }

    @Override
    public BorderType getBorderType() {
        return UtilWavelet.convertToType(this.desc.getBorder());
    }

    @Override
    public WaveletDescription<WlCoef_F32> getDescription() {
        return this.desc;
    }

    @Override
    public Class<GrayF32> getOriginalType() {
        return GrayF32.class;
    }
}

