/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.denoise.wavelet;

import boofcv.alg.denoise.ShrinkThresholdRule;
import boofcv.alg.denoise.wavelet.SubbandShrink;
import boofcv.alg.denoise.wavelet.UtilDenoiseWavelet;
import boofcv.alg.misc.ImageStatistics;
import boofcv.struct.image.GrayF32;

public class DenoiseBayesShrink_F32
extends SubbandShrink<GrayF32> {
    float noiseVariance;

    public DenoiseBayesShrink_F32(ShrinkThresholdRule<GrayF32> rule) {
        super(rule);
    }

    @Override
    protected Number computeThreshold(GrayF32 subband) {
        float max = ImageStatistics.maxAbs(subband);
        float varianceY = 0.0f;
        for (int y = 0; y < subband.height; ++y) {
            int index;
            int end = index + subband.width;
            for (index = subband.startIndex + subband.stride * y; index < end; ++index) {
                float v = subband.data[index] / max;
                varianceY += v * v;
            }
        }
        float inner = (varianceY = varianceY / (float)(subband.width * subband.height) * max * max) - this.noiseVariance;
        if (inner < 0.0f) {
            return Float.valueOf(Float.POSITIVE_INFINITY);
        }
        return Float.valueOf(this.noiseVariance / (float)Math.sqrt(inner));
    }

    @Override
    public void denoise(GrayF32 transform, int numLevels) {
        int w = transform.width;
        int h = transform.height;
        this.noiseVariance = UtilDenoiseWavelet.estimateNoiseStdDev(transform.subimage(w / 2, h / 2, w, h, null), null);
        this.noiseVariance *= this.noiseVariance;
        this.performShrinkage(transform, numLevels);
    }
}

