/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.denoise.wavelet;

import boofcv.alg.denoise.DenoiseWavelet;
import boofcv.alg.denoise.ShrinkThresholdRule;
import boofcv.alg.denoise.wavelet.ShrinkThresholdSoft_F32;
import boofcv.alg.denoise.wavelet.UtilDenoiseWavelet;
import boofcv.alg.transform.wavelet.UtilWavelet;
import boofcv.struct.image.GrayF32;

public class DenoiseVisuShrink_F32
implements DenoiseWavelet<GrayF32> {
    ShrinkThresholdRule<GrayF32> rule = new ShrinkThresholdSoft_F32();

    @Override
    public void denoise(GrayF32 transform, int numLevels) {
        int scale = UtilWavelet.computeScale(numLevels);
        int h = transform.height;
        int w = transform.width;
        int innerWidth = w / scale;
        int innerHeight = h / scale;
        GrayF32 subbandHH = transform.subimage(w / 2, h / 2, w, h, null);
        float sigma = UtilDenoiseWavelet.estimateNoiseStdDev(subbandHH, null);
        float threshold = (float)UtilDenoiseWavelet.universalThreshold(subbandHH, sigma);
        this.rule.process(transform.subimage(innerWidth, 0, w, h, null), Float.valueOf(threshold));
        this.rule.process(transform.subimage(0, innerHeight, innerWidth, h, null), Float.valueOf(threshold));
    }
}

