/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.enhance.impl;

import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayS8;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;

public class ImplEnhanceHistogram {
    public static void applyTransform(GrayU8 input, int[] transform, GrayU8 output) {
        for (int i = 0; i < input.height; ++i) {
            int indexInput = input.startIndex + i * input.stride;
            int indexOutput = output.startIndex + i * output.stride;
            for (int j = 0; j < input.width; ++j) {
                output.data[indexOutput++] = (byte)transform[input.data[indexInput++] & 0xFF];
            }
        }
    }

    public static void applyTransform(GrayU16 input, int[] transform, GrayU16 output) {
        for (int i = 0; i < input.height; ++i) {
            int indexInput = input.startIndex + i * input.stride;
            int indexOutput = output.startIndex + i * output.stride;
            for (int j = 0; j < input.width; ++j) {
                output.data[indexOutput++] = (short)transform[input.data[indexInput++] & 0xFFFF];
            }
        }
    }

    public static void applyTransform(GrayS8 input, int[] transform, int minValue, GrayS8 output) {
        for (int i = 0; i < input.height; ++i) {
            int indexInput = input.startIndex + i * input.stride;
            int indexOutput = output.startIndex + i * output.stride;
            for (int j = 0; j < input.width; ++j) {
                output.data[indexOutput++] = (byte)transform[input.data[indexInput++] - minValue];
            }
        }
    }

    public static void applyTransform(GrayS16 input, int[] transform, int minValue, GrayS16 output) {
        for (int i = 0; i < input.height; ++i) {
            int indexInput = input.startIndex + i * input.stride;
            int indexOutput = output.startIndex + i * output.stride;
            for (int j = 0; j < input.width; ++j) {
                output.data[indexOutput++] = (short)transform[input.data[indexInput++] - minValue];
            }
        }
    }

    public static void applyTransform(GrayS32 input, int[] transform, int minValue, GrayS32 output) {
        for (int i = 0; i < input.height; ++i) {
            int indexInput = input.startIndex + i * input.stride;
            int indexOutput = output.startIndex + i * output.stride;
            for (int j = 0; j < input.width; ++j) {
                output.data[indexOutput++] = transform[input.data[indexInput++] - minValue];
            }
        }
    }

    public static void equalizeLocalNaive(GrayU8 input, int radius, GrayU8 output, int[] histogram) {
        int width = 2 * radius + 1;
        int maxValue = histogram.length - 1;
        for (int y = 0; y < input.height; ++y) {
            int y0 = y - radius;
            int y1 = y + radius + 1;
            if (y0 < 0) {
                y0 = 0;
                y1 = width;
                if (y1 > input.height) {
                    y1 = input.height;
                }
            } else if (y1 > input.height && (y0 = (y1 = input.height) - width) < 0) {
                y0 = 0;
            }
            int indexIn = input.startIndex + y * input.stride;
            int indexOut = output.startIndex + y * output.stride;
            for (int x = 0; x < input.width; ++x) {
                int x0 = x - radius;
                int x1 = x + radius + 1;
                if (x0 < 0) {
                    x0 = 0;
                    x1 = width;
                    if (x1 > input.width) {
                        x1 = input.width;
                    }
                } else if (x1 > input.width && (x0 = (x1 = input.width) - width) < 0) {
                    x0 = 0;
                }
                ImplEnhanceHistogram.localHistogram(input, x0, y0, x1, y1, histogram);
                int inputValue = input.data[indexIn++] & 0xFF;
                int sum = 0;
                for (int i = 0; i <= inputValue; ++i) {
                    sum += histogram[i];
                }
                int area = (y1 - y0) * (x1 - x0);
                output.data[indexOut++] = (byte)(sum * maxValue / area);
            }
        }
    }

    public static void equalizeLocalInner(GrayU8 input, int radius, GrayU8 output, int[] histogram) {
        int width = 2 * radius + 1;
        int area = width * width;
        int maxValue = histogram.length - 1;
        for (int y = radius; y < input.height - radius; ++y) {
            ImplEnhanceHistogram.localHistogram(input, 0, y - radius, width, y + radius + 1, histogram);
            int inputValue = input.unsafe_get(radius, y);
            int sum = 0;
            for (int i = 0; i <= inputValue; ++i) {
                sum += histogram[i];
            }
            output.set(radius, y, sum * maxValue / area);
            int indexOld = input.startIndex + y * input.stride;
            int indexNew = indexOld + width;
            int indexIn = input.startIndex + y * input.stride + radius + 1;
            int indexOut = output.startIndex + y * output.stride + radius + 1;
            for (int x = radius + 1; x < input.width - radius; ++x) {
                int i;
                for (i = -radius; i <= radius; ++i) {
                    int n = input.data[indexOld + i * input.stride] & 0xFF;
                    histogram[n] = histogram[n] - 1;
                }
                for (i = -radius; i <= radius; ++i) {
                    int n = input.data[indexNew + i * input.stride] & 0xFF;
                    histogram[n] = histogram[n] + 1;
                }
                inputValue = input.data[indexIn++] & 0xFF;
                sum = 0;
                for (i = 0; i <= inputValue; ++i) {
                    sum += histogram[i];
                }
                output.data[indexOut++] = (byte)(sum * maxValue / area);
                ++indexOld;
                ++indexNew;
            }
        }
    }

    public static void equalizeLocalRow(GrayU8 input, int radius, int startY, GrayU8 output, int[] histogram, int[] transform) {
        int inputValue;
        int indexOut;
        int indexIn;
        int y;
        int i;
        int width = 2 * radius + 1;
        int area = width * width;
        int maxValue = histogram.length - 1;
        int hist0 = startY;
        int hist1 = startY + width;
        if (hist1 > input.height) {
            hist1 = input.height;
            hist0 = hist1 - width;
        }
        int region0 = startY;
        int region1 = startY + radius;
        ImplEnhanceHistogram.localHistogram(input, 0, hist0, width, hist1, histogram);
        int sum = 0;
        for (i = 0; i < histogram.length; ++i) {
            transform[i] = sum += histogram[i];
        }
        for (y = region0; y < region1; ++y) {
            indexIn = input.startIndex + y * input.stride;
            indexOut = output.startIndex + y * output.stride;
            for (int x = 0; x <= radius; ++x) {
                inputValue = input.data[indexIn++] & 0xFF;
                output.data[indexOut++] = (byte)(transform[inputValue] * maxValue / area);
            }
        }
        for (int x = radius + 1; x < input.width - radius - 1; ++x) {
            int y2;
            indexIn = input.startIndex + x - radius - 1;
            for (y2 = hist0; y2 < hist1; ++y2) {
                int n = input.data[indexIn + y2 * input.stride] & 0xFF;
                histogram[n] = histogram[n] - 1;
            }
            indexIn += width;
            for (y2 = hist0; y2 < hist1; ++y2) {
                int n = input.data[indexIn + y2 * input.stride] & 0xFF;
                histogram[n] = histogram[n] + 1;
            }
            sum = 0;
            for (int i2 = 0; i2 < histogram.length; ++i2) {
                transform[i2] = sum += histogram[i2];
            }
            indexIn = input.startIndex + region0 * input.stride + x;
            indexOut = output.startIndex + region0 * output.stride + x;
            for (int y3 = 0; y3 < radius; ++y3) {
                inputValue = input.data[indexIn] & 0xFF;
                output.data[indexOut] = (byte)(transform[inputValue] * maxValue / area);
                indexIn += input.stride;
                indexOut += output.stride;
            }
        }
        ImplEnhanceHistogram.localHistogram(input, input.width - width, hist0, input.width, hist1, histogram);
        sum = 0;
        for (i = 0; i < histogram.length; ++i) {
            transform[i] = sum += histogram[i];
        }
        for (y = region0; y < region1; ++y) {
            int x;
            int indexIn2 = input.startIndex + y * input.stride + x;
            int indexOut2 = output.startIndex + y * output.stride + x;
            for (x = input.width - radius - 1; x < input.width; ++x) {
                inputValue = input.data[indexIn2++] & 0xFF;
                output.data[indexOut2++] = (byte)(transform[inputValue] * maxValue / area);
            }
        }
    }

    public static void equalizeLocalCol(GrayU8 input, int radius, int startX, GrayU8 output, int[] histogram, int[] transform) {
        int width = 2 * radius + 1;
        int area = width * width;
        int maxValue = histogram.length - 1;
        int hist0 = startX;
        int hist1 = startX + width;
        if (hist1 > input.width) {
            hist1 = input.width;
            hist0 = hist1 - width;
        }
        ImplEnhanceHistogram.localHistogram(input, hist0, 0, hist1, width, histogram);
        int sum = 0;
        for (int i = 0; i < histogram.length; ++i) {
            transform[i] = sum += histogram[i];
        }
        int indexIn = input.startIndex + radius * input.stride + startX;
        int indexOut = output.startIndex + radius * output.stride + startX;
        for (int x = 0; x < radius; ++x) {
            int inputValue = input.data[indexIn++] & 0xFF;
            output.data[indexOut++] = (byte)(transform[inputValue] * maxValue / area);
        }
        for (int y = radius + 1; y < input.height - radius; ++y) {
            int x;
            indexIn = input.startIndex + (y - radius - 1) * input.stride;
            for (x = hist0; x < hist1; ++x) {
                int n = input.data[indexIn + x] & 0xFF;
                histogram[n] = histogram[n] - 1;
            }
            indexIn += width * input.stride;
            for (x = hist0; x < hist1; ++x) {
                int n = input.data[indexIn + x] & 0xFF;
                histogram[n] = histogram[n] + 1;
            }
            sum = 0;
            for (int i = 0; i < histogram.length; ++i) {
                transform[i] = sum += histogram[i];
            }
            indexIn = input.startIndex + y * input.stride + startX;
            indexOut = output.startIndex + y * output.stride + startX;
            for (x = 0; x < radius; ++x) {
                int inputValue = input.data[indexIn++] & 0xFF;
                output.data[indexOut++] = (byte)(transform[inputValue] * maxValue / area);
            }
        }
    }

    public static void localHistogram(GrayU8 input, int x0, int y0, int x1, int y1, int[] histogram) {
        int i;
        for (i = 0; i < histogram.length; ++i) {
            histogram[i] = 0;
        }
        for (i = y0; i < y1; ++i) {
            int index;
            int end = index + x1 - x0;
            for (index = input.startIndex + i * input.stride + x0; index < end; ++index) {
                int n = input.data[index] & 0xFF;
                histogram[n] = histogram[n] + 1;
            }
        }
    }

    public static void equalizeLocalNaive(GrayU16 input, int radius, GrayU16 output, int[] histogram) {
        int width = 2 * radius + 1;
        int maxValue = histogram.length - 1;
        for (int y = 0; y < input.height; ++y) {
            int y0 = y - radius;
            int y1 = y + radius + 1;
            if (y0 < 0) {
                y0 = 0;
                y1 = width;
                if (y1 > input.height) {
                    y1 = input.height;
                }
            } else if (y1 > input.height && (y0 = (y1 = input.height) - width) < 0) {
                y0 = 0;
            }
            int indexIn = input.startIndex + y * input.stride;
            int indexOut = output.startIndex + y * output.stride;
            for (int x = 0; x < input.width; ++x) {
                int x0 = x - radius;
                int x1 = x + radius + 1;
                if (x0 < 0) {
                    x0 = 0;
                    x1 = width;
                    if (x1 > input.width) {
                        x1 = input.width;
                    }
                } else if (x1 > input.width && (x0 = (x1 = input.width) - width) < 0) {
                    x0 = 0;
                }
                ImplEnhanceHistogram.localHistogram(input, x0, y0, x1, y1, histogram);
                int inputValue = input.data[indexIn++] & 0xFFFF;
                int sum = 0;
                for (int i = 0; i <= inputValue; ++i) {
                    sum += histogram[i];
                }
                int area = (y1 - y0) * (x1 - x0);
                output.data[indexOut++] = (short)(sum * maxValue / area);
            }
        }
    }

    public static void equalizeLocalInner(GrayU16 input, int radius, GrayU16 output, int[] histogram) {
        int width = 2 * radius + 1;
        int area = width * width;
        int maxValue = histogram.length - 1;
        for (int y = radius; y < input.height - radius; ++y) {
            ImplEnhanceHistogram.localHistogram(input, 0, y - radius, width, y + radius + 1, histogram);
            int inputValue = input.unsafe_get(radius, y);
            int sum = 0;
            for (int i = 0; i <= inputValue; ++i) {
                sum += histogram[i];
            }
            output.set(radius, y, sum * maxValue / area);
            int indexOld = input.startIndex + y * input.stride;
            int indexNew = indexOld + width;
            int indexIn = input.startIndex + y * input.stride + radius + 1;
            int indexOut = output.startIndex + y * output.stride + radius + 1;
            for (int x = radius + 1; x < input.width - radius; ++x) {
                int i;
                for (i = -radius; i <= radius; ++i) {
                    int n = input.data[indexOld + i * input.stride] & 0xFFFF;
                    histogram[n] = histogram[n] - 1;
                }
                for (i = -radius; i <= radius; ++i) {
                    int n = input.data[indexNew + i * input.stride] & 0xFFFF;
                    histogram[n] = histogram[n] + 1;
                }
                inputValue = input.data[indexIn++] & 0xFFFF;
                sum = 0;
                for (i = 0; i <= inputValue; ++i) {
                    sum += histogram[i];
                }
                output.data[indexOut++] = (short)(sum * maxValue / area);
                ++indexOld;
                ++indexNew;
            }
        }
    }

    public static void equalizeLocalRow(GrayU16 input, int radius, int startY, GrayU16 output, int[] histogram, int[] transform) {
        int inputValue;
        int indexOut;
        int indexIn;
        int y;
        int i;
        int width = 2 * radius + 1;
        int area = width * width;
        int maxValue = histogram.length - 1;
        int hist0 = startY;
        int hist1 = startY + width;
        if (hist1 > input.height) {
            hist1 = input.height;
            hist0 = hist1 - width;
        }
        int region0 = startY;
        int region1 = startY + radius;
        ImplEnhanceHistogram.localHistogram(input, 0, hist0, width, hist1, histogram);
        int sum = 0;
        for (i = 0; i < histogram.length; ++i) {
            transform[i] = sum += histogram[i];
        }
        for (y = region0; y < region1; ++y) {
            indexIn = input.startIndex + y * input.stride;
            indexOut = output.startIndex + y * output.stride;
            for (int x = 0; x <= radius; ++x) {
                inputValue = input.data[indexIn++] & 0xFF;
                output.data[indexOut++] = (short)(transform[inputValue] * maxValue / area);
            }
        }
        for (int x = radius + 1; x < input.width - radius - 1; ++x) {
            int y2;
            indexIn = input.startIndex + x - radius - 1;
            for (y2 = hist0; y2 < hist1; ++y2) {
                int n = input.data[indexIn + y2 * input.stride] & 0xFFFF;
                histogram[n] = histogram[n] - 1;
            }
            indexIn += width;
            for (y2 = hist0; y2 < hist1; ++y2) {
                int n = input.data[indexIn + y2 * input.stride] & 0xFFFF;
                histogram[n] = histogram[n] + 1;
            }
            sum = 0;
            for (int i2 = 0; i2 < histogram.length; ++i2) {
                transform[i2] = sum += histogram[i2];
            }
            indexIn = input.startIndex + region0 * input.stride + x;
            indexOut = output.startIndex + region0 * output.stride + x;
            for (int y3 = 0; y3 < radius; ++y3) {
                inputValue = input.data[indexIn] & 0xFF;
                output.data[indexOut] = (short)(transform[inputValue] * maxValue / area);
                indexIn += input.stride;
                indexOut += output.stride;
            }
        }
        ImplEnhanceHistogram.localHistogram(input, input.width - width, hist0, input.width, hist1, histogram);
        sum = 0;
        for (i = 0; i < histogram.length; ++i) {
            transform[i] = sum += histogram[i];
        }
        for (y = region0; y < region1; ++y) {
            int x;
            int indexIn2 = input.startIndex + y * input.stride + x;
            int indexOut2 = output.startIndex + y * output.stride + x;
            for (x = input.width - radius - 1; x < input.width; ++x) {
                inputValue = input.data[indexIn2++] & 0xFF;
                output.data[indexOut2++] = (short)(transform[inputValue] * maxValue / area);
            }
        }
    }

    public static void equalizeLocalCol(GrayU16 input, int radius, int startX, GrayU16 output, int[] histogram, int[] transform) {
        int width = 2 * radius + 1;
        int area = width * width;
        int maxValue = histogram.length - 1;
        int hist0 = startX;
        int hist1 = startX + width;
        if (hist1 > input.width) {
            hist1 = input.width;
            hist0 = hist1 - width;
        }
        ImplEnhanceHistogram.localHistogram(input, hist0, 0, hist1, width, histogram);
        int sum = 0;
        for (int i = 0; i < histogram.length; ++i) {
            transform[i] = sum += histogram[i];
        }
        int indexIn = input.startIndex + radius * input.stride + startX;
        int indexOut = output.startIndex + radius * output.stride + startX;
        for (int x = 0; x < radius; ++x) {
            int inputValue = input.data[indexIn++] & 0xFF;
            output.data[indexOut++] = (short)(transform[inputValue] * maxValue / area);
        }
        for (int y = radius + 1; y < input.height - radius; ++y) {
            int x;
            indexIn = input.startIndex + (y - radius - 1) * input.stride;
            for (x = hist0; x < hist1; ++x) {
                int n = input.data[indexIn + x] & 0xFFFF;
                histogram[n] = histogram[n] - 1;
            }
            indexIn += width * input.stride;
            for (x = hist0; x < hist1; ++x) {
                int n = input.data[indexIn + x] & 0xFFFF;
                histogram[n] = histogram[n] + 1;
            }
            sum = 0;
            for (int i = 0; i < histogram.length; ++i) {
                transform[i] = sum += histogram[i];
            }
            indexIn = input.startIndex + y * input.stride + startX;
            indexOut = output.startIndex + y * output.stride + startX;
            for (x = 0; x < radius; ++x) {
                int inputValue = input.data[indexIn++] & 0xFF;
                output.data[indexOut++] = (short)(transform[inputValue] * maxValue / area);
            }
        }
    }

    public static void localHistogram(GrayU16 input, int x0, int y0, int x1, int y1, int[] histogram) {
        int i;
        for (i = 0; i < histogram.length; ++i) {
            histogram[i] = 0;
        }
        for (i = y0; i < y1; ++i) {
            int index;
            int end = index + x1 - x0;
            for (index = input.startIndex + i * input.stride + x0; index < end; ++index) {
                int n = input.data[index] & 0xFFFF;
                histogram[n] = histogram[n] + 1;
            }
        }
    }
}

