/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.blur;

import boofcv.alg.filter.blur.BlurImageOps;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.Planar;

public class GBlurImageOps {
    public static <T extends ImageBase> T mean(T input, T output, int radius, ImageBase storage) {
        if (input instanceof GrayU8) {
            return (T)BlurImageOps.mean((GrayU8)input, (GrayU8)output, radius, (GrayU8)storage);
        }
        if (input instanceof GrayF32) {
            return (T)BlurImageOps.mean((GrayF32)input, (GrayF32)output, radius, (GrayF32)storage);
        }
        if (input instanceof GrayF64) {
            return (T)BlurImageOps.mean((GrayF64)input, (GrayF64)output, radius, (GrayF64)storage);
        }
        if (input instanceof Planar) {
            return (T)BlurImageOps.mean((Planar)input, (Planar)output, radius, (ImageGray)storage);
        }
        throw new IllegalArgumentException("Unsupported image type");
    }

    public static <T extends ImageBase> T median(T input, T output, int radius) {
        if (input instanceof GrayU8) {
            return (T)BlurImageOps.median((GrayU8)input, (GrayU8)output, radius);
        }
        if (input instanceof GrayF32) {
            return (T)BlurImageOps.median((GrayF32)input, (GrayF32)output, radius);
        }
        if (input instanceof Planar) {
            return (T)BlurImageOps.median((Planar)input, (Planar)output, radius);
        }
        throw new IllegalArgumentException("Unsupported image type");
    }

    public static <T extends ImageBase> T gaussian(T input, T output, double sigma, int radius, T storage) {
        if (input instanceof GrayU8) {
            return (T)BlurImageOps.gaussian((GrayU8)input, (GrayU8)output, sigma, radius, (GrayU8)storage);
        }
        if (input instanceof GrayF32) {
            return (T)BlurImageOps.gaussian((GrayF32)input, (GrayF32)output, sigma, radius, (GrayF32)storage);
        }
        if (input instanceof GrayF64) {
            return (T)BlurImageOps.gaussian((GrayF64)input, (GrayF64)output, sigma, radius, (GrayF64)storage);
        }
        if (input instanceof Planar) {
            return (T)BlurImageOps.gaussian((Planar)input, (Planar)output, sigma, radius, (ImageGray)storage);
        }
        throw new IllegalArgumentException("Unsupported image type: " + input.getClass().getSimpleName());
    }
}

