/*
 * Decompiled with CFR 0.152.
 */
package boofcv.testing;

import boofcv.struct.image.ImageGray;
import boofcv.testing.BoofTesting;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class CompareEquivalentFunctions {
    Class<?> testClass;
    Class<?> validationClass;
    protected Method methodTest;
    protected Method methodValidation;

    protected CompareEquivalentFunctions(Class<?> testClass, Class<?> validationClass) {
        this.testClass = testClass;
        this.validationClass = validationClass;
    }

    public void performTests(int numMethods) {
        Method[] methods = this.testClass.getMethods();
        int numFound = 0;
        for (Method m : methods) {
            if (!this.isTestMethod(m)) continue;
            Method[] candidates = this.validationClass.getMethods();
            boolean foundMatch = false;
            for (Method c : candidates) {
                if (!this.isEquivalent(c, m)) continue;
                foundMatch = true;
                this.compareMethods(m, c);
            }
            if (!foundMatch) {
                System.out.println("Can't find an equivalent function in validation class. " + m.getName());
                continue;
            }
            ++numFound;
        }
        if (numMethods != numFound) {
            throw new RuntimeException("Unexpected number of methods: Found " + numFound + "  expected " + numMethods);
        }
    }

    public void compareMethod(Method target, String validationName) {
        try {
            Method evaluation = this.validationClass.getMethod(validationName, target.getParameterTypes());
            this.compareMethods(target, evaluation);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private void compareMethods(Method target, Method validation) {
        this.methodTest = target;
        this.methodValidation = validation;
        Object[][] targetParamArray = this.createInputParam(target, validation);
        for (int i = 0; i < targetParamArray.length; ++i) {
            this.compareMethods(target, validation, targetParamArray[i]);
        }
    }

    private void compareMethods(Method target, Method validation, Object[] targetParam) {
        Object[] validationParam = this.reformatForValidation(validation, targetParam);
        Object[] targetParamSub = this.createSubImageInputs(targetParam);
        Object[] validationParamSub = this.createSubImageInputs(validationParam);
        try {
            Object targetResult = target.invoke(null, targetParam);
            Object validationResult = validation.invoke(null, validationParam);
            this.compareResults(targetResult, targetParam, validationResult, validationParam);
            targetResult = target.invoke(null, targetParamSub);
            validationResult = validation.invoke(null, validationParamSub);
            this.compareResults(targetResult, targetParamSub, validationResult, validationParamSub);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    protected Object[] createSubImageInputs(Object[] param) {
        Object[] ret = new Object[param.length];
        for (int i = 0; i < param.length; ++i) {
            if (param[i] == null) continue;
            ret[i] = ImageGray.class.isAssignableFrom(param[i].getClass()) ? BoofTesting.createSubImageOf((ImageGray)param[i]) : param[i];
        }
        return ret;
    }

    protected abstract boolean isTestMethod(Method var1);

    protected abstract boolean isEquivalent(Method var1, Method var2);

    protected abstract Object[][] createInputParam(Method var1, Method var2);

    protected abstract Object[] reformatForValidation(Method var1, Object[] var2);

    protected abstract void compareResults(Object var1, Object[] var2, Object var3, Object[] var4);
}

