/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.fiducial;

import boofcv.abst.fiducial.FiducialDetectorPnP;
import boofcv.abst.fiducial.calib.CalibrationDetectorChessboard;
import boofcv.abst.fiducial.calib.CalibrationDetectorCircleAsymmGrid;
import boofcv.abst.fiducial.calib.CalibrationDetectorSquareFiducialGrid;
import boofcv.abst.fiducial.calib.CalibrationDetectorSquareGrid;
import boofcv.abst.fiducial.calib.ConfigChessboard;
import boofcv.abst.fiducial.calib.ConfigCircleAsymmetricGrid;
import boofcv.abst.fiducial.calib.ConfigSquareGrid;
import boofcv.abst.fiducial.calib.ConfigSquareGridBinary;
import boofcv.abst.geo.calibration.DetectorFiducialCalibration;
import boofcv.alg.geo.calibration.CalibrationObservation;
import boofcv.core.image.GConvertImage;
import boofcv.factory.fiducial.FactoryFiducialCalibration;
import boofcv.struct.geo.Point2D3D;
import boofcv.struct.geo.PointIndex2D_F64;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import georegression.struct.point.Point2D_F64;
import java.util.ArrayList;
import java.util.List;

public class CalibrationFiducialDetector<T extends ImageGray>
extends FiducialDetectorPnP<T> {
    private DetectorFiducialCalibration detector;
    private boolean targetDetected;
    private GrayF32 converted;
    private ImageType<T> type;
    private List<Point2D3D> points2D3D;
    private double width;

    public CalibrationFiducialDetector(ConfigChessboard config, Class<T> imageType) {
        CalibrationDetectorChessboard detector = FactoryFiducialCalibration.chessboard(config);
        double sideWidth = (double)config.numCols * config.squareWidth;
        double sideHeight = (double)config.numRows * config.squareWidth;
        this.width = (sideWidth + sideHeight) / 2.0;
        this.init(detector, this.width, imageType);
    }

    public CalibrationFiducialDetector(ConfigSquareGrid config, Class<T> imageType) {
        CalibrationDetectorSquareGrid detector = FactoryFiducialCalibration.squareGrid(config);
        int squareCols = config.numCols;
        int squareRows = config.numRows;
        double sideWidth = (double)squareCols * config.squareWidth + (double)(squareCols - 1) * config.spaceWidth;
        double sideHeight = (double)squareRows * config.squareWidth + (double)(squareRows - 1) * config.spaceWidth;
        double width = (sideWidth + sideHeight) / 2.0;
        this.init(detector, width, imageType);
    }

    public CalibrationFiducialDetector(ConfigSquareGridBinary config, Class<T> imageType) {
        CalibrationDetectorSquareFiducialGrid detector = FactoryFiducialCalibration.binaryGrid(config);
        int squareCols = config.numCols;
        int squareRows = config.numRows;
        double sideWidth = (double)squareCols * config.squareWidth + (double)(squareCols - 1) * config.spaceWidth;
        double sideHeight = (double)squareRows * config.squareWidth + (double)(squareRows - 1) * config.spaceWidth;
        double width = (sideWidth + sideHeight) / 2.0;
        this.init(detector, width, imageType);
    }

    public CalibrationFiducialDetector(ConfigCircleAsymmetricGrid config, Class<T> imageType) {
        CalibrationDetectorCircleAsymmGrid detector = FactoryFiducialCalibration.circleAsymmGrid(config);
        int squareCols = config.numCols;
        int squareRows = config.numRows;
        double sideWidth = (double)squareCols * config.centerDistance / 2.0;
        double sideHeight = (double)squareRows * config.centerDistance / 2.0;
        double width = (sideWidth + sideHeight) / 2.0;
        this.init(detector, width, imageType);
    }

    protected void init(DetectorFiducialCalibration detector, double width, Class<T> imageType) {
        this.detector = detector;
        this.type = ImageType.single(imageType);
        this.converted = new GrayF32(1, 1);
        this.width = width;
        List layout = detector.getLayout();
        this.points2D3D = new ArrayList<Point2D3D>();
        for (int i = 0; i < layout.size(); ++i) {
            Point2D_F64 p2 = (Point2D_F64)layout.get(i);
            Point2D3D p = new Point2D3D();
            p.location.set(p2.x, p2.y, 0.0);
            this.points2D3D.add(p);
        }
    }

    @Override
    public void detect(T input) {
        if (input instanceof GrayF32) {
            this.converted = (GrayF32)input;
        } else {
            this.converted.reshape(((ImageGray)input).width, ((ImageGray)input).height);
            GConvertImage.convert(input, (ImageBase)this.converted);
        }
        if (!this.detector.process(this.converted)) {
            this.targetDetected = false;
            return;
        }
        this.targetDetected = true;
    }

    @Override
    public void getImageLocation(int which, Point2D_F64 location) {
        CalibrationObservation view = this.detector.getDetectedPoints();
        location.set(0.0, 0.0);
        for (int i = 0; i < view.size(); ++i) {
            PointIndex2D_F64 p = view.get(i);
            location.x += p.x;
            location.y += p.y;
        }
        location.x /= (double)view.size();
        location.y /= (double)view.size();
    }

    @Override
    public int totalFound() {
        return this.targetDetected ? 1 : 0;
    }

    @Override
    public long getId(int which) {
        return 0L;
    }

    @Override
    public String getMessage(int which) {
        return null;
    }

    @Override
    public ImageType<T> getInputType() {
        return this.type;
    }

    public List<Point2D_F64> getCalibrationPoints() {
        return this.detector.getLayout();
    }

    public DetectorFiducialCalibration getCalibDetector() {
        return this.detector;
    }

    public List<Point2D3D> getPoints2D3D() {
        return this.points2D3D;
    }

    @Override
    public double getWidth(int which) {
        return this.width;
    }

    @Override
    public boolean hasUniqueID() {
        return false;
    }

    @Override
    public boolean hasMessage() {
        return false;
    }

    @Override
    protected List<PointIndex2D_F64> getDetectedControl(int which) {
        CalibrationObservation view = this.getCalibDetector().getDetectedPoints();
        return view.points;
    }

    @Override
    protected List<Point2D3D> getControl3D(int which) {
        return this.getPoints2D3D();
    }
}

