/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.fiducial;

import boofcv.abst.fiducial.FiducialDetectorPnP;
import boofcv.alg.distort.LensDistortionNarrowFOV;
import boofcv.alg.fiducial.square.BaseDetectFiducialSquare;
import boofcv.alg.fiducial.square.FoundFiducial;
import boofcv.alg.fiducial.square.QuadPoseEstimator;
import boofcv.struct.distort.DoNothing2Transform2_F64;
import boofcv.struct.distort.Point2Transform2_F64;
import boofcv.struct.geo.Point2D3D;
import boofcv.struct.geo.PointIndex2D_F64;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import georegression.geometry.UtilLine2D_F64;
import georegression.metric.Intersection2D_F64;
import georegression.struct.line.LineGeneral2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.se.Se3_F64;
import georegression.struct.shapes.Quadrilateral_F64;
import java.util.ArrayList;
import java.util.List;

public abstract class SquareBase_to_FiducialDetector<T extends ImageGray, Detector extends BaseDetectFiducialSquare<T>>
extends FiducialDetectorPnP<T> {
    Detector alg;
    ImageType<T> type;
    Quadrilateral_F64 undistQuad = new Quadrilateral_F64();
    private LineGeneral2D_F64 line02 = new LineGeneral2D_F64();
    private LineGeneral2D_F64 line13 = new LineGeneral2D_F64();
    protected Point2Transform2_F64 distToUndist = new DoNothing2Transform2_F64();
    protected Point2Transform2_F64 undistToDist = new DoNothing2Transform2_F64();
    QuadPoseEstimator poseEstimator = new QuadPoseEstimator(1.0E-6, 200);
    Quadrilateral_F64 quad = new Quadrilateral_F64();
    List<PointIndex2D_F64> listQuad = new ArrayList<PointIndex2D_F64>();
    List<Point2D3D> points2D3D;

    public SquareBase_to_FiducialDetector(Detector alg) {
        this.alg = alg;
        this.type = ImageType.single(((BaseDetectFiducialSquare)alg).getInputType());
        this.poseEstimator.setFiducial(-0.5, 0.5, 0.5, 0.5, 0.5, -0.5, -0.5, -0.5);
        this.points2D3D = this.poseEstimator.createCopyPoints2D3D();
        for (int i = 0; i < 4; ++i) {
            this.listQuad.add(new PointIndex2D_F64());
            this.listQuad.get((int)i).index = i;
        }
    }

    @Override
    public void detect(T input) {
        ((BaseDetectFiducialSquare)this.alg).process(input);
    }

    @Override
    public void getImageLocation(int which, Point2D_F64 location) {
        FoundFiducial f = (FoundFiducial)((BaseDetectFiducialSquare)this.alg).getFound().get(which);
        this.distToUndist.compute(f.distortedPixels.a.x, f.distortedPixels.a.y, this.undistQuad.a);
        this.distToUndist.compute(f.distortedPixels.b.x, f.distortedPixels.b.y, this.undistQuad.b);
        this.distToUndist.compute(f.distortedPixels.c.x, f.distortedPixels.c.y, this.undistQuad.c);
        this.distToUndist.compute(f.distortedPixels.d.x, f.distortedPixels.d.y, this.undistQuad.d);
        UtilLine2D_F64.convert((Point2D_F64)this.undistQuad.a, (Point2D_F64)this.undistQuad.c, (LineGeneral2D_F64)this.line02);
        UtilLine2D_F64.convert((Point2D_F64)this.undistQuad.b, (Point2D_F64)this.undistQuad.d, (LineGeneral2D_F64)this.line13);
        Intersection2D_F64.intersection((LineGeneral2D_F64)this.line02, (LineGeneral2D_F64)this.line13, (Point2D_F64)location);
        this.undistToDist.compute(location.x, location.y, location);
    }

    @Override
    protected boolean estimatePose(int which, List<Point2D3D> points, Se3_F64 fiducialToCamera) {
        this.quad.a.set(points.get((int)0).observation);
        this.quad.b.set(points.get((int)1).observation);
        this.quad.c.set(points.get((int)2).observation);
        this.quad.d.set(points.get((int)3).observation);
        if (!this.poseEstimator.process(this.quad)) {
            return false;
        }
        fiducialToCamera.set(this.poseEstimator.getWorldToCamera());
        double width = this.getWidth(which);
        fiducialToCamera.T.x *= width;
        fiducialToCamera.T.y *= width;
        fiducialToCamera.T.z *= width;
        return true;
    }

    @Override
    public void setLensDistortion(LensDistortionNarrowFOV distortion) {
        super.setLensDistortion(distortion);
        if (distortion == null) {
            this.distToUndist = new DoNothing2Transform2_F64();
            this.undistToDist = new DoNothing2Transform2_F64();
        } else {
            this.poseEstimator.setLensDistoriton(distortion);
            this.distToUndist = distortion.undistort_F64(true, true);
            this.undistToDist = distortion.distort_F64(true, true);
        }
    }

    @Override
    public int totalFound() {
        return ((BaseDetectFiducialSquare)this.alg).getFound().size;
    }

    @Override
    public long getId(int which) {
        return ((FoundFiducial)((BaseDetectFiducialSquare)this.alg).getFound().get((int)which)).id;
    }

    @Override
    public String getMessage(int which) {
        return null;
    }

    @Override
    public boolean hasUniqueID() {
        return true;
    }

    @Override
    public boolean hasMessage() {
        return false;
    }

    @Override
    public ImageType<T> getInputType() {
        return this.type;
    }

    public Detector getAlgorithm() {
        return this.alg;
    }

    @Override
    protected List<PointIndex2D_F64> getDetectedControl(int which) {
        FoundFiducial found = (FoundFiducial)((BaseDetectFiducialSquare)this.getAlgorithm()).getFound().get(which);
        this.listQuad.get(0).set(found.distortedPixels.a);
        this.listQuad.get(1).set(found.distortedPixels.b);
        this.listQuad.get(2).set(found.distortedPixels.c);
        this.listQuad.get(3).set(found.distortedPixels.d);
        return this.listQuad;
    }

    @Override
    protected List<Point2D3D> getControl3D(int which) {
        return this.points2D3D;
    }
}

